/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.cms.CMSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSReadable;
import com.aspose.html.internal.ms.core.bc.cms.CMSTypedData;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMSProcessableFile
implements CMSReadable,
CMSTypedData {
    private static final int DEFAULT_BUF_SIZE = 32768;
    private final ASN1ObjectIdentifier type;
    private final File file;
    private final byte[] buf;

    public CMSProcessableFile(File file) {
        this(file, 32768);
    }

    public CMSProcessableFile(File file, int bufSize) {
        this(CMSObjectIdentifiers.data, file, bufSize);
    }

    public CMSProcessableFile(ASN1ObjectIdentifier type, File file, int bufSize) {
        this.type = type;
        this.file = file;
        this.buf = new byte[bufSize];
    }

    public InputStream getInputStream() throws IOException, CMSException {
        return new BufferedInputStream(new FileInputStream(this.file), 32768);
    }

    public void write(OutputStream zOut) throws IOException, CMSException {
        int n2;
        FileInputStream fileInputStream = new FileInputStream(this.file);
        while ((n2 = fileInputStream.read(this.buf, 0, this.buf.length)) > 0) {
            zOut.write(this.buf, 0, n2);
        }
        fileInputStream.close();
    }

    public Object getContent() {
        return this.file;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }
}

