/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1InputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Set;
import com.aspose.html.internal.ms.core.bc.asn1.BERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERSet;
import com.aspose.html.internal.ms.core.bc.asn1.cms.ContentInfo;
import com.aspose.html.internal.ms.core.bc.asn1.cms.SignedData;
import com.aspose.html.internal.ms.core.bc.asn1.cms.SignerInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cert.X509AttributeCertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.X509CRLHolder;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSProcessable;
import com.aspose.html.internal.ms.core.bc.cms.CMSProcessableByteArray;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignedHelper;
import com.aspose.html.internal.ms.core.bc.cms.CMSTypedData;
import com.aspose.html.internal.ms.core.bc.cms.CMSUtils;
import com.aspose.html.internal.ms.core.bc.cms.PKCS7ProcessableObject;
import com.aspose.html.internal.ms.core.bc.cms.SignerInformation;
import com.aspose.html.internal.ms.core.bc.cms.SignerInformationStore;
import com.aspose.html.internal.ms.core.bc.cms.SignerInformationVerifier;
import com.aspose.html.internal.ms.core.bc.cms.SignerInformationVerifierProvider;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import com.aspose.html.internal.ms.core.bc.util.Encodable;
import com.aspose.html.internal.ms.core.bc.util.Store;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSSignedData
implements Encodable {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    SignedData signedData;
    ContentInfo contentInfo;
    CMSTypedData signedContent;
    SignerInformationStore signerInfoStore;
    private Map hashes;

    private CMSSignedData(CMSSignedData c2) {
        this.signedData = c2.signedData;
        this.contentInfo = c2.contentInfo;
        this.signedContent = c2.signedContent;
        this.signerInfoStore = c2.signerInfoStore;
    }

    public CMSSignedData(byte[] sigBlock) throws CMSException {
        this(CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(CMSProcessable signedContent, byte[] sigBlock) throws CMSException {
        this(signedContent, CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(Map hashes, byte[] sigBlock) throws CMSException {
        this(hashes, CMSUtils.readContentInfo(sigBlock));
    }

    public CMSSignedData(CMSProcessable signedContent, InputStream sigData) throws CMSException {
        this(signedContent, CMSUtils.readContentInfo((InputStream)new ASN1InputStream(sigData)));
    }

    public CMSSignedData(InputStream sigData) throws CMSException {
        this(CMSUtils.readContentInfo(sigData));
    }

    public CMSSignedData(final CMSProcessable signedContent, ContentInfo sigData) throws CMSException {
        this.signedContent = signedContent instanceof CMSTypedData ? (CMSTypedData)signedContent : new CMSTypedData(){

            public ASN1ObjectIdentifier getContentType() {
                return CMSSignedData.this.signedData.getEncapContentInfo().getContentType();
            }

            public void write(OutputStream out) throws IOException, CMSException {
                signedContent.write(out);
            }

            public Object getContent() {
                return signedContent.getContent();
            }
        };
        this.contentInfo = sigData;
        this.signedData = this.getSignedData();
    }

    public CMSSignedData(Map hashes, ContentInfo sigData) throws CMSException {
        this.hashes = hashes;
        this.contentInfo = sigData;
        this.signedData = this.getSignedData();
    }

    public CMSSignedData(ContentInfo sigData) throws CMSException {
        this.contentInfo = sigData;
        this.signedData = this.getSignedData();
        ASN1Encodable aSN1Encodable = this.signedData.getEncapContentInfo().getContent();
        this.signedContent = aSN1Encodable != null ? (aSN1Encodable instanceof ASN1OctetString ? new CMSProcessableByteArray(this.signedData.getEncapContentInfo().getContentType(), ((ASN1OctetString)aSN1Encodable).getOctets()) : new PKCS7ProcessableObject(this.signedData.getEncapContentInfo().getContentType(), aSN1Encodable)) : null;
    }

    private SignedData getSignedData() throws CMSException {
        try {
            return SignedData.getInstance(this.contentInfo.getContent());
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public int getVersion() {
        return this.signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set aSN1Set = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            for (int i2 = 0; i2 != aSN1Set.size(); ++i2) {
                SignerInfo signerInfo = SignerInfo.getInstance(aSN1Set.getObjectAt(i2));
                ASN1ObjectIdentifier aSN1ObjectIdentifier = this.signedData.getEncapContentInfo().getContentType();
                if (this.hashes == null) {
                    arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, this.signedContent, null));
                    continue;
                }
                Object k2 = this.hashes.keySet().iterator().next();
                byte[] byArray = k2 instanceof String ? (byte[])this.hashes.get(signerInfo.getDigestAlgorithm().getAlgorithm().getId()) : (byte[])this.hashes.get(signerInfo.getDigestAlgorithm().getAlgorithm());
                arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, null, byArray));
            }
            this.signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this.signerInfoStore;
    }

    public boolean isDetachedSignature() {
        return this.signedData.getEncapContentInfo().getContent() == null && this.signedData.getSignerInfos().size() > 0;
    }

    public boolean isCertificateManagementMessage() {
        return this.signedData.getEncapContentInfo().getContent() == null && this.signedData.getSignerInfos().size() == 0;
    }

    public Store<X509CertificateHolder> getCertificates() {
        return HELPER.getCertificates(this.signedData.getCertificates());
    }

    public Store<X509CRLHolder> getCRLs() {
        return HELPER.getCRLs(this.signedData.getCRLs());
    }

    public Store<X509AttributeCertificateHolder> getAttributeCertificates() {
        return HELPER.getAttributeCertificates(this.signedData.getCertificates());
    }

    public Store getOtherRevocationInfo(ASN1ObjectIdentifier otherRevocationInfoFormat) {
        return HELPER.getOtherRevocationInfo(otherRevocationInfoFormat, this.signedData.getCRLs());
    }

    public Set<AlgorithmIdentifier> getDigestAlgorithmIDs() {
        HashSet<AlgorithmIdentifier> hashSet = new HashSet<AlgorithmIdentifier>(this.signedData.getDigestAlgorithms().size());
        Enumeration enumeration = this.signedData.getDigestAlgorithms().getObjects();
        while (enumeration.hasMoreElements()) {
            hashSet.add(AlgorithmIdentifier.getInstance(enumeration.nextElement()));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSTypedData getSignedContent() {
        return this.signedContent;
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public boolean verifySignatures(SignerInformationVerifierProvider verifierProvider) throws CMSException {
        return this.verifySignatures(verifierProvider, false);
    }

    public boolean verifySignatures(SignerInformationVerifierProvider verifierProvider, boolean ignoreCounterSignatures) throws CMSException {
        Collection<SignerInformation> collection = this.getSignerInfos().getSigners();
        for (SignerInformation signerInformation : collection) {
            try {
                SignerInformationVerifier signerInformationVerifier = verifierProvider.get(signerInformation.getSID());
                if (!signerInformation.verify(signerInformationVerifier)) {
                    return false;
                }
                if (ignoreCounterSignatures) continue;
                Collection<SignerInformation> collection2 = signerInformation.getCounterSignatures().getSigners();
                Iterator<SignerInformation> iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    if (this.verifyCounterSignature(iterator.next(), verifierProvider)) continue;
                    return false;
                }
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("failure in verifier provider: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        }
        return true;
    }

    private boolean verifyCounterSignature(SignerInformation counterSigner, SignerInformationVerifierProvider verifierProvider) throws OperatorCreationException, CMSException {
        SignerInformationVerifier signerInformationVerifier = verifierProvider.get(counterSigner.getSID());
        if (!counterSigner.verify(signerInformationVerifier)) {
            return false;
        }
        Collection<SignerInformation> collection = counterSigner.getCounterSignatures().getSigners();
        Iterator<SignerInformation> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.verifyCounterSignature(iterator.next(), verifierProvider)) continue;
            return false;
        }
        return true;
    }

    public static CMSSignedData replaceSigners(CMSSignedData signedData, SignerInformationStore signerInformationStore) {
        CMSSignedData cMSSignedData = new CMSSignedData(signedData);
        cMSSignedData.signerInfoStore = signerInformationStore;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (SignerInformation object2 : signerInformationStore.getSigners()) {
            aSN1EncodableVector.add(CMSSignedHelper.INSTANCE.fixAlgID(object2.getDigestAlgorithmID()));
            aSN1EncodableVector2.add(object2.toASN1Structure());
        }
        DERSet dERSet = new DERSet(aSN1EncodableVector);
        DERSet dERSet2 = new DERSet(aSN1EncodableVector2);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)signedData.signedData.toASN1Primitive();
        aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(aSN1Sequence.getObjectAt(0));
        aSN1EncodableVector2.add(dERSet);
        for (int i2 = 2; i2 != aSN1Sequence.size() - 1; ++i2) {
            aSN1EncodableVector2.add(aSN1Sequence.getObjectAt(i2));
        }
        aSN1EncodableVector2.add(dERSet2);
        cMSSignedData.signedData = SignedData.getInstance(new BERSequence(aSN1EncodableVector2));
        cMSSignedData.contentInfo = new ContentInfo(cMSSignedData.contentInfo.getContentType(), cMSSignedData.signedData);
        return cMSSignedData;
    }

    public static CMSSignedData replaceCertificatesAndCRLs(CMSSignedData signedData, Store certificates, Store attrCerts, Store revocations) throws CMSException {
        Iterable iterable;
        CMSSignedData cMSSignedData = new CMSSignedData(signedData);
        ASN1Set aSN1Set = null;
        Iterable iterable2 = null;
        if (certificates != null || attrCerts != null) {
            ASN1Set aSN1Set2;
            iterable = new ArrayList();
            if (certificates != null) {
                iterable.addAll(CMSUtils.getCertificatesFromStore(certificates));
            }
            if (attrCerts != null) {
                iterable.addAll(CMSUtils.getAttributeCertificatesFromStore(attrCerts));
            }
            if ((aSN1Set2 = CMSUtils.createBerSetFromList(iterable)).size() != 0) {
                aSN1Set = aSN1Set2;
            }
        }
        if (revocations != null && ((ASN1Set)(iterable = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(revocations)))).size() != 0) {
            iterable2 = iterable;
        }
        cMSSignedData.signedData = new SignedData(signedData.signedData.getDigestAlgorithms(), signedData.signedData.getEncapContentInfo(), aSN1Set, (ASN1Set)iterable2, signedData.signedData.getSignerInfos());
        cMSSignedData.contentInfo = new ContentInfo(cMSSignedData.contentInfo.getContentType(), cMSSignedData.signedData);
        return cMSSignedData;
    }
}

