/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1TaggedObject;
import com.aspose.html.internal.ms.core.bc.asn1.BERSequenceGenerator;
import com.aspose.html.internal.ms.core.bc.asn1.BERTaggedObject;
import com.aspose.html.internal.ms.core.bc.asn1.DERSet;
import com.aspose.html.internal.ms.core.bc.asn1.cms.CMSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.cms.SignerInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignedGenerator;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignedHelper;
import com.aspose.html.internal.ms.core.bc.cms.CMSStreamException;
import com.aspose.html.internal.ms.core.bc.cms.CMSUtils;
import com.aspose.html.internal.ms.core.bc.cms.SignerInfoGenerator;
import com.aspose.html.internal.ms.core.bc.cms.SignerInformation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private int _bufferSize;

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public OutputStream open(OutputStream out) throws IOException {
        return this.open(out, false);
    }

    public OutputStream open(OutputStream out, boolean encapsulate) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, encapsulate);
    }

    public OutputStream open(OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, encapsulate, dataOutputStream);
    }

    public OutputStream open(ASN1ObjectIdentifier eContentType, OutputStream out, boolean encapsulate) throws IOException {
        return this.open(eContentType, out, encapsulate, null);
    }

    public OutputStream open(ASN1ObjectIdentifier eContentType, OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        Object object;
        Object object22;
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(out);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(this.calculateVersion(eContentType));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (Object object22 : this._signers) {
            object = CMSSignedHelper.INSTANCE.fixAlgID(((SignerInformation)object22).getDigestAlgorithmID());
            aSN1EncodableVector.add((ASN1Encodable)object);
        }
        for (Object object22 : this.signerGens) {
            aSN1EncodableVector.add(((SignerInfoGenerator)object22).getDigestAlgorithm());
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(eContentType);
        object22 = encapsulate ? CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, true, this._bufferSize) : null;
        object = CMSUtils.getSafeTeeOutputStream(dataOutputStream, (OutputStream)object22);
        OutputStream outputStream = CMSUtils.attachSignersToOutputStream(this.signerGens, (OutputStream)object);
        return new CmsSignedDataOutputStream(outputStream, eContentType, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
    }

    public List<AlgorithmIdentifier> getDigestAlgorithms() {
        ArrayList<AlgorithmIdentifier> arrayList = new ArrayList<AlgorithmIdentifier>();
        for (Object object : this._signers) {
            AlgorithmIdentifier algorithmIdentifier = CMSSignedHelper.INSTANCE.fixAlgID(((SignerInformation)object).getDigestAlgorithmID());
            arrayList.add(algorithmIdentifier);
        }
        for (Object object : this.signerGens) {
            arrayList.add(((SignerInfoGenerator)object).getDigestAlgorithm());
        }
        return arrayList;
    }

    private ASN1Integer calculateVersion(ASN1ObjectIdentifier contentOid) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (this.certs != null) {
            for (Object e2 : this.certs) {
                if (!(e2 instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)e2;
                if (aSN1TaggedObject.getTagNo() == 1) {
                    bl4 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() == 2) {
                    bl5 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() != 3) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return new ASN1Integer(5L);
        }
        if (this.crls != null) {
            for (Object e2 : this.crls) {
                if (!(e2 instanceof ASN1TaggedObject)) continue;
                bl3 = true;
            }
        }
        if (bl3) {
            return new ASN1Integer(5L);
        }
        if (bl5) {
            return new ASN1Integer(4L);
        }
        if (bl4) {
            return new ASN1Integer(3L);
        }
        if (this.checkForVersion3(this._signers, this.signerGens)) {
            return new ASN1Integer(3L);
        }
        if (!CMSObjectIdentifiers.data.equals(contentOid)) {
            return new ASN1Integer(3L);
        }
        return new ASN1Integer(1L);
    }

    private boolean checkForVersion3(List signerInfos, List signerInfoGens) {
        Iterator iterator = signerInfos.iterator();
        while (iterator.hasNext()) {
            Object object = SignerInfo.getInstance(((SignerInformation)iterator.next()).toASN1Structure());
            if (((SignerInfo)object).getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        for (Object object : signerInfoGens) {
            if (((SignerInfoGenerator)object).getGeneratedVersion() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private ASN1ObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream out, ASN1ObjectIdentifier contentOID, BERSequenceGenerator sGen, BERSequenceGenerator sigGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._contentOID = contentOID;
            this._sGen = sGen;
            this._sigGen = sigGen;
            this._eiGen = eiGen;
        }

        public void write(int b2) throws IOException {
            this._out.write(b2);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        public void close() throws IOException {
            Object object;
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this.digests.clear();
            if (CMSSignedDataStreamGenerator.this.certs.size() != 0) {
                object = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, (ASN1Encodable)object).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this.crls.size() != 0) {
                object = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, (ASN1Encodable)object).getEncoded());
            }
            object = new ASN1EncodableVector();
            for (Object object2 : CMSSignedDataStreamGenerator.this.signerGens) {
                try {
                    ((ASN1EncodableVector)object).add(((SignerInfoGenerator)object2).generate(this._contentOID));
                    byte[] byArray = ((SignerInfoGenerator)object2).getCalculatedDigest();
                    CMSSignedDataStreamGenerator.this.digests.put(((SignerInfoGenerator)object2).getDigestAlgorithm().getAlgorithm().getId(), byArray);
                }
                catch (CMSException cMSException) {
                    throw new CMSStreamException("exception generating signers: " + cMSException.getMessage(), cMSException);
                }
            }
            for (Object object2 : CMSSignedDataStreamGenerator.this._signers) {
                ((ASN1EncodableVector)object).add(((SignerInformation)object2).toASN1Structure());
            }
            this._sigGen.getRawOutputStream().write(new DERSet((ASN1EncodableVector)object).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }
}

