/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.cert.selector.X509CertificateHolderSelector;
import com.aspose.html.internal.ms.core.bc.cms.KeyTransRecipientInformation;
import com.aspose.html.internal.ms.core.bc.cms.RecipientId;
import java.math.BigInteger;

public class KeyTransRecipientId
extends RecipientId {
    private X509CertificateHolderSelector baseSelector;

    private KeyTransRecipientId(X509CertificateHolderSelector baseSelector) {
        super(0);
        this.baseSelector = baseSelector;
    }

    public KeyTransRecipientId(byte[] subjectKeyId) {
        this(null, null, subjectKeyId);
    }

    public KeyTransRecipientId(X500Name issuer, BigInteger serialNumber) {
        this(issuer, serialNumber, null);
    }

    public KeyTransRecipientId(X500Name issuer, BigInteger serialNumber, byte[] subjectKeyId) {
        this(new X509CertificateHolderSelector(issuer, serialNumber, subjectKeyId));
    }

    public X500Name getIssuer() {
        return this.baseSelector.getIssuer();
    }

    public BigInteger getSerialNumber() {
        return this.baseSelector.getSerialNumber();
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.baseSelector.getSubjectKeyIdentifier();
    }

    public int hashCode() {
        return this.baseSelector.hashCode();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof KeyTransRecipientId)) {
            return false;
        }
        KeyTransRecipientId keyTransRecipientId = (KeyTransRecipientId)o2;
        return this.baseSelector.equals(keyTransRecipientId.baseSelector);
    }

    public Object clone() {
        return new KeyTransRecipientId(this.baseSelector);
    }

    public boolean match(Object obj) {
        if (obj instanceof KeyTransRecipientInformation) {
            return ((KeyTransRecipientInformation)obj).getRID().equals(this);
        }
        return this.baseSelector.match(obj);
    }
}

