/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.cms.IssuerAndSerialNumber;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.JcaX509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cms.KeyTransRecipientInfoGenerator;
import com.aspose.html.internal.ms.core.bc.operator.AsymmetricKeyWrapper;
import com.aspose.html.internal.ms.core.bc.operator.jcajce.JceAsymmetricKeyWrapper;
import com.aspose.html.internal.ms.core.bc.operator.jcajce.JceKTSKeyWrapper;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.io.IOException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JceKTSKeyTransRecipientInfoGenerator
extends KeyTransRecipientInfoGenerator {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode("0c14416e6f6e796d6f75732053656e64657220202020");

    private JceKTSKeyTransRecipientInfoGenerator(X509Certificate recipientCert, IssuerAndSerialNumber recipientID, String symmetricWrappingAlg, int keySizeInBits) throws CertificateEncodingException {
        super(recipientID, (AsymmetricKeyWrapper)new JceKTSKeyWrapper(recipientCert, symmetricWrappingAlg, keySizeInBits, ANONYMOUS_SENDER, JceKTSKeyTransRecipientInfoGenerator.getEncodedRecipID(recipientID)));
    }

    public JceKTSKeyTransRecipientInfoGenerator(X509Certificate recipientCert, String symmetricWrappingAlg, int keySizeInBits) throws CertificateEncodingException {
        this(recipientCert, new IssuerAndSerialNumber(new JcaX509CertificateHolder(recipientCert).toASN1Structure()), symmetricWrappingAlg, keySizeInBits);
    }

    public JceKTSKeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, PublicKey publicKey, String symmetricWrappingAlg, int keySizeInBits) {
        super(subjectKeyIdentifier, (AsymmetricKeyWrapper)new JceKTSKeyWrapper(publicKey, symmetricWrappingAlg, keySizeInBits, ANONYMOUS_SENDER, JceKTSKeyTransRecipientInfoGenerator.getEncodedSubKeyId(subjectKeyIdentifier)));
    }

    private static byte[] getEncodedRecipID(IssuerAndSerialNumber recipientID) throws CertificateEncodingException {
        try {
            return recipientID.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("Cannot process extracted IssuerAndSerialNumber: " + iOException.getMessage()){

                public Throwable getCause() {
                    return iOException;
                }
            };
        }
    }

    private static byte[] getEncodedSubKeyId(byte[] subjectKeyIdentifier) {
        try {
            return new DEROctetString(subjectKeyIdentifier).getEncoded();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot process subject key identifier: " + iOException.getMessage()){

                public Throwable getCause() {
                    return iOException;
                }
            };
        }
    }

    public JceKTSKeyTransRecipientInfoGenerator(X509Certificate recipientCert, AlgorithmIdentifier algorithmIdentifier) throws CertificateEncodingException {
        super(new IssuerAndSerialNumber(new JcaX509CertificateHolder(recipientCert).toASN1Structure()), (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper(algorithmIdentifier, recipientCert.getPublicKey()));
    }

    public JceKTSKeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) {
        super(subjectKeyIdentifier, (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper(algorithmIdentifier, publicKey));
    }

    public JceKTSKeyTransRecipientInfoGenerator setProvider(String providerName) {
        ((JceKTSKeyWrapper)this.wrapper).setProvider(providerName);
        return this;
    }

    public JceKTSKeyTransRecipientInfoGenerator setProvider(Provider provider) {
        ((JceKTSKeyWrapper)this.wrapper).setProvider(provider);
        return this;
    }
}

