/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.RSAPrivateKey;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricRSAKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Permissions;
import java.io.IOException;
import java.math.BigInteger;

public final class AsymmetricRSAPrivateKey
extends AsymmetricRSAKey
implements AsymmetricPrivateKey {
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger p;
    private BigInteger q;
    private BigInteger dp;
    private BigInteger dq;
    private BigInteger qInv;
    private final int hashCode;

    public AsymmetricRSAPrivateKey(Algorithm algorithm, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        super(algorithm, bigInteger);
        this.publicExponent = bigInteger2;
        this.privateExponent = bigInteger3;
        this.p = bigInteger4;
        this.q = bigInteger5;
        this.dp = bigInteger6;
        this.dq = bigInteger7;
        this.qInv = bigInteger8;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, BigInteger bigInteger, BigInteger bigInteger2) {
        super(algorithm, bigInteger);
        this.privateExponent = bigInteger2;
        this.publicExponent = BigInteger.ZERO;
        this.p = BigInteger.ZERO;
        this.q = BigInteger.ZERO;
        this.dp = BigInteger.ZERO;
        this.dq = BigInteger.ZERO;
        this.qInv = BigInteger.ZERO;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, AsymmetricRSAPrivateKey.getPrivateKeyInfo(byArray));
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        this(algorithm, privateKeyInfo.getPrivateKeyAlgorithm(), AsymmetricRSAPrivateKey.parsePrivateKey(privateKeyInfo));
    }

    private static PrivateKeyInfo getPrivateKeyInfo(byte[] byArray) {
        try {
            return PrivateKeyInfo.getInstance(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return new PrivateKeyInfo(DEF_ALG_ID, ASN1Sequence.getInstance(byArray));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Unable to parse private key: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }

    private static RSAPrivateKey parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return RSAPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse private key: " + iOException.getMessage(), iOException);
        }
    }

    private AsymmetricRSAPrivateKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier, RSAPrivateKey rSAPrivateKey) {
        super(algorithm, algorithmIdentifier, KeyUtils.validatedModulus(rSAPrivateKey.getModulus()));
        this.publicExponent = rSAPrivateKey.getPublicExponent();
        this.privateExponent = rSAPrivateKey.getPrivateExponent();
        this.p = rSAPrivateKey.getPrime1();
        this.q = rSAPrivateKey.getPrime2();
        this.dp = rSAPrivateKey.getExponent1();
        this.dq = rSAPrivateKey.getExponent2();
        this.qInv = rSAPrivateKey.getCoefficient();
        this.hashCode = this.calculateHashCode();
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrivateExponent() {
        this.checkCanRead();
        return this.privateExponent;
    }

    public BigInteger getP() {
        this.checkCanRead();
        return this.p;
    }

    public BigInteger getQ() {
        this.checkCanRead();
        return this.q;
    }

    public BigInteger getDP() {
        this.checkCanRead();
        return this.dp;
    }

    public BigInteger getDQ() {
        this.checkCanRead();
        return this.dq;
    }

    public BigInteger getQInv() {
        this.checkCanRead();
        return this.qInv;
    }

    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        return KeyUtils.getEncodedPrivateKeyInfo(this.rsaAlgIdentifier, new RSAPrivateKey(this.getModulus(), this.publicExponent, this.getPrivateExponent(), this.getP(), this.getQ(), this.getDP(), this.getDQ(), this.getQInv()));
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricRSAPrivateKey)) {
            return false;
        }
        AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = (AsymmetricRSAPrivateKey)object;
        return this.getModulus().equals(asymmetricRSAPrivateKey.getModulus()) && this.privateExponent.equals(asymmetricRSAPrivateKey.privateExponent) && this.getPublicExponent().equals(asymmetricRSAPrivateKey.getPublicExponent()) && this.p.equals(asymmetricRSAPrivateKey.p) && this.q.equals(asymmetricRSAPrivateKey.q) && this.dp.equals(asymmetricRSAPrivateKey.dp) && this.dq.equals(asymmetricRSAPrivateKey.dq) && this.qInv.equals(asymmetricRSAPrivateKey.qInv);
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n2 = this.getModulus().hashCode();
        n2 = 31 * n2 + this.publicExponent.hashCode();
        n2 = 31 * n2 + this.privateExponent.hashCode();
        n2 = 31 * n2 + this.p.hashCode();
        n2 = 31 * n2 + this.q.hashCode();
        n2 = 31 * n2 + this.dp.hashCode();
        n2 = 31 * n2 + this.dq.hashCode();
        n2 = 31 * n2 + this.qInv.hashCode();
        return n2;
    }

    protected void zeroize() {
        this.privateExponent = null;
        this.qInv = null;
        this.dq = null;
        this.dp = null;
        this.q = null;
        this.p = null;
        super.zeroize();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.zeroize();
    }

    private void checkCanRead() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
    }
}

