/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.fips;

import com.aspose.html.internal.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.BasicAgreement;
import com.aspose.html.internal.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.math.ec.ECPoint;
import java.math.BigInteger;

class EcDhBasicAgreement
implements BasicAgreement {
    EcPrivateKeyParameters key;

    EcDhBasicAgreement() {
    }

    public void init(CipherParameters cipherParameters) {
        this.key = (EcPrivateKeyParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)cipherParameters;
        if (!ecPublicKeyParameters.getParameters().equals(this.key.getParameters())) {
            throw new IllegalKeyException("ECDH public key has wrong domain parameters");
        }
        ECPoint eCPoint = ecPublicKeyParameters.getQ().multiply(this.key.getD()).normalize();
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }
}

