/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricPublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.DigestAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.OutputSignerUsingSecureRandom;
import com.aspose.html.internal.ms.core.bc.crypto.OutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECGOST3410PrivateKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricECGOST3410PublicKey;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.ECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.GOST3410Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.NamedECDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSAOutputSigner;
import com.aspose.html.internal.ms.core.bc.crypto.general.DSAOutputVerifier;
import com.aspose.html.internal.ms.core.bc.crypto.general.EcGost3410Signer;
import com.aspose.html.internal.ms.core.bc.crypto.general.EcKeyGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.EcKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedAsymmetricKeyPairGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedSignatureOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.Register;
import com.aspose.html.internal.ms.core.bc.crypto.general.SecureHash;
import com.aspose.html.internal.ms.core.bc.crypto.general.SelfTestExecutor;
import com.aspose.html.internal.ms.core.bc.crypto.general.Utils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.AsymmetricCipherKeyPair;
import com.aspose.html.internal.ms.core.bc.crypto.internal.DSA;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Digest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcNamedDomainParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPrivateKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.EcPublicKeyParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithRandom;
import com.aspose.html.internal.ms.core.bc.crypto.internal.test.ConsistencyTest;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;

public final class ECGOST3410 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("ECGOST3410", (Enum)Variations.ECGOST3410);
    public static final SignatureParameters GOST3410 = new SignatureParameters();

    private ECGOST3410() {
    }

    private static EcDomainParameters getDomainParams(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof NamedECDomainParameters) {
            return new EcNamedDomainParameters(((NamedECDomainParameters)eCDomainParameters).getID(), eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
        }
        return new EcDomainParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
    }

    private static EcPrivateKeyParameters getLwKey(final AsymmetricECGOST3410PrivateKey asymmetricECGOST3410PrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<EcPrivateKeyParameters>(){

            @Override
            public EcPrivateKeyParameters run() {
                return new EcPrivateKeyParameters(asymmetricECGOST3410PrivateKey.getS(), ECGOST3410.getDomainParams((ECDomainParameters)asymmetricECGOST3410PrivateKey.getParameters().getDomainParameters()));
            }
        });
    }

    private static void validateKeyPair(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
        SelfTestExecutor.validate((Algorithm)ALGORITHM, asymmetricCipherKeyPair, new ConsistencyTest<AsymmetricCipherKeyPair>(){

            @Override
            public boolean hasTestPassed(AsymmetricCipherKeyPair asymmetricCipherKeyPair) {
                byte[] byArray = Hex.decode("576a1f885e3420128c8a656097ba7d8bb4c6f1b1853348cf2ba976971dbdbefc");
                EcGost3410Signer ecGost3410Signer = new EcGost3410Signer();
                ecGost3410Signer.init(true, new ParametersWithRandom(asymmetricCipherKeyPair.getPrivate(), Utils.testRandom));
                BigInteger[] bigIntegerArray = ecGost3410Signer.generateSignature(byArray);
                ecGost3410Signer.init(false, asymmetricCipherKeyPair.getPublic());
                ecGost3410Signer.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
                return ecGost3410Signer.verifySignature(byArray, bigIntegerArray[0], bigIntegerArray[1]);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyGenParameters
    extends GeneralParameters {
        private final GOST3410Parameters<ECDomainParameters> domainParameters;

        public KeyGenParameters(GOST3410Parameters<ECDomainParameters> gOST3410Parameters) {
            super(ALGORITHM);
            this.domainParameters = gOST3410Parameters;
        }

        public GOST3410Parameters<ECDomainParameters> getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricECGOST3410PublicKey, AsymmetricECGOST3410PrivateKey> {
        private final EcKeyPairGenerator engine = new EcKeyPairGenerator();
        private final GOST3410Parameters<ECDomainParameters> parameters;
        private final EcKeyGenerationParameters param;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.parameters = keyGenParameters.getDomainParameters();
            this.param = new EcKeyGenerationParameters(ECGOST3410.getDomainParams(this.parameters.getDomainParameters()), secureRandom);
            this.engine.init(this.param);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricECGOST3410PublicKey, AsymmetricECGOST3410PrivateKey> doGenerateKeyPair() {
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            ECGOST3410.validateKeyPair(asymmetricCipherKeyPair);
            EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            EcPrivateKeyParameters ecPrivateKeyParameters = (EcPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            Object t2 = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return new AsymmetricKeyPair<AsymmetricECGOST3410PublicKey, AsymmetricECGOST3410PrivateKey>(new AsymmetricECGOST3410PublicKey((Algorithm)t2, this.parameters, ecPublicKeyParameters.getQ()), new AsymmetricECGOST3410PrivateKey((Algorithm)t2, this.parameters, ecPrivateKeyParameters.getD()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureOperatorFactory
    extends GuardedSignatureOperatorFactory<SignatureParameters> {
        @Override
        public OutputSignerUsingSecureRandom<SignatureParameters> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, SignatureParameters signatureParameters) {
            EcGost3410Signer ecGost3410Signer = new EcGost3410Signer();
            Digest digest = Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricECGOST3410PrivateKey asymmetricECGOST3410PrivateKey = (AsymmetricECGOST3410PrivateKey)asymmetricPrivateKey;
            final EcPrivateKeyParameters ecPrivateKeyParameters = ECGOST3410.getLwKey(asymmetricECGOST3410PrivateKey);
            return new DSAOutputSigner<SignatureParameters>(ecGost3410Signer, digest, signatureParameters, new DSAOutputSigner.Initializer(){

                public void initialize(DSA dSA, SecureRandom secureRandom) {
                    dSA.init(true, new ParametersWithRandom(ecPrivateKeyParameters, secureRandom));
                }
            });
        }

        @Override
        public OutputVerifier<SignatureParameters> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, SignatureParameters signatureParameters) {
            EcGost3410Signer ecGost3410Signer = new EcGost3410Signer();
            Digest digest = Register.createDigest(signatureParameters.getDigestAlgorithm());
            AsymmetricECGOST3410PublicKey asymmetricECGOST3410PublicKey = (AsymmetricECGOST3410PublicKey)asymmetricPublicKey;
            EcPublicKeyParameters ecPublicKeyParameters = new EcPublicKeyParameters(asymmetricECGOST3410PublicKey.getW(), ECGOST3410.getDomainParams((ECDomainParameters)asymmetricECGOST3410PublicKey.getParameters().getDomainParameters()));
            ecGost3410Signer.init(false, ecPublicKeyParameters);
            return new DSAOutputVerifier<SignatureParameters>(ecGost3410Signer, digest, signatureParameters);
        }
    }

    public static final class SignatureParameters
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        SignatureParameters() {
            this(SecureHash.Algorithm.GOST3411);
        }

        private SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM);
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }

        public SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        ECGOST3410;

    }
}

