/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.internal.ms.core.bc.crypto.ParametersWithIV;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricSecretKey;
import com.aspose.html.internal.ms.core.bc.crypto.general.CipherKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.CipherUtils;
import com.aspose.html.internal.ms.core.bc.crypto.general.GOST28147Engine;
import com.aspose.html.internal.ms.core.bc.crypto.general.GOST28147Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAuthParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedAEADOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedMACOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedSymmetricKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedSymmetricOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.Mode;
import com.aspose.html.internal.ms.core.bc.crypto.general.Padding;
import com.aspose.html.internal.ms.core.bc.crypto.general.PrivilegedUtils;
import com.aspose.html.internal.ms.core.bc.crypto.general.SelfTestExecutor;
import com.aspose.html.internal.ms.core.bc.crypto.general.Utils;
import com.aspose.html.internal.ms.core.bc.crypto.general.VariantKatTest;
import com.aspose.html.internal.ms.core.bc.crypto.internal.BlockCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.BufferedBlockCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.KeyGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Mac;
import com.aspose.html.internal.ms.core.bc.crypto.internal.ValidatedSymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.internal.modes.AEADBlockCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.KeyParameter;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.KeyParameterImpl;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public final class GOST28147 {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("GOST28147");
    private static final EngineProvider ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB64;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final AuthParameters EAX;
    public static final AuthParameters CMAC;
    public static final Parameters GCFB;
    public static final Parameters GOFB;
    public static final AuthParameters MAC;
    protected static final int BLOCK_SIZE = 8;
    private static byte[] Sbox_Default;
    private static byte[] ESbox_Test;
    private static byte[] ESbox_A;
    private static byte[] ESbox_B;
    private static byte[] ESbox_C;
    private static byte[] ESbox_D;
    private static byte[] DSbox_Test;
    private static byte[] DSbox_A;
    private static Map<String, byte[]> sBoxes;
    private static Map<ASN1ObjectIdentifier, String> oidMappings;
    private static Map<String, ASN1ObjectIdentifier> nameMappings;

    private GOST28147() {
    }

    private static void addSBox(String string, byte[] byArray) {
        sBoxes.put(Strings.toUpperCase(string), byArray);
    }

    public static byte[] getSBox(String string) {
        byte[] byArray = sBoxes.get(Strings.toUpperCase(string));
        if (byArray == null) {
            throw new IllegalArgumentException("Unknown S-Box - possible types: \"Default\", \"E-Test\", \"E-A\", \"E-B\", \"E-C\", \"E-D\", \"D-Test\", \"D-A\".");
        }
        return Arrays.clone(byArray);
    }

    public static byte[] getSBox(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return GOST28147.getSBox(GOST28147.getSBoxName(aSN1ObjectIdentifier));
    }

    public static String getSBoxName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = oidMappings.get(aSN1ObjectIdentifier);
        if (string == null) {
            throw new IllegalArgumentException("Unknown SBOX OID: " + aSN1ObjectIdentifier);
        }
        return string;
    }

    public static ASN1ObjectIdentifier getSBoxOID(String string) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = nameMappings.get(string);
        if (aSN1ObjectIdentifier == null) {
            throw new IllegalArgumentException("Unknown SBOX name: " + string);
        }
        return aSN1ObjectIdentifier;
    }

    public static ASN1ObjectIdentifier getSBoxOID(byte[] byArray) {
        for (String string : sBoxes.keySet()) {
            byte[] byArray2 = sBoxes.get(string);
            if (!Arrays.areEqual(byArray2, byArray)) continue;
            return GOST28147.getSBoxOID(string);
        }
        throw new IllegalArgumentException("SBOX provided did not map to a known one");
    }

    private static KeyParameter createGOST28147Parameters(SymmetricKey symmetricKey, Algorithm algorithm, byte[] byArray) {
        return GOST28147.validateKey(symmetricKey, algorithm, byArray);
    }

    private static GOST28147Parameters validateKey(SymmetricKey symmetricKey, Algorithm algorithm, byte[] byArray) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n2 = validatedSymmetricKey.getKeySizeInBits();
        if (n2 != 256) {
            throw new IllegalKeyException("GOST28147 key must be of length 256 bits");
        }
        Utils.checkKeyAlgorithm(validatedSymmetricKey, ALGORITHM, algorithm);
        return new GOST28147Parameters(validatedSymmetricKey.getKeyBytes(), byArray);
    }

    static {
        EngineProvider engineProvider = new EngineProvider();
        engineProvider.createEngine();
        ENGINE_PROVIDER = engineProvider;
        ECB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB64 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB64));
        OFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OFB64));
        CTR = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        EAX = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.EAX));
        CMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        GCFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.GCFB));
        GOFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.GOFB));
        MAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.GOSTMAC));
        Sbox_Default = new byte[]{4, 10, 9, 2, 13, 8, 0, 14, 6, 11, 1, 12, 7, 15, 5, 3, 14, 11, 4, 12, 6, 13, 15, 10, 2, 3, 8, 1, 0, 7, 5, 9, 5, 8, 1, 13, 10, 3, 4, 2, 14, 15, 12, 7, 6, 0, 9, 11, 7, 13, 10, 1, 0, 8, 9, 15, 14, 4, 6, 12, 11, 2, 5, 3, 6, 12, 7, 1, 5, 15, 13, 8, 4, 10, 9, 14, 0, 3, 11, 2, 4, 11, 10, 0, 7, 2, 1, 13, 3, 6, 8, 5, 9, 12, 15, 14, 13, 11, 4, 1, 3, 15, 5, 9, 0, 10, 14, 7, 6, 8, 2, 12, 1, 15, 13, 0, 5, 7, 10, 4, 9, 2, 3, 14, 6, 11, 8, 12};
        ESbox_Test = new byte[]{4, 2, 15, 5, 9, 1, 0, 8, 14, 3, 11, 12, 13, 7, 10, 6, 12, 9, 15, 14, 8, 1, 3, 10, 2, 7, 4, 13, 6, 0, 11, 5, 13, 8, 14, 12, 7, 3, 9, 10, 1, 5, 2, 4, 6, 15, 0, 11, 14, 9, 11, 2, 5, 15, 7, 1, 0, 13, 12, 6, 10, 4, 3, 8, 3, 14, 5, 9, 6, 8, 0, 13, 10, 11, 7, 12, 2, 1, 15, 4, 8, 15, 6, 11, 1, 9, 12, 5, 13, 3, 7, 10, 0, 14, 2, 4, 9, 11, 12, 0, 3, 6, 7, 5, 4, 8, 14, 15, 1, 10, 2, 13, 12, 6, 5, 2, 11, 0, 9, 13, 3, 14, 7, 10, 15, 4, 1, 8};
        ESbox_A = new byte[]{9, 6, 3, 2, 8, 11, 1, 7, 10, 4, 14, 15, 12, 0, 13, 5, 3, 7, 14, 9, 8, 10, 15, 0, 5, 2, 6, 12, 11, 4, 13, 1, 14, 4, 6, 2, 11, 3, 13, 8, 12, 15, 5, 10, 0, 7, 1, 9, 14, 7, 10, 12, 13, 1, 3, 9, 0, 2, 11, 4, 15, 8, 5, 6, 11, 5, 1, 9, 8, 13, 15, 0, 14, 4, 2, 3, 12, 7, 10, 6, 3, 10, 13, 12, 1, 2, 0, 11, 7, 5, 9, 4, 8, 15, 14, 6, 1, 13, 2, 9, 7, 10, 6, 0, 8, 12, 4, 5, 15, 3, 11, 14, 11, 10, 15, 5, 0, 12, 14, 8, 6, 2, 3, 9, 1, 7, 13, 4};
        ESbox_B = new byte[]{8, 4, 11, 1, 3, 5, 0, 9, 2, 14, 10, 12, 13, 6, 7, 15, 0, 1, 2, 10, 4, 13, 5, 12, 9, 7, 3, 15, 11, 8, 6, 14, 14, 12, 0, 10, 9, 2, 13, 11, 7, 5, 8, 15, 3, 6, 1, 4, 7, 5, 0, 13, 11, 6, 1, 2, 3, 10, 12, 15, 4, 14, 9, 8, 2, 7, 12, 15, 9, 5, 10, 11, 1, 4, 0, 13, 6, 8, 14, 3, 8, 3, 2, 6, 4, 13, 14, 11, 12, 1, 7, 15, 10, 0, 9, 5, 5, 2, 10, 11, 9, 1, 12, 3, 7, 4, 13, 0, 6, 15, 8, 14, 0, 4, 11, 14, 8, 3, 7, 1, 10, 2, 9, 6, 15, 13, 5, 12};
        ESbox_C = new byte[]{1, 11, 12, 2, 9, 13, 0, 15, 4, 5, 8, 14, 10, 7, 6, 3, 0, 1, 7, 13, 11, 4, 5, 2, 8, 14, 15, 12, 9, 10, 6, 3, 8, 2, 5, 0, 4, 9, 15, 10, 3, 7, 12, 13, 6, 14, 1, 11, 3, 6, 0, 1, 5, 13, 10, 8, 11, 2, 9, 7, 14, 15, 12, 4, 8, 13, 11, 0, 4, 5, 1, 2, 9, 3, 12, 14, 6, 15, 10, 7, 12, 9, 11, 1, 8, 14, 2, 4, 7, 3, 6, 5, 10, 0, 15, 13, 10, 9, 6, 8, 13, 14, 2, 0, 15, 3, 5, 11, 4, 1, 12, 7, 7, 4, 0, 5, 10, 2, 15, 14, 12, 6, 1, 11, 13, 9, 3, 8};
        ESbox_D = new byte[]{15, 12, 2, 10, 6, 4, 5, 0, 7, 9, 14, 13, 1, 11, 8, 3, 11, 6, 3, 4, 12, 15, 14, 2, 7, 13, 8, 0, 5, 10, 9, 1, 1, 12, 11, 0, 15, 14, 6, 5, 10, 13, 4, 8, 9, 3, 7, 2, 1, 5, 14, 12, 10, 7, 0, 13, 6, 2, 11, 4, 9, 3, 15, 8, 0, 12, 8, 9, 13, 2, 10, 11, 7, 3, 6, 5, 4, 14, 15, 1, 8, 0, 15, 3, 2, 5, 14, 11, 1, 10, 4, 7, 12, 9, 13, 6, 3, 0, 6, 15, 1, 14, 9, 2, 13, 8, 12, 4, 11, 10, 5, 7, 1, 10, 6, 8, 15, 11, 0, 4, 12, 3, 5, 9, 7, 13, 2, 14};
        DSbox_Test = new byte[]{4, 10, 9, 2, 13, 8, 0, 14, 6, 11, 1, 12, 7, 15, 5, 3, 14, 11, 4, 12, 6, 13, 15, 10, 2, 3, 8, 1, 0, 7, 5, 9, 5, 8, 1, 13, 10, 3, 4, 2, 14, 15, 12, 7, 6, 0, 9, 11, 7, 13, 10, 1, 0, 8, 9, 15, 14, 4, 6, 12, 11, 2, 5, 3, 6, 12, 7, 1, 5, 15, 13, 8, 4, 10, 9, 14, 0, 3, 11, 2, 4, 11, 10, 0, 7, 2, 1, 13, 3, 6, 8, 5, 9, 12, 15, 14, 13, 11, 4, 1, 3, 15, 5, 9, 0, 10, 14, 7, 6, 8, 2, 12, 1, 15, 13, 0, 5, 7, 10, 4, 9, 2, 3, 14, 6, 11, 8, 12};
        DSbox_A = new byte[]{10, 4, 5, 6, 8, 1, 3, 7, 13, 12, 14, 0, 9, 2, 11, 15, 5, 15, 4, 0, 2, 13, 11, 9, 1, 7, 6, 3, 12, 14, 10, 8, 7, 15, 12, 14, 9, 4, 1, 0, 3, 11, 5, 2, 6, 10, 8, 13, 4, 10, 7, 12, 0, 15, 2, 8, 14, 1, 6, 5, 13, 11, 9, 3, 7, 6, 4, 11, 9, 12, 2, 10, 1, 8, 0, 14, 15, 13, 3, 5, 7, 6, 2, 4, 13, 9, 15, 0, 10, 1, 5, 11, 8, 14, 12, 3, 13, 14, 4, 1, 7, 0, 5, 10, 3, 12, 8, 15, 6, 2, 9, 11, 1, 3, 10, 9, 5, 11, 4, 15, 8, 6, 7, 14, 13, 0, 2, 12};
        sBoxes = new HashMap<String, byte[]>();
        GOST28147.addSBox("Default", Sbox_Default);
        GOST28147.addSBox("E-TEST", ESbox_Test);
        GOST28147.addSBox("E-A", ESbox_A);
        GOST28147.addSBox("E-B", ESbox_B);
        GOST28147.addSBox("E-C", ESbox_C);
        GOST28147.addSBox("E-D", ESbox_D);
        GOST28147.addSBox("D-TEST", DSbox_Test);
        GOST28147.addSBox("D-A", DSbox_A);
        oidMappings = new HashMap<ASN1ObjectIdentifier, String>();
        nameMappings = new HashMap<String, ASN1ObjectIdentifier>();
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_TestParamSet, "E-TEST");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet, "E-A");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_B_ParamSet, "E-B");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_C_ParamSet, "E-C");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_D_ParamSet, "E-D");
        nameMappings.put("E-A", CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet);
        nameMappings.put("E-B", CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_B_ParamSet);
        nameMappings.put("E-C", CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_C_ParamSet);
        nameMappings.put("E-D", CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_D_ParamSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        @Override
        protected AEADBlockCipher createAEADCipher(boolean bl2, SymmetricKey symmetricKey, AuthParameters authParameters) {
            KeyParameter keyParameter = GOST28147.createGOST28147Parameters(symmetricKey, authParameters.getAlgorithm(), authParameters.sBox);
            return CipherUtils.createStandardAEADCipher(bl2, keyParameter, (com.aspose.html.internal.ms.core.bc.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (AuthenticationParametersWithIV)authParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private final byte[] sBox;

        private AuthParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n2, byte[] byArray2) {
            super(generalAlgorithm, 8, byArray, n2);
            this.sBox = byArray2;
        }

        AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, Utils.getDefaultMacSize(generalAlgorithm, 64), null);
        }

        public AuthParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            this(generalAlgorithm, null, Utils.getDefaultMacSize(generalAlgorithm, 64), Arrays.clone(byArray));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n2) {
            return new AuthParameters(generalAlgorithm, byArray, n2, this.sBox);
        }

        public AuthParameters withSBox(byte[] byArray) {
            return new AuthParameters((GeneralAlgorithm)this.getAlgorithm(), this.iv, this.macLenInBits, Arrays.clone(byArray));
        }

        public byte[] getSBox() {
            if (this.sBox != null) {
                return (byte[])this.sBox.clone();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EngineProvider
    implements com.aspose.html.internal.ms.core.bc.crypto.internal.EngineProvider<BlockCipher> {
        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new GOST28147Engine(), new VariantKatTest<GOST28147Engine>(){

                @Override
                public void evaluate(GOST28147Engine gOST28147Engine) {
                    byte[] byArray = Hex.decode("00112233445566778899aabbccddeeff");
                    byte[] byArray2 = Hex.decode("54410a030c22e4c6a33255fa5f54cc84");
                    byte[] byArray3 = new byte[byArray.length];
                    KeyParameterImpl keyParameterImpl = new KeyParameterImpl(Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f"));
                    gOST28147Engine.init(true, keyParameterImpl);
                    gOST28147Engine.processBlock(byArray, 0, byArray3, 0);
                    gOST28147Engine.processBlock(byArray, 8, byArray3, 8);
                    if (!Arrays.areEqual(byArray2, byArray3)) {
                        this.fail("Failed self test on encryption");
                    }
                    gOST28147Engine.init(false, keyParameterImpl);
                    gOST28147Engine.processBlock(byArray3, 0, byArray3, 0);
                    gOST28147Engine.processBlock(byArray3, 8, byArray3, 8);
                    if (!Arrays.areEqual(byArray, byArray3)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final Algorithm algorithm;
        private final SecureRandom random;

        public KeyGenerator(SecureRandom secureRandom) {
            this.algorithm = ALGORITHM;
            this.random = secureRandom;
        }

        public KeyGenerator(GeneralParameters generalParameters, SecureRandom secureRandom) {
            this.algorithm = generalParameters.getAlgorithm();
            this.random = secureRandom;
        }

        protected SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, 256));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            KeyParameter keyParameter = GOST28147.createGOST28147Parameters(symmetricKey, authParameters.getAlgorithm(), authParameters.sBox);
            return CipherUtils.createStandardMac(keyParameter, (com.aspose.html.internal.ms.core.bc.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (GeneralAuthParameters)authParameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return Utils.bitsToBytes(authParameters.macLenInBits);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean bl2, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            KeyParameter keyParameter = GOST28147.createGOST28147Parameters(symmetricKey, parameters.getAlgorithm(), parameters.getSBox());
            return CipherUtils.createStandardCipher(bl2, keyParameter, (com.aspose.html.internal.ms.core.bc.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)parameters, secureRandom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Parameters
    extends GeneralParameters<GeneralAlgorithm>
    implements ParametersWithIV {
        private final byte[] iv;
        private final byte[] sBox;

        Parameters(GeneralAlgorithm generalAlgorithm) {
            super(generalAlgorithm);
            this.iv = null;
            this.sBox = null;
        }

        private Parameters(Parameters parameters, boolean bl2, byte[] byArray) {
            super(parameters.getAlgorithm());
            if (bl2) {
                this.sBox = byArray;
                this.iv = parameters.iv;
            } else {
                this.sBox = parameters.sBox;
                this.iv = byArray;
            }
            ((Mode)((GeneralAlgorithm)parameters.getAlgorithm()).basicVariation()).checkIv(this.iv, 8);
        }

        public Parameters withIV(byte[] byArray) {
            return new Parameters(this, false, Arrays.clone(byArray));
        }

        public Parameters withIV(SecureRandom secureRandom) {
            return new Parameters(this, false, ((GeneralAlgorithm)this.getAlgorithm()).createDefaultIvIfNecessary(8, secureRandom));
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }

        public Parameters withSBox(byte[] byArray) {
            return new Parameters(this, true, Arrays.clone(byArray));
        }

        public byte[] getSBox() {
            if (this.sBox != null) {
                return (byte[])this.sBox.clone();
            }
            return null;
        }
    }
}

