/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.general;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AuthenticationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.IllegalKeyException;
import com.aspose.html.internal.ms.core.bc.crypto.Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.SymmetricSecretKey;
import com.aspose.html.internal.ms.core.bc.crypto.general.CipherKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralAlgorithm;
import com.aspose.html.internal.ms.core.bc.crypto.general.GeneralParameters;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedMACOperatorFactory;
import com.aspose.html.internal.ms.core.bc.crypto.general.GuardedSymmetricKeyGenerator;
import com.aspose.html.internal.ms.core.bc.crypto.general.PrivilegedUtils;
import com.aspose.html.internal.ms.core.bc.crypto.general.SipHashEngine;
import com.aspose.html.internal.ms.core.bc.crypto.general.Utils;
import com.aspose.html.internal.ms.core.bc.crypto.internal.KeyGenerationParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.Mac;
import com.aspose.html.internal.ms.core.bc.crypto.internal.ValidatedSymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.internal.macs.TruncatingMac;
import java.security.SecureRandom;

public final class SipHash {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("SipHash");
    public static final GeneralAlgorithm SIPHASH_2_4 = new GeneralAlgorithm("SipHash-2-4");
    public static final GeneralAlgorithm SIPHASH_4_8 = new GeneralAlgorithm("SipHash-4-8");

    private SipHash() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Parameters parameters) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        int n2 = validatedSymmetricKey.getKeySizeInBits();
        if (SipHash.invalidKeySize(n2)) {
            throw new IllegalKeyException("SipHash key must be of length 128 bits");
        }
        Algorithm algorithm = symmetricKey.getAlgorithm();
        if (algorithm != ALGORITHM && algorithm != parameters.getAlgorithm()) {
            throw new IllegalKeyException("Key not for appropriate algorithm");
        }
        return validatedSymmetricKey;
    }

    private static boolean invalidKeySize(int n2) {
        return n2 != 128;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends GeneralParameters<GeneralAlgorithm>
    implements AuthenticationParameters<AuthParameters> {
        private final int macSizeInBits;

        private AuthParameters(GeneralAlgorithm generalAlgorithm, int n2) {
            super(generalAlgorithm);
            this.macSizeInBits = n2;
        }

        public AuthParameters() {
            this(SIPHASH_2_4);
        }

        public AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, 64);
        }

        @Override
        public int getMACSizeInBits() {
            return this.macSizeInBits;
        }

        @Override
        public AuthParameters withMACSize(int n2) {
            return new AuthParameters((GeneralAlgorithm)this.getAlgorithm(), n2);
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final SecureRandom random;

        public KeyGenerator(SecureRandom secureRandom) {
            this(ALGORITHM, secureRandom);
        }

        public KeyGenerator(GeneralAlgorithm generalAlgorithm, SecureRandom secureRandom) {
            this.algorithm = generalAlgorithm;
            this.random = secureRandom;
        }

        public SymmetricKey doGenerateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, 128));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            Mac mac = this.getMac(authParameters);
            if (mac.getMacSize() != (authParameters.getMACSizeInBits() + 7) / 8) {
                mac = new TruncatingMac(mac, authParameters.macSizeInBits);
            }
            mac.init(Utils.getKeyParameter(SipHash.validateKey(symmetricKey, authParameters)));
            return mac;
        }

        private Mac getMac(AuthParameters authParameters) {
            SipHashEngine sipHashEngine;
            if (authParameters.getAlgorithm() == SIPHASH_2_4) {
                sipHashEngine = new SipHashEngine(2, 4);
            } else if (authParameters.getAlgorithm() == SIPHASH_4_8) {
                sipHashEngine = new SipHashEngine(4, 8);
            } else {
                throw new IllegalArgumentException("Unknown algorithm passed to createMAC: " + authParameters.getAlgorithm());
            }
            return sipHashEngine;
        }

        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return this.getMac(authParameters).getMacSize();
        }
    }
}

