/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.internal.encodings;

import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.internal.AsymmetricBlockCipher;
import com.aspose.html.internal.ms.core.bc.crypto.internal.CipherParameters;
import com.aspose.html.internal.ms.core.bc.crypto.internal.InvalidCipherTextException;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.AsymmetricKeyParameter;
import com.aspose.html.internal.ms.core.bc.crypto.internal.params.ParametersWithRandom;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Properties;
import java.security.SecureRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "com.aspose.html.internal.ms.core.bc.pkcs1.not_strict";
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private byte[] dudBlock;

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
    }

    private boolean useStrict() {
        return CryptoServicesRegistrar.isInApprovedOnlyMode() || !Properties.isOverrideSet(NOT_STRICT_LENGTH_ENABLED_PROPERTY);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
            if (!asymmetricKeyParameter.isPrivate() && bl2) {
                throw new IllegalArgumentException("No SecureRandom specified.");
            }
        }
        this.engine.init(bl2, cipherParameters);
        this.forPrivateKey = asymmetricKeyParameter.isPrivate();
        this.forEncryption = bl2;
        this.dudBlock = new byte[this.engine.getOutputBlockSize()];
    }

    public int getInputBlockSize() {
        int n2 = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n2 - 10;
        }
        return n2;
    }

    public int getOutputBlockSize() {
        int n2 = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n2;
        }
        return n2 - 10;
    }

    public byte[] processBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n2, n3);
        }
        return this.decodeBlock(byArray, n2, n3);
    }

    private byte[] encodeBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (n3 > this.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        byte[] byArray2 = new byte[this.engine.getInputBlockSize()];
        if (this.forPrivateKey) {
            byArray2[0] = 1;
            for (int i2 = 1; i2 != byArray2.length - n3 - 1; ++i2) {
                byArray2[i2] = -1;
            }
        } else {
            this.random.nextBytes(byArray2);
            byArray2[0] = 2;
            for (int i3 = 1; i3 != byArray2.length - n3 - 1; ++i3) {
                while (byArray2[i3] == 0) {
                    byArray2[i3] = (byte)this.random.nextInt();
                }
            }
        }
        byArray2[byArray2.length - n3 - 1] = 0;
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        return this.engine.processBlock(byArray2, 0, byArray2.length);
    }

    private byte[] decodeBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2 = this.engine.processBlock(byArray, n2, n3);
        if (byArray2.length < this.getOutputBlockSize()) {
            byArray2 = this.dudBlock;
        }
        byte by2 = byArray2[0];
        boolean bl2 = this.forPrivateKey ? by2 != 2 : by2 != 1;
        boolean bl3 = this.useStrictLength & byArray2.length != this.engine.getOutputBlockSize();
        int n4 = this.findStart(by2, byArray2);
        if (bl2 | ++n4 < 10) {
            Arrays.fill(byArray2, (byte)0);
            throw new InvalidCipherTextException("block incorrect");
        }
        if (bl3) {
            Arrays.fill(byArray2, (byte)0);
            throw new InvalidCipherTextException("block incorrect size");
        }
        byte[] byArray3 = new byte[byArray2.length - n4];
        System.arraycopy(byArray2, n4, byArray3, 0, byArray3.length);
        return byArray3;
    }

    private int findStart(byte by2, byte[] byArray) throws InvalidCipherTextException {
        int n2 = -1;
        boolean bl2 = false;
        for (int i2 = 1; i2 != byArray.length; ++i2) {
            byte by3 = byArray[i2];
            if (by3 == 0 & n2 < 0) {
                n2 = i2;
            }
            bl2 |= by2 == 1 & n2 < 0 & by3 != -1;
        }
        if (bl2) {
            return -1;
        }
        return n2;
    }
}

