/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.est;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpUtil {
    HttpUtil() {
    }

    static String mergeCSL(String prefix, Map<String, String> kv) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(prefix);
        stringWriter.write(32);
        boolean bl2 = false;
        for (Map.Entry<String, String> entry : kv.entrySet()) {
            if (!bl2) {
                bl2 = true;
            } else {
                stringWriter.write(44);
            }
            stringWriter.write(entry.getKey());
            stringWriter.write("=\"");
            stringWriter.write(entry.getValue());
            stringWriter.write(34);
        }
        return stringWriter.toString();
    }

    static Map<String, String> splitCSL(String skip, String src) {
        if ((src = src.trim()).startsWith(skip)) {
            src = src.substring(skip.length());
        }
        return new PartLexer(src).Parse();
    }

    public static String[] append(String[] a2, String b2) {
        if (a2 == null) {
            return new String[]{b2};
        }
        int n2 = a2.length;
        String[] stringArray = new String[n2 + 1];
        System.arraycopy(a2, 0, stringArray, 0, n2);
        stringArray[n2] = b2;
        return stringArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Headers
    extends HashMap<String, String[]> {
        public String getFirstValue(String key) {
            String[] stringArray = this.getValues(key);
            if (stringArray != null && stringArray.length > 0) {
                return stringArray[0];
            }
            return null;
        }

        public String[] getValues(String key) {
            if ((key = this.actualKey(key)) == null) {
                return null;
            }
            return (String[])this.get(key);
        }

        private String actualKey(String header) {
            if (this.containsKey(header)) {
                return header;
            }
            for (String string : this.keySet()) {
                if (!header.equalsIgnoreCase(string)) continue;
                return string;
            }
            return null;
        }

        private boolean hasHeader(String header) {
            return this.actualKey(header) != null;
        }

        public void set(String key, String value) {
            this.put(key, new String[]{value});
        }

        public void add(String key, String value) {
            this.put(key, HttpUtil.append((String[])this.get(key), value));
        }

        public void ensureHeader(String key, String value) {
            if (!this.containsKey(key)) {
                this.set(key, value);
            }
        }

        @Override
        public Object clone() {
            Headers headers = new Headers();
            for (Map.Entry entry : this.entrySet()) {
                headers.put((String)entry.getKey(), this.copy((String[])entry.getValue()));
            }
            return headers;
        }

        private String[] copy(String[] vs) {
            String[] stringArray = new String[vs.length];
            System.arraycopy(vs, 0, stringArray, 0, stringArray.length);
            return stringArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PartLexer {
        private final String src;
        int last = 0;
        int p = 0;

        PartLexer(String src) {
            this.src = src;
        }

        Map<String, String> Parse() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = null;
            String string2 = null;
            while (this.p < this.src.length()) {
                this.skipWhiteSpace();
                string = this.consumeAlpha();
                if (string.length() == 0) {
                    throw new IllegalArgumentException("Expecting alpha label.");
                }
                this.skipWhiteSpace();
                if (!this.consumeIf('=')) {
                    throw new IllegalArgumentException("Expecting assign: '='");
                }
                this.skipWhiteSpace();
                if (!this.consumeIf('\"')) {
                    throw new IllegalArgumentException("Expecting start quote: '\"'");
                }
                this.discard();
                string2 = this.consumeUntil('\"');
                this.discard(1);
                hashMap.put(string, string2);
                this.skipWhiteSpace();
                if (!this.consumeIf(',')) break;
                this.discard();
            }
            return hashMap;
        }

        private String consumeAlpha() {
            char c2 = this.src.charAt(this.p);
            while (this.p < this.src.length() && (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                ++this.p;
                c2 = this.src.charAt(this.p);
            }
            String string = this.src.substring(this.last, this.p);
            this.last = this.p;
            return string;
        }

        private void skipWhiteSpace() {
            while (this.p < this.src.length() && this.src.charAt(this.p) < '!') {
                ++this.p;
            }
            this.last = this.p;
        }

        private boolean consumeIf(char c2) {
            if (this.p < this.src.length() && this.src.charAt(this.p) == c2) {
                ++this.p;
                return true;
            }
            return false;
        }

        private String consumeUntil(char c2) {
            while (this.p < this.src.length() && this.src.charAt(this.p) != c2) {
                ++this.p;
            }
            String string = this.src.substring(this.last, this.p);
            this.last = this.p;
            return string;
        }

        private void discard() {
            this.last = this.p;
        }

        private void discard(int i2) {
            this.p += i2;
            this.last = this.p;
        }
    }
}

