/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.est.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.x500.AttributeTypeAndValue;
import com.aspose.html.internal.ms.core.bc.asn1.x500.RDN;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.asn1.x500.style.BCStyle;
import com.aspose.html.internal.ms.core.bc.est.ESTException;
import com.aspose.html.internal.ms.core.bc.est.jcajce.JsseHostnameAuthorizer;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsseDefaultHostnameAuthorizer
implements JsseHostnameAuthorizer {
    private static Logger LOG = Logger.getLogger(JsseDefaultHostnameAuthorizer.class.getName());
    private final Set<String> knownSuffixes;

    public JsseDefaultHostnameAuthorizer(Set<String> knownSuffixes) {
        this.knownSuffixes = knownSuffixes;
    }

    @Override
    public boolean verified(String name, SSLSession context) throws IOException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(context.getPeerCertificates()[0].getEncoded()));
            return this.verify(name, x509Certificate);
        }
        catch (Exception exception) {
            if (exception instanceof ESTException) {
                throw (ESTException)exception;
            }
            throw new ESTException(exception.getMessage(), exception);
        }
    }

    public boolean verify(String name, X509Certificate cert) throws IOException {
        RDN[] rDNArray;
        try {
            rDNArray = cert.getSubjectAlternativeNames();
            if (rDNArray != null) {
                block6: for (List<?> list : rDNArray) {
                    int n2 = ((Number)list.get(0)).intValue();
                    switch (n2) {
                        case 2: {
                            if (!JsseDefaultHostnameAuthorizer.isValidNameMatch(name, list.get(1).toString(), this.knownSuffixes)) continue block6;
                            return true;
                        }
                        case 7: {
                            if (!InetAddress.getByName(name).equals(InetAddress.getByName(list.get(1).toString()))) continue block6;
                            return true;
                        }
                    }
                    if (!LOG.isLoggable(Level.INFO)) continue;
                    String string = list.get(1) instanceof byte[] ? Hex.toHexString((byte[])list.get(1)) : list.get(1).toString();
                    LOG.log(Level.INFO, "ignoring type " + n2 + " value = " + string);
                }
                return false;
            }
        }
        catch (Exception exception) {
            throw new ESTException(exception.getMessage(), exception);
        }
        if (cert.getSubjectX500Principal() == null) {
            return false;
        }
        rDNArray = X500Name.getInstance(cert.getSubjectX500Principal().getEncoded()).getRDNs();
        for (int i2 = rDNArray.length - 1; i2 >= 0; --i2) {
            RDN rDN = rDNArray[i2];
            AttributeTypeAndValue[] attributeTypeAndValueArray = rDN.getTypesAndValues();
            for (int i3 = 0; i3 != attributeTypeAndValueArray.length; ++i3) {
                AttributeTypeAndValue attributeTypeAndValue = attributeTypeAndValueArray[i3];
                if (!attributeTypeAndValue.getType().equals(BCStyle.CN)) continue;
                return JsseDefaultHostnameAuthorizer.isValidNameMatch(name, attributeTypeAndValue.getValue().toString(), this.knownSuffixes);
            }
        }
        return false;
    }

    public static boolean isValidNameMatch(String name, String dnsName, Set<String> suffixes) throws IOException {
        if (dnsName.contains("*")) {
            int n2 = dnsName.indexOf(42);
            if (n2 == dnsName.lastIndexOf("*")) {
                if (dnsName.contains("..") || dnsName.charAt(dnsName.length() - 1) == '*') {
                    return false;
                }
                int n3 = dnsName.indexOf(46, n2);
                if (suffixes != null && suffixes.contains(Strings.toLowerCase(dnsName.substring(n3)))) {
                    throw new IOException("Wildcard `" + dnsName + "` matches known public suffix.");
                }
                String string = Strings.toLowerCase(dnsName.substring(n2 + 1));
                String string2 = Strings.toLowerCase(name);
                if (string2.equals(string)) {
                    return false;
                }
                if (string.length() > string2.length()) {
                    return false;
                }
                if (n2 > 0) {
                    if (string2.startsWith(dnsName.substring(0, n2)) && string2.endsWith(string)) {
                        return string2.substring(n2, string2.length() - string.length()).indexOf(46) < 0;
                    }
                    return false;
                }
                String string3 = string2.substring(0, string2.length() - string.length());
                if (string3.indexOf(46) > 0) {
                    return false;
                }
                return string2.endsWith(string);
            }
            return false;
        }
        return name.equalsIgnoreCase(dnsName);
    }
}

