/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.jcajce.provider;

import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.AsymmetricRSAPrivateKey;
import com.aspose.html.internal.ms.core.bc.jcajce.provider.ProvKey;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPrivateKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvRSAPrivateKey
implements ProvKey<AsymmetricRSAPrivateKey>,
RSAPrivateKey {
    static final long serialVersionUID = 5110188922551353628L;
    private transient AsymmetricRSAPrivateKey baseKey;

    ProvRSAPrivateKey(Algorithm algorithm, RSAPrivateKey rSAPrivateKey) {
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
    }

    ProvRSAPrivateKey(Algorithm algorithm, RSAPrivateKeySpec rSAPrivateKeySpec) {
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
    }

    ProvRSAPrivateKey(AsymmetricRSAPrivateKey asymmetricRSAPrivateKey) {
        this.baseKey = asymmetricRSAPrivateKey;
    }

    @Override
    public AsymmetricRSAPrivateKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public BigInteger getModulus() {
        return this.baseKey.getModulus();
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.baseKey.getPrivateExponent();
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("RSA Private Key").append(string);
        stringBuilder.append("             modulus: ").append(this.getModulus().toString(16)).append(string);
        try {
            stringBuilder.append("    private exponent: ").append(this.getPrivateExponent().toString(16)).append(string);
        }
        catch (Exception exception) {
            stringBuilder.append("RESTRICTED").append(string);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvRSAPrivateKey)) {
            return false;
        }
        ProvRSAPrivateKey provRSAPrivateKey = (ProvRSAPrivateKey)object;
        return this.baseKey.equals(provRSAPrivateKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricRSAPrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

