/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.mime.smime;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.cms.CMSAlgorithm;
import com.aspose.html.internal.ms.core.bc.util.Strings;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SMimeUtils {
    private static final Map RFC5751_MICALGS;
    private static final Map RFC3851_MICALGS;
    private static final Map STANDARD_MICALGS;
    private static final Map forMic;
    private static final byte[] nl;

    SMimeUtils() {
    }

    static String lessQuotes(String in2) {
        if (in2 == null || in2.length() <= 1) {
            return in2;
        }
        if (in2.charAt(0) == '\"' && in2.charAt(in2.length() - 1) == '\"') {
            return in2.substring(1, in2.length() - 1);
        }
        return in2;
    }

    static String getParameter(String startsWith, List<String> parameters) {
        for (String string : parameters) {
            if (!string.startsWith(startsWith)) continue;
            return string;
        }
        return null;
    }

    static ASN1ObjectIdentifier getDigestOID(String alg) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)forMic.get(Strings.toLowerCase(alg));
        if (aSN1ObjectIdentifier == null) {
            throw new IllegalArgumentException("unknown micalg passed: " + alg);
        }
        return aSN1ObjectIdentifier;
    }

    static OutputStream createUnclosable(OutputStream destination) {
        return new FilterOutputStream(destination){

            public void close() throws IOException {
            }
        };
    }

    static {
        nl = new byte[2];
        SMimeUtils.nl[0] = 13;
        SMimeUtils.nl[1] = 10;
        HashMap<ASN1ObjectIdentifier, String> hashMap = new HashMap<ASN1ObjectIdentifier, String>();
        hashMap.put(CMSAlgorithm.MD5, "md5");
        hashMap.put(CMSAlgorithm.SHA1, "sha-1");
        hashMap.put(CMSAlgorithm.SHA224, "sha-224");
        hashMap.put(CMSAlgorithm.SHA256, "sha-256");
        hashMap.put(CMSAlgorithm.SHA384, "sha-384");
        hashMap.put(CMSAlgorithm.SHA512, "sha-512");
        hashMap.put(CMSAlgorithm.GOST3411, "gostr3411-94");
        RFC5751_MICALGS = Collections.unmodifiableMap(hashMap);
        HashMap<ASN1ObjectIdentifier, String> hashMap2 = new HashMap<ASN1ObjectIdentifier, String>();
        hashMap2.put(CMSAlgorithm.MD5, "md5");
        hashMap2.put(CMSAlgorithm.SHA1, "sha1");
        hashMap2.put(CMSAlgorithm.SHA224, "sha224");
        hashMap2.put(CMSAlgorithm.SHA256, "sha256");
        hashMap2.put(CMSAlgorithm.SHA384, "sha384");
        hashMap2.put(CMSAlgorithm.SHA512, "sha512");
        hashMap2.put(CMSAlgorithm.GOST3411, "gostr3411-94");
        RFC3851_MICALGS = Collections.unmodifiableMap(hashMap2);
        STANDARD_MICALGS = RFC5751_MICALGS;
        TreeMap<String, ASN1ObjectIdentifier> treeMap = new TreeMap<String, ASN1ObjectIdentifier>(String.CASE_INSENSITIVE_ORDER);
        for (Object k2 : STANDARD_MICALGS.keySet()) {
            treeMap.put(STANDARD_MICALGS.get(k2).toString(), (ASN1ObjectIdentifier)k2);
        }
        for (Object k2 : RFC3851_MICALGS.keySet()) {
            treeMap.put(RFC3851_MICALGS.get(k2).toString(), (ASN1ObjectIdentifier)k2);
        }
        forMic = Collections.unmodifiableMap(treeMap);
    }
}

