/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.openssl;

import com.aspose.html.internal.ms.core.bc.openssl.PEMDecryptor;
import com.aspose.html.internal.ms.core.bc.openssl.PEMDecryptorProvider;
import com.aspose.html.internal.ms.core.bc.openssl.PEMException;
import com.aspose.html.internal.ms.core.bc.openssl.PEMKeyPair;
import com.aspose.html.internal.ms.core.bc.openssl.PEMKeyPairParser;
import com.aspose.html.internal.ms.core.bc.operator.OperatorCreationException;
import java.io.IOException;

public class PEMEncryptedKeyPair {
    private final String dekAlgName;
    private final byte[] iv;
    private final byte[] keyBytes;
    private final PEMKeyPairParser parser;

    PEMEncryptedKeyPair(String dekAlgName, byte[] iv2, byte[] keyBytes, PEMKeyPairParser parser) {
        this.dekAlgName = dekAlgName;
        this.iv = iv2;
        this.keyBytes = keyBytes;
        this.parser = parser;
    }

    public PEMKeyPair decryptKeyPair(PEMDecryptorProvider keyDecryptorProvider) throws IOException {
        try {
            PEMDecryptor pEMDecryptor = keyDecryptorProvider.get(this.dekAlgName);
            return this.parser.parse(pEMDecryptor.decrypt(this.keyBytes, this.iv));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new PEMException("cannot create extraction operator: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        catch (Exception exception) {
            throw new PEMException("exception processing key pair: " + exception.getMessage(), exception);
        }
    }
}

