/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.operator.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.RSAESOAEPparams;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.operator.DefaultDigestAlgorithmIdentifierFinder;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class JcaAlgorithmParametersConverter {
    public AlgorithmIdentifier getAlgorithmIdentifier(ASN1ObjectIdentifier algId, AlgorithmParameters parameters) throws InvalidAlgorithmParameterException {
        try {
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(parameters.getEncoded());
            return new AlgorithmIdentifier(algId, aSN1Primitive);
        }
        catch (IOException iOException) {
            throw new InvalidAlgorithmParameterException("unable to encode parameters object: " + iOException.getMessage());
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier(ASN1ObjectIdentifier algorithm, AlgorithmParameterSpec algorithmSpec) throws InvalidAlgorithmParameterException {
        if (algorithmSpec instanceof OAEPParameterSpec) {
            if (algorithmSpec.equals(OAEPParameterSpec.DEFAULT)) {
                return new AlgorithmIdentifier(algorithm, new RSAESOAEPparams(RSAESOAEPparams.DEFAULT_HASH_ALGORITHM, RSAESOAEPparams.DEFAULT_MASK_GEN_FUNCTION, RSAESOAEPparams.DEFAULT_P_SOURCE_ALGORITHM));
            }
            OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)algorithmSpec;
            PSource pSource = oAEPParameterSpec.getPSource();
            if (!oAEPParameterSpec.getMGFAlgorithm().equals(OAEPParameterSpec.DEFAULT.getMGFAlgorithm())) {
                throw new InvalidAlgorithmParameterException("only " + OAEPParameterSpec.DEFAULT.getMGFAlgorithm() + " mask generator supported.");
            }
            AlgorithmIdentifier algorithmIdentifier = new DefaultDigestAlgorithmIdentifierFinder().find(oAEPParameterSpec.getDigestAlgorithm());
            AlgorithmIdentifier algorithmIdentifier2 = new DefaultDigestAlgorithmIdentifierFinder().find(((MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters()).getDigestAlgorithm());
            return new AlgorithmIdentifier(algorithm, new RSAESOAEPparams(algorithmIdentifier, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmIdentifier2), new AlgorithmIdentifier(PKCSObjectIdentifiers.id_pSpecified, new DEROctetString(((PSource.PSpecified)pSource).getValue()))));
        }
        throw new InvalidAlgorithmParameterException("unknown parameter spec passed.");
    }
}

