/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkix.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PrivateKeyInfo;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cert.jcajce.JcaX509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.pkix.PKIXIdentity;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaPKIXIdentity
extends PKIXIdentity {
    private final PrivateKey privKey;
    private final X509Certificate[] certs;

    private static PrivateKeyInfo getPrivateKeyInfo(PrivateKey privateKey) {
        try {
            return PrivateKeyInfo.getInstance(privateKey.getEncoded());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static X509CertificateHolder[] getCertificates(X509Certificate[] certs) {
        X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[certs.length];
        try {
            for (int i2 = 0; i2 != x509CertificateHolderArray.length; ++i2) {
                x509CertificateHolderArray[i2] = new JcaX509CertificateHolder(certs[i2]);
            }
            return x509CertificateHolderArray;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException("Unable to process certificates: " + certificateEncodingException.getMessage());
        }
    }

    public JcaPKIXIdentity(PrivateKey privKey, X509Certificate[] certs) {
        super(JcaPKIXIdentity.getPrivateKeyInfo(privKey), JcaPKIXIdentity.getCertificates(certs));
        this.privKey = privKey;
        this.certs = new X509Certificate[certs.length];
        System.arraycopy(certs, 0, this.certs, 0, certs.length);
    }

    public PrivateKey getPrivateKey() {
        return this.privKey;
    }

    public X509Certificate getX509Certificate() {
        return this.certs[0];
    }
}

