/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkix.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Encodable;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Object;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.asn1.x509.BasicConstraints;
import com.aspose.html.internal.ms.core.bc.asn1.x509.CRLDistPoint;
import com.aspose.html.internal.ms.core.bc.asn1.x509.DistributionPoint;
import com.aspose.html.internal.ms.core.bc.asn1.x509.DistributionPointName;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralNames;
import com.aspose.html.internal.ms.core.bc.asn1.x509.IssuingDistributionPoint;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXCRLStore;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXCRLStoreSelector;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXCertStoreSelector;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXExtendedBuilderParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXExtendedParameters;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.AnnotatedException;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.CRLNotFoundException;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.CertStatus;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.PKIXCRLUtil;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.PKIXJcaJceHelper;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.ReasonsMask;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.RevocationUtilities;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import java.io.IOException;
import java.io.Serializable;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class RFC3280CertPathUtilities {
    private static final PKIXCRLUtil CRL_UTIL = new PKIXCRLUtil();
    public static final String ISSUING_DISTRIBUTION_POINT = Extension.issuingDistributionPoint.getId();
    public static final String FRESHEST_CRL = Extension.freshestCRL.getId();
    public static final String DELTA_CRL_INDICATOR = Extension.deltaCRLIndicator.getId();
    public static final String BASIC_CONSTRAINTS = Extension.basicConstraints.getId();
    public static final String AUTHORITY_KEY_IDENTIFIER = Extension.authorityKeyIdentifier.getId();
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;

    RFC3280CertPathUtilities() {
    }

    protected static void processCRLB2(DistributionPoint dp2, Object cert, X509CRL crl) throws AnnotatedException {
        IssuingDistributionPoint issuingDistributionPoint = null;
        try {
            issuingDistributionPoint = IssuingDistributionPoint.getInstance(RevocationUtilities.getExtensionValue(crl, Extension.issuingDistributionPoint));
        }
        catch (Exception exception) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", exception);
        }
        if (issuingDistributionPoint != null) {
            ASN1Object aSN1Object;
            if (issuingDistributionPoint.getDistributionPoint() != null) {
                Object object;
                aSN1Object = IssuingDistributionPoint.getInstance(issuingDistributionPoint).getDistributionPoint();
                ArrayList<GeneralName> arrayList = new ArrayList<GeneralName>();
                if (((DistributionPointName)aSN1Object).getType() == 0) {
                    object = GeneralNames.getInstance(((DistributionPointName)aSN1Object).getName()).getNames();
                    for (int i2 = 0; i2 < ((GeneralName[])object).length; ++i2) {
                        arrayList.add(object[i2]);
                    }
                }
                if (((DistributionPointName)aSN1Object).getType() == 1) {
                    object = new ASN1EncodableVector();
                    try {
                        Enumeration enumeration = ASN1Sequence.getInstance(crl.getIssuerX500Principal().getEncoded()).getObjects();
                        while (enumeration.hasMoreElements()) {
                            ((ASN1EncodableVector)object).add((ASN1Encodable)enumeration.nextElement());
                        }
                    }
                    catch (Exception exception) {
                        throw new AnnotatedException("Could not read CRL issuer.", exception);
                    }
                    ((ASN1EncodableVector)object).add(((DistributionPointName)aSN1Object).getName());
                    arrayList.add(new GeneralName(X500Name.getInstance(new DERSequence((ASN1EncodableVector)object))));
                }
                boolean bl2 = false;
                if (dp2.getDistributionPoint() != null) {
                    int n2;
                    aSN1Object = dp2.getDistributionPoint();
                    GeneralName[] generalNameArray = null;
                    if (((DistributionPointName)aSN1Object).getType() == 0) {
                        generalNameArray = GeneralNames.getInstance(((DistributionPointName)aSN1Object).getName()).getNames();
                    }
                    if (((DistributionPointName)aSN1Object).getType() == 1) {
                        if (dp2.getCRLIssuer() != null) {
                            generalNameArray = dp2.getCRLIssuer().getNames();
                        } else {
                            generalNameArray = new GeneralName[1];
                            try {
                                generalNameArray[0] = new GeneralName(X500Name.getInstance(((X509Certificate)cert).getIssuerX500Principal().getEncoded()));
                            }
                            catch (Exception exception) {
                                throw new AnnotatedException("Could not read certificate issuer.", exception);
                            }
                        }
                        for (n2 = 0; n2 < generalNameArray.length; ++n2) {
                            Enumeration enumeration = ASN1Sequence.getInstance(generalNameArray[n2].getName().toASN1Primitive()).getObjects();
                            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                            while (enumeration.hasMoreElements()) {
                                aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
                            }
                            aSN1EncodableVector.add(((DistributionPointName)aSN1Object).getName());
                            generalNameArray[n2] = new GeneralName(X500Name.getInstance(new DERSequence(aSN1EncodableVector)));
                        }
                    }
                    if (generalNameArray != null) {
                        for (n2 = 0; n2 < generalNameArray.length; ++n2) {
                            if (!arrayList.contains(generalNameArray[n2])) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (!bl2) {
                        throw new AnnotatedException("No match for certificate CRL issuing distribution point name to cRLIssuer CRL distribution point.");
                    }
                } else {
                    if (dp2.getCRLIssuer() == null) {
                        throw new AnnotatedException("Either the cRLIssuer or the distributionPoint field must be contained in DistributionPoint.");
                    }
                    GeneralName[] generalNameArray = dp2.getCRLIssuer().getNames();
                    for (int i3 = 0; i3 < generalNameArray.length; ++i3) {
                        if (!arrayList.contains(generalNameArray[i3])) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        throw new AnnotatedException("No match for certificate CRL issuing distribution point name to cRLIssuer CRL distribution point.");
                    }
                }
            }
            aSN1Object = null;
            try {
                aSN1Object = BasicConstraints.getInstance(RevocationUtilities.getExtensionValue((X509Extension)cert, Extension.basicConstraints));
            }
            catch (Exception exception) {
                throw new AnnotatedException("Basic constraints extension could not be decoded.", exception);
            }
            if (cert instanceof X509Certificate) {
                if (issuingDistributionPoint.onlyContainsUserCerts() && aSN1Object != null && ((BasicConstraints)aSN1Object).isCA()) {
                    throw new AnnotatedException("CA Cert CRL only contains user certificates.");
                }
                if (issuingDistributionPoint.onlyContainsCACerts() && (aSN1Object == null || !((BasicConstraints)aSN1Object).isCA())) {
                    throw new AnnotatedException("End CRL only contains CA certificates.");
                }
            }
            if (issuingDistributionPoint.onlyContainsAttributeCerts()) {
                throw new AnnotatedException("onlyContainsAttributeCerts boolean is asserted.");
            }
        }
    }

    protected static void processCRLB1(DistributionPoint dp2, Object cert, X509CRL crl) throws AnnotatedException {
        ASN1Primitive aSN1Primitive = RevocationUtilities.getExtensionValue(crl, Extension.issuingDistributionPoint);
        boolean bl2 = false;
        if (aSN1Primitive != null && IssuingDistributionPoint.getInstance(aSN1Primitive).isIndirectCRL()) {
            bl2 = true;
        }
        byte[] byArray = crl.getIssuerX500Principal().getEncoded();
        boolean bl3 = false;
        if (dp2.getCRLIssuer() != null) {
            GeneralName[] generalNameArray = dp2.getCRLIssuer().getNames();
            for (int i2 = 0; i2 < generalNameArray.length; ++i2) {
                if (generalNameArray[i2].getTagNo() != 4) continue;
                try {
                    if (!Arrays.areEqual(generalNameArray[i2].getName().toASN1Primitive().getEncoded(), byArray)) continue;
                    bl3 = true;
                    continue;
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", iOException);
                }
            }
            if (bl3 && !bl2) {
                throw new AnnotatedException("Distribution point contains cRLIssuer field but CRL is not indirect.");
            }
            if (!bl3) {
                throw new AnnotatedException("CRL issuer of CRL does not match CRL issuer of distribution point.");
            }
        } else if (crl.getIssuerX500Principal().equals(((X509Certificate)cert).getIssuerX500Principal())) {
            bl3 = true;
        }
        if (!bl3) {
            throw new AnnotatedException("Cannot find matching CRL issuer for certificate.");
        }
    }

    protected static ReasonsMask processCRLD(X509CRL crl, DistributionPoint dp2) throws AnnotatedException {
        IssuingDistributionPoint issuingDistributionPoint = null;
        try {
            issuingDistributionPoint = IssuingDistributionPoint.getInstance(RevocationUtilities.getExtensionValue(crl, Extension.issuingDistributionPoint));
        }
        catch (Exception exception) {
            throw new AnnotatedException("Issuing distribution point extension could not be decoded.", exception);
        }
        if (issuingDistributionPoint != null && issuingDistributionPoint.getOnlySomeReasons() != null && dp2.getReasons() != null) {
            return new ReasonsMask(dp2.getReasons()).intersect(new ReasonsMask(issuingDistributionPoint.getOnlySomeReasons()));
        }
        if ((issuingDistributionPoint == null || issuingDistributionPoint.getOnlySomeReasons() == null) && dp2.getReasons() == null) {
            return ReasonsMask.allReasons;
        }
        return (dp2.getReasons() == null ? ReasonsMask.allReasons : new ReasonsMask(dp2.getReasons())).intersect(issuingDistributionPoint == null ? ReasonsMask.allReasons : new ReasonsMask(issuingDistributionPoint.getOnlySomeReasons()));
    }

    protected static Set processCRLF(X509CRL crl, Object cert, X509Certificate defaultCRLSignCert, PublicKey defaultCRLSignKey, PKIXExtendedParameters paramsPKIX, List certPathCerts, PKIXJcaJceHelper helper) throws AnnotatedException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Collection collection;
        Object object4;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            object4 = crl.getIssuerX500Principal().getEncoded();
            x509CertSelector.setSubject((byte[])object4);
        }
        catch (IOException iOException) {
            throw new AnnotatedException("subject criteria for certificate selector to find issuer certificate for CRL could not be set", iOException);
        }
        object4 = new PKIXCertStoreSelector.Builder(x509CertSelector).build();
        try {
            collection = RevocationUtilities.findCertificates((PKIXCertStoreSelector)object4, paramsPKIX.getCertificateStores());
            collection.addAll(RevocationUtilities.findCertificates((PKIXCertStoreSelector)object4, paramsPKIX.getCertStores()));
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Issuer certificate for CRL cannot be searched.", annotatedException);
        }
        collection.add(defaultCRLSignCert);
        Iterator iterator = collection.iterator();
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        ArrayList<PublicKey> arrayList2 = new ArrayList<PublicKey>();
        while (iterator.hasNext()) {
            serializable = (X509Certificate)iterator.next();
            if (((Certificate)serializable).equals(defaultCRLSignCert)) {
                arrayList.add(serializable);
                arrayList2.add(defaultCRLSignKey);
                continue;
            }
            try {
                object3 = helper.createCertPathBuilder("PKIX");
                X509CertSelector x509CertSelector2 = new X509CertSelector();
                x509CertSelector2.setCertificate((X509Certificate)serializable);
                object2 = new PKIXExtendedParameters.Builder(paramsPKIX).setTargetConstraints(new PKIXCertStoreSelector.Builder(x509CertSelector2).build());
                if (certPathCerts.contains(serializable)) {
                    ((PKIXExtendedParameters.Builder)object2).setRevocationEnabled(false);
                } else {
                    ((PKIXExtendedParameters.Builder)object2).setRevocationEnabled(true);
                }
                object = new PKIXExtendedBuilderParameters.Builder(((PKIXExtendedParameters.Builder)object2).build()).build();
                List<? extends Certificate> list = ((CertPathBuilder)object3).build((CertPathParameters)object).getCertPath().getCertificates();
                arrayList.add(serializable);
                arrayList2.add(RevocationUtilities.getNextWorkingKey(list, 0, helper));
            }
            catch (CertPathBuilderException certPathBuilderException) {
                throw new AnnotatedException("CertPath for CRL signer failed to validate.", certPathBuilderException);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new AnnotatedException("Public key of issuer certificate of CRL could not be retrieved.", certPathValidatorException);
            }
            catch (Exception exception) {
                throw new AnnotatedException(exception.getMessage());
            }
        }
        serializable = new HashSet();
        object3 = null;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            object2 = (X509Certificate)arrayList.get(i2);
            object = ((X509Certificate)object2).getKeyUsage();
            if (!(object == null || ((boolean[])object).length >= 7 && object[6])) {
                object3 = new AnnotatedException("Issuer certificate key usage extension does not permit CRL signing.");
                continue;
            }
            serializable.add(arrayList2.get(i2));
        }
        if (serializable.isEmpty() && object3 == null) {
            throw new AnnotatedException("Cannot find a valid issuer certificate.");
        }
        if (serializable.isEmpty() && object3 != null) {
            throw object3;
        }
        return serializable;
    }

    protected static PublicKey processCRLG(X509CRL crl, Set keys) throws AnnotatedException {
        Exception exception = null;
        for (PublicKey publicKey : keys) {
            try {
                crl.verify(publicKey);
                return publicKey;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        throw new AnnotatedException("Cannot verify CRL.", exception);
    }

    protected static X509CRL processCRLH(Set deltacrls, PublicKey key) throws AnnotatedException {
        Exception exception = null;
        for (X509CRL x509CRL : deltacrls) {
            try {
                x509CRL.verify(key);
                return x509CRL;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (exception != null) {
            throw new AnnotatedException("Cannot verify delta CRL.", exception);
        }
        return null;
    }

    protected static Set processCRLA1i(Date currentDate, PKIXExtendedParameters paramsPKIX, X509Certificate cert, X509CRL crl) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        if (paramsPKIX.isUseDeltasEnabled()) {
            CRLDistPoint cRLDistPoint = null;
            try {
                cRLDistPoint = CRLDistPoint.getInstance(RevocationUtilities.getExtensionValue(cert, Extension.freshestCRL));
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Freshest CRL extension could not be decoded from certificate.", annotatedException);
            }
            if (cRLDistPoint == null) {
                try {
                    cRLDistPoint = CRLDistPoint.getInstance(RevocationUtilities.getExtensionValue(crl, Extension.freshestCRL));
                }
                catch (AnnotatedException annotatedException) {
                    throw new AnnotatedException("Freshest CRL extension could not be decoded from CRL.", annotatedException);
                }
            }
            if (cRLDistPoint != null) {
                ArrayList<PKIXCRLStore> arrayList = new ArrayList<PKIXCRLStore>();
                arrayList.addAll(paramsPKIX.getCRLStores());
                try {
                    arrayList.addAll(RevocationUtilities.getAdditionalStoresFromCRLDistributionPoint(cRLDistPoint, paramsPKIX.getNamedCRLStoreMap()));
                }
                catch (AnnotatedException annotatedException) {
                    throw new AnnotatedException("No new delta CRL locations could be added from Freshest CRL extension.", annotatedException);
                }
                try {
                    hashSet.addAll(RevocationUtilities.getDeltaCRLs(currentDate, crl, paramsPKIX.getCertStores(), arrayList));
                }
                catch (AnnotatedException annotatedException) {
                    throw new AnnotatedException("Exception obtaining delta CRLs.", annotatedException);
                }
            }
        }
        return hashSet;
    }

    protected static Set[] processCRLA1ii(Date currentDate, PKIXExtendedParameters paramsPKIX, X509Certificate cert, X509CRL crl) throws AnnotatedException {
        HashSet hashSet = new HashSet();
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        x509CRLSelector.setCertificateChecking(cert);
        try {
            x509CRLSelector.addIssuerName(crl.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Cannot extract issuer from CRL." + iOException, iOException);
        }
        PKIXCRLStoreSelector<? extends CRL> pKIXCRLStoreSelector = new PKIXCRLStoreSelector.Builder(x509CRLSelector).setCompleteCRLEnabled(true).build();
        Date date = currentDate;
        if (paramsPKIX.getDate() != null) {
            date = paramsPKIX.getDate();
        }
        Set set = CRL_UTIL.findCRLs(pKIXCRLStoreSelector, date, paramsPKIX.getCertStores(), paramsPKIX.getCRLStores());
        if (paramsPKIX.isUseDeltasEnabled()) {
            try {
                hashSet.addAll(RevocationUtilities.getDeltaCRLs(date, crl, paramsPKIX.getCertStores(), paramsPKIX.getCRLStores()));
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Exception obtaining delta CRLs.", annotatedException);
            }
        }
        return new Set[]{set, hashSet};
    }

    protected static void processCRLC(X509CRL deltaCRL, X509CRL completeCRL, PKIXExtendedParameters pkixParams) throws AnnotatedException {
        if (deltaCRL == null) {
            return;
        }
        IssuingDistributionPoint issuingDistributionPoint = null;
        try {
            issuingDistributionPoint = IssuingDistributionPoint.getInstance(RevocationUtilities.getExtensionValue(completeCRL, Extension.issuingDistributionPoint));
        }
        catch (Exception exception) {
            throw new AnnotatedException("issuing distribution point extension could not be decoded.", exception);
        }
        if (pkixParams.isUseDeltasEnabled()) {
            if (!deltaCRL.getIssuerX500Principal().equals(completeCRL.getIssuerX500Principal())) {
                throw new AnnotatedException("complete CRL issuer does not match delta CRL issuer");
            }
            IssuingDistributionPoint issuingDistributionPoint2 = null;
            try {
                issuingDistributionPoint2 = IssuingDistributionPoint.getInstance(RevocationUtilities.getExtensionValue(deltaCRL, Extension.issuingDistributionPoint));
            }
            catch (Exception exception) {
                throw new AnnotatedException("Issuing distribution point extension from delta CRL could not be decoded.", exception);
            }
            boolean bl2 = false;
            if (issuingDistributionPoint == null) {
                if (issuingDistributionPoint2 == null) {
                    bl2 = true;
                }
            } else if (issuingDistributionPoint.equals(issuingDistributionPoint2)) {
                bl2 = true;
            }
            if (!bl2) {
                throw new AnnotatedException("Issuing distribution point extension from delta CRL and complete CRL does not match.");
            }
            ASN1Primitive aSN1Primitive = null;
            try {
                aSN1Primitive = RevocationUtilities.getExtensionValue(completeCRL, Extension.authorityKeyIdentifier);
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Authority key identifier extension could not be extracted from complete CRL.", annotatedException);
            }
            ASN1Primitive aSN1Primitive2 = null;
            try {
                aSN1Primitive2 = RevocationUtilities.getExtensionValue(deltaCRL, Extension.authorityKeyIdentifier);
            }
            catch (AnnotatedException annotatedException) {
                throw new AnnotatedException("Authority key identifier extension could not be extracted from delta CRL.", annotatedException);
            }
            if (aSN1Primitive == null) {
                throw new AnnotatedException("CRL authority key identifier is null.");
            }
            if (aSN1Primitive2 == null) {
                throw new AnnotatedException("Delta CRL authority key identifier is null.");
            }
            if (!aSN1Primitive.equals(aSN1Primitive2)) {
                throw new AnnotatedException("Delta CRL authority key identifier does not match complete CRL authority key identifier.");
            }
        }
    }

    protected static void processCRLI(Date validDate, X509CRL deltacrl, Object cert, CertStatus certStatus, PKIXExtendedParameters pkixParams) throws AnnotatedException {
        if (pkixParams.isUseDeltasEnabled() && deltacrl != null) {
            RevocationUtilities.getCertStatus(validDate, deltacrl, cert, certStatus);
        }
    }

    protected static void processCRLJ(Date validDate, X509CRL completecrl, Object cert, CertStatus certStatus) throws AnnotatedException {
        if (certStatus.getCertStatus() == 11) {
            RevocationUtilities.getCertStatus(validDate, completecrl, cert, certStatus);
        }
    }

    static void checkCRL(DistributionPoint dp2, PKIXExtendedParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate defaultCRLSignCert, PublicKey defaultCRLSignKey, CertStatus certStatus, ReasonsMask reasonMask, List certPathCerts, PKIXJcaJceHelper helper) throws AnnotatedException, CRLNotFoundException {
        Date date = new Date(System.currentTimeMillis());
        if (validDate.getTime() > date.getTime()) {
            throw new AnnotatedException("Validation time is in future.");
        }
        Date date2 = date;
        if (paramsPKIX.getDate() != null) {
            date2 = paramsPKIX.getDate();
        }
        Set set = RevocationUtilities.getCompleteCRLs(dp2, cert, date2, paramsPKIX.getCertStores(), paramsPKIX.getCRLStores());
        boolean bl2 = false;
        AnnotatedException annotatedException = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && certStatus.getCertStatus() == 11 && !reasonMask.isAllReasons()) {
            try {
                Set<String> set2;
                X509CRL x509CRL = (X509CRL)iterator.next();
                ReasonsMask reasonsMask = RFC3280CertPathUtilities.processCRLD(x509CRL, dp2);
                if (!reasonsMask.hasNewReasons(reasonMask)) continue;
                Set set3 = RFC3280CertPathUtilities.processCRLF(x509CRL, cert, defaultCRLSignCert, defaultCRLSignKey, paramsPKIX, certPathCerts, helper);
                PublicKey publicKey = RFC3280CertPathUtilities.processCRLG(x509CRL, set3);
                X509CRL x509CRL2 = null;
                if (paramsPKIX.isUseDeltasEnabled()) {
                    set2 = RevocationUtilities.getDeltaCRLs(date2, x509CRL, paramsPKIX.getCertStores(), paramsPKIX.getCRLStores());
                    x509CRL2 = RFC3280CertPathUtilities.processCRLH(set2, publicKey);
                }
                if (paramsPKIX.getValidityModel() != 1 && cert.getNotAfter().getTime() < x509CRL.getThisUpdate().getTime()) {
                    throw new AnnotatedException("No valid CRL for current time found.");
                }
                RFC3280CertPathUtilities.processCRLB1(dp2, cert, x509CRL);
                RFC3280CertPathUtilities.processCRLB2(dp2, cert, x509CRL);
                RFC3280CertPathUtilities.processCRLC(x509CRL2, x509CRL, paramsPKIX);
                RFC3280CertPathUtilities.processCRLI(validDate, x509CRL2, cert, certStatus, paramsPKIX);
                RFC3280CertPathUtilities.processCRLJ(validDate, x509CRL, cert, certStatus);
                if (certStatus.getCertStatus() == 8) {
                    certStatus.setCertStatus(11);
                }
                reasonMask.addReasons(reasonsMask);
                set2 = x509CRL.getCriticalExtensionOIDs();
                if (set2 != null) {
                    set2 = new HashSet<String>(set2);
                    set2.remove(Extension.issuingDistributionPoint.getId());
                    set2.remove(Extension.deltaCRLIndicator.getId());
                    if (!set2.isEmpty()) {
                        throw new AnnotatedException("CRL contains unsupported critical extensions.");
                    }
                }
                if (x509CRL2 != null && (set2 = x509CRL2.getCriticalExtensionOIDs()) != null) {
                    set2 = new HashSet<String>(set2);
                    set2.remove(Extension.issuingDistributionPoint.getId());
                    set2.remove(Extension.deltaCRLIndicator.getId());
                    if (!set2.isEmpty()) {
                        throw new AnnotatedException("Delta CRL contains unsupported critical extension.");
                    }
                }
                bl2 = true;
            }
            catch (AnnotatedException annotatedException2) {
                annotatedException = annotatedException2;
            }
        }
        if (!bl2) {
            throw annotatedException;
        }
    }
}

