/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.pkix.jcajce;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Enumerated;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1GeneralizedTime;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1InputStream;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.isismtt.ISISMTTObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.asn1.x500.style.RFC4519Style;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AuthorityKeyIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.CRLDistPoint;
import com.aspose.html.internal.ms.core.bc.asn1.x509.DistributionPoint;
import com.aspose.html.internal.ms.core.bc.asn1.x509.DistributionPointName;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralNames;
import com.aspose.html.internal.ms.core.bc.asn1.x509.IssuingDistributionPoint;
import com.aspose.html.internal.ms.core.bc.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXCRLStore;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXCRLStoreSelector;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXCertStore;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXCertStoreSelector;
import com.aspose.html.internal.ms.core.bc.jcajce.PKIXExtendedParameters;
import com.aspose.html.internal.ms.core.bc.jcajce.util.JcaJceHelper;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.AnnotatedException;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.CRLNotFoundException;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.CertStatus;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.PKIXCRLUtil;
import com.aspose.html.internal.ms.core.bc.pkix.jcajce.RFC3280CertPathUtilities;
import com.aspose.html.internal.ms.core.bc.util.Store;
import com.aspose.html.internal.ms.core.bc.util.StoreException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RevocationUtilities {
    protected static final PKIXCRLUtil CRL_UTIL = new PKIXCRLUtil();
    protected static final String CERTIFICATE_POLICIES = Extension.certificatePolicies.getId();
    protected static final String BASIC_CONSTRAINTS = Extension.basicConstraints.getId();
    protected static final String POLICY_MAPPINGS = Extension.policyMappings.getId();
    protected static final String SUBJECT_ALTERNATIVE_NAME = Extension.subjectAlternativeName.getId();
    protected static final String NAME_CONSTRAINTS = Extension.nameConstraints.getId();
    protected static final String KEY_USAGE = Extension.keyUsage.getId();
    protected static final String INHIBIT_ANY_POLICY = Extension.inhibitAnyPolicy.getId();
    protected static final String ISSUING_DISTRIBUTION_POINT = Extension.issuingDistributionPoint.getId();
    protected static final String DELTA_CRL_INDICATOR = Extension.deltaCRLIndicator.getId();
    protected static final String POLICY_CONSTRAINTS = Extension.policyConstraints.getId();
    protected static final String FRESHEST_CRL = Extension.freshestCRL.getId();
    protected static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    protected static final String AUTHORITY_KEY_IDENTIFIER = Extension.authorityKeyIdentifier.getId();
    protected static final String ANY_POLICY = "2.5.29.32.0";
    protected static final String CRL_NUMBER = Extension.cRLNumber.getId();
    protected static final int KEY_CERT_SIGN = 5;
    protected static final int CRL_SIGN = 6;
    protected static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    RevocationUtilities() {
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate cert, Set trustAnchors) throws AnnotatedException {
        return RevocationUtilities.findTrustAnchor(cert, trustAnchors, null);
    }

    protected static TrustAnchor findTrustAnchor(X509Certificate cert, Set trustAnchors, String sigProvider) throws AnnotatedException {
        TrustAnchor trustAnchor = null;
        PublicKey publicKey = null;
        Exception exception = null;
        X509CertSelector x509CertSelector = new X509CertSelector();
        X500Name x500Name = X500Name.getInstance(cert.getIssuerX500Principal());
        try {
            x509CertSelector.setSubject(x500Name.getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Cannot set subject search criteria for trust anchor.", iOException);
        }
        Iterator iterator = trustAnchors.iterator();
        while (iterator.hasNext() && trustAnchor == null) {
            block15: {
                trustAnchor = (TrustAnchor)iterator.next();
                if (trustAnchor.getTrustedCert() != null) {
                    if (x509CertSelector.match(trustAnchor.getTrustedCert())) {
                        publicKey = trustAnchor.getTrustedCert().getPublicKey();
                    } else {
                        trustAnchor = null;
                    }
                } else if (trustAnchor.getCAName() != null && trustAnchor.getCAPublicKey() != null) {
                    try {
                        X500Name x500Name2 = X500Name.getInstance(trustAnchor.getCA().getEncoded());
                        if (x500Name.equals(x500Name2)) {
                            publicKey = trustAnchor.getCAPublicKey();
                            break block15;
                        }
                        trustAnchor = null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        trustAnchor = null;
                    }
                } else {
                    trustAnchor = null;
                }
            }
            if (publicKey == null) continue;
            try {
                RevocationUtilities.verifyX509Certificate(cert, publicKey, sigProvider);
            }
            catch (Exception exception2) {
                exception = exception2;
                trustAnchor = null;
                publicKey = null;
            }
        }
        if (trustAnchor == null && exception != null) {
            throw new AnnotatedException("TrustAnchor found but certificate validation failed.", exception);
        }
        return trustAnchor;
    }

    static boolean isIssuerTrustAnchor(X509Certificate cert, Set trustAnchors, String sigProvider) throws AnnotatedException {
        try {
            return RevocationUtilities.findTrustAnchor(cert, trustAnchors, sigProvider) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static List<PKIXCertStore> getAdditionalStoresFromAltNames(byte[] issuerAlternativeName, Map<GeneralName, PKIXCertStore> altNameCertStoreMap) throws CertificateParsingException {
        if (issuerAlternativeName != null) {
            GeneralNames generalNames = GeneralNames.getInstance(ASN1OctetString.getInstance(issuerAlternativeName).getOctets());
            GeneralName[] generalNameArray = generalNames.getNames();
            ArrayList<PKIXCertStore> arrayList = new ArrayList<PKIXCertStore>();
            for (int i2 = 0; i2 != generalNameArray.length; ++i2) {
                GeneralName generalName = generalNameArray[i2];
                PKIXCertStore pKIXCertStore = altNameCertStoreMap.get(generalName);
                if (pKIXCertStore == null) continue;
                arrayList.add(pKIXCertStore);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    protected static Date getValidDate(PKIXExtendedParameters paramsPKIX) {
        Date date = paramsPKIX.getDate();
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    protected static boolean isSelfIssued(X509Certificate cert) {
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    protected static ASN1Primitive getExtensionValue(X509Extension ext, ASN1ObjectIdentifier oid) throws AnnotatedException {
        byte[] byArray = ext.getExtensionValue(oid.getId());
        if (byArray == null) {
            return null;
        }
        return RevocationUtilities.getObject(oid, byArray);
    }

    private static ASN1Primitive getObject(ASN1ObjectIdentifier oid, byte[] ext) throws AnnotatedException {
        try {
            return ASN1Primitive.fromByteArray(ASN1OctetString.getInstance(ext).getOctets());
        }
        catch (Exception exception) {
            throw new AnnotatedException("exception processing extension " + oid, exception);
        }
    }

    protected static AlgorithmIdentifier getAlgorithmIdentifier(PublicKey key) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(key.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithm();
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("subject public key cannot be decoded", exception);
        }
    }

    protected static Collection findCertificates(PKIXCertStoreSelector certSelect, List certStores) throws AnnotatedException {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        for (Object e2 : certStores) {
            Object object;
            if (e2 instanceof Store) {
                object = (Store)e2;
                try {
                    linkedHashSet.addAll(object.getMatches(certSelect));
                    continue;
                }
                catch (StoreException storeException) {
                    throw new AnnotatedException("Problem while picking certificates from X.509 store.", storeException);
                }
            }
            object = (CertStore)e2;
            try {
                linkedHashSet.addAll(PKIXCertStoreSelector.getCertificates(certSelect, (CertStore)object));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", certStoreException);
            }
        }
        return linkedHashSet;
    }

    static List<PKIXCRLStore> getAdditionalStoresFromCRLDistributionPoint(CRLDistPoint crldp, Map<GeneralName, PKIXCRLStore> namedCRLStoreMap) throws AnnotatedException {
        if (crldp != null) {
            DistributionPoint[] distributionPointArray = null;
            try {
                distributionPointArray = crldp.getDistributionPoints();
            }
            catch (Exception exception) {
                throw new AnnotatedException("Distribution points could not be read.", exception);
            }
            ArrayList<PKIXCRLStore> arrayList = new ArrayList<PKIXCRLStore>();
            for (int i2 = 0; i2 < distributionPointArray.length; ++i2) {
                DistributionPointName distributionPointName = distributionPointArray[i2].getDistributionPoint();
                if (distributionPointName == null || distributionPointName.getType() != 0) continue;
                GeneralName[] generalNameArray = GeneralNames.getInstance(distributionPointName.getName()).getNames();
                for (int i3 = 0; i3 < generalNameArray.length; ++i3) {
                    PKIXCRLStore pKIXCRLStore = namedCRLStoreMap.get(generalNameArray[i3]);
                    if (pKIXCRLStore == null) continue;
                    arrayList.add(pKIXCRLStore);
                }
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    protected static void getCRLIssuersFromDistributionPoint(DistributionPoint dp2, Collection issuerPrincipals, X509CRLSelector selector) throws AnnotatedException {
        Object object;
        ArrayList<X500Name> arrayList = new ArrayList<X500Name>();
        if (dp2.getCRLIssuer() != null) {
            object = dp2.getCRLIssuer().getNames();
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                if (((GeneralName)object[i2]).getTagNo() != 4) continue;
                try {
                    arrayList.add(X500Name.getInstance(((GeneralName)object[i2]).getName().toASN1Primitive().getEncoded()));
                    continue;
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", iOException);
                }
            }
        } else {
            if (dp2.getDistributionPoint() == null) {
                throw new AnnotatedException("CRL issuer is omitted from distribution point but no distributionPoint field present.");
            }
            object = issuerPrincipals.iterator();
            while (object.hasNext()) {
                arrayList.add((X500Name)object.next());
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                selector.addIssuerName(((X500Name)object.next()).getEncoded());
            }
            catch (IOException iOException) {
                throw new AnnotatedException("Cannot decode CRL issuer information.", iOException);
            }
        }
    }

    private static BigInteger getSerialNumber(Object cert) {
        return ((X509Certificate)cert).getSerialNumber();
    }

    protected static void getCertStatus(Date validDate, X509CRL crl, Object cert, CertStatus certStatus) throws AnnotatedException {
        Object object;
        boolean bl2;
        X509CRLEntry x509CRLEntry = null;
        try {
            bl2 = RevocationUtilities.isIndirectCRL(crl);
        }
        catch (CRLException cRLException) {
            throw new AnnotatedException("Failed check for indirect CRL.", cRLException);
        }
        if (bl2) {
            x509CRLEntry = crl.getRevokedCertificate(RevocationUtilities.getSerialNumber(cert));
            if (x509CRLEntry == null) {
                return;
            }
            object = x509CRLEntry.getCertificateIssuer();
            X500Name x500Name = object == null ? X500Name.getInstance(crl.getIssuerX500Principal()) : X500Name.getInstance(((X500Principal)object).getEncoded());
            if (!X500Name.getInstance(((X509Certificate)cert).getIssuerX500Principal().getEncoded()).equals(x500Name)) {
                return;
            }
        } else {
            if (!X500Name.getInstance(((X509Certificate)cert).getIssuerX500Principal().getEncoded()).equals(X500Name.getInstance(crl.getIssuerX500Principal().getEncoded()))) {
                return;
            }
            x509CRLEntry = crl.getRevokedCertificate(RevocationUtilities.getSerialNumber(cert));
            if (x509CRLEntry == null) {
                return;
            }
        }
        object = null;
        if (x509CRLEntry.hasExtensions()) {
            try {
                object = ASN1Enumerated.getInstance(RevocationUtilities.getExtensionValue(x509CRLEntry, Extension.reasonCode));
            }
            catch (Exception exception) {
                throw new AnnotatedException("Reason code CRL entry extension could not be decoded.", exception);
            }
        }
        if (validDate.getTime() >= x509CRLEntry.getRevocationDate().getTime() || object == null || ((ASN1Enumerated)object).getValue().intValue() == 0 || ((ASN1Enumerated)object).getValue().intValue() == 1 || ((ASN1Enumerated)object).getValue().intValue() == 2 || ((ASN1Enumerated)object).getValue().intValue() == 8) {
            if (object != null) {
                certStatus.setCertStatus(((ASN1Enumerated)object).getValue().intValue());
            } else {
                certStatus.setCertStatus(0);
            }
            certStatus.setRevocationDate(x509CRLEntry.getRevocationDate());
        }
    }

    protected static Set getDeltaCRLs(Date validityDate, X509CRL completeCRL, List<CertStore> certStores, List<PKIXCRLStore> pkixCrlStores) throws AnnotatedException {
        Object object;
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            x509CRLSelector.addIssuerName(X500Name.getInstance(completeCRL.getIssuerX500Principal().getEncoded()).getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("cannot extract issuer from CRL.", iOException);
        }
        BigInteger bigInteger = null;
        try {
            object = RevocationUtilities.getExtensionValue(completeCRL, Extension.cRLNumber);
            if (object != null) {
                bigInteger = ASN1Integer.getInstance(object).getPositiveValue();
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("cannot extract CRL number extension from CRL", exception);
        }
        object = null;
        try {
            object = completeCRL.getExtensionValue(ISSUING_DISTRIBUTION_POINT);
        }
        catch (Exception exception) {
            throw new AnnotatedException("issuing distribution point extension value could not be read", exception);
        }
        x509CRLSelector.setMinCRLNumber(bigInteger == null ? null : bigInteger.add(BigInteger.valueOf(1L)));
        PKIXCRLStoreSelector.Builder builder = new PKIXCRLStoreSelector.Builder(x509CRLSelector);
        builder.setIssuingDistributionPoint((byte[])object);
        builder.setIssuingDistributionPointEnabled(true);
        builder.setMaxBaseCRLNumber(bigInteger);
        PKIXCRLStoreSelector<? extends CRL> pKIXCRLStoreSelector = builder.build();
        Set set = CRL_UTIL.findCRLs(pKIXCRLStoreSelector, validityDate, certStores, pkixCrlStores);
        HashSet<X509CRL> hashSet = new HashSet<X509CRL>();
        for (X509CRL x509CRL : set) {
            if (!RevocationUtilities.isDeltaCRL(x509CRL)) continue;
            hashSet.add(x509CRL);
        }
        return hashSet;
    }

    private static boolean isDeltaCRL(X509CRL crl) {
        Set<String> set = crl.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        return set.contains(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
    }

    protected static Set getCompleteCRLs(DistributionPoint dp2, Object cert, Date validityDate, List certStores, List crlStores) throws AnnotatedException, CRLNotFoundException {
        Cloneable cloneable;
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            cloneable = new HashSet<X500Name>();
            cloneable.add(X500Name.getInstance(((X509Certificate)cert).getIssuerX500Principal().getEncoded()));
            RevocationUtilities.getCRLIssuersFromDistributionPoint(dp2, cloneable, x509CRLSelector);
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Could not get issuer information from distribution point.", annotatedException);
        }
        if (cert instanceof X509Certificate) {
            x509CRLSelector.setCertificateChecking((X509Certificate)cert);
        }
        cloneable = new PKIXCRLStoreSelector.Builder(x509CRLSelector).setCompleteCRLEnabled(true).build();
        Set set = CRL_UTIL.findCRLs((PKIXCRLStoreSelector)cloneable, validityDate, certStores, crlStores);
        RevocationUtilities.checkCRLsNotEmpty(set, cert);
        return set;
    }

    protected static Date getValidCertDateFromValidityModel(PKIXExtendedParameters paramsPKIX, CertPath certPath, int index) throws AnnotatedException {
        if (paramsPKIX.getValidityModel() == 1) {
            if (index <= 0) {
                return RevocationUtilities.getValidDate(paramsPKIX);
            }
            if (index - 1 == 0) {
                ASN1GeneralizedTime aSN1GeneralizedTime = null;
                try {
                    byte[] byArray = ((X509Certificate)certPath.getCertificates().get(index - 1)).getExtensionValue(ISISMTTObjectIdentifiers.id_isismtt_at_dateOfCertGen.getId());
                    if (byArray != null) {
                        aSN1GeneralizedTime = ASN1GeneralizedTime.getInstance(ASN1Primitive.fromByteArray(byArray));
                    }
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("Date of cert gen extension could not be read.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new AnnotatedException("Date of cert gen extension could not be read.");
                }
                if (aSN1GeneralizedTime != null) {
                    try {
                        return aSN1GeneralizedTime.getDate();
                    }
                    catch (ParseException parseException) {
                        throw new AnnotatedException("Date from date of cert gen extension could not be parsed.", parseException);
                    }
                }
                return ((X509Certificate)certPath.getCertificates().get(index - 1)).getNotBefore();
            }
            return ((X509Certificate)certPath.getCertificates().get(index - 1)).getNotBefore();
        }
        return RevocationUtilities.getValidDate(paramsPKIX);
    }

    protected static PublicKey getNextWorkingKey(List certs, int index, JcaJceHelper helper) throws CertPathValidatorException {
        Certificate certificate = (Certificate)certs.get(index);
        PublicKey publicKey = certificate.getPublicKey();
        if (!(publicKey instanceof DSAPublicKey)) {
            return publicKey;
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        if (dSAPublicKey.getParams() != null) {
            return dSAPublicKey;
        }
        for (int i2 = index + 1; i2 < certs.size(); ++i2) {
            X509Certificate x509Certificate = (X509Certificate)certs.get(i2);
            publicKey = x509Certificate.getPublicKey();
            if (!(publicKey instanceof DSAPublicKey)) {
                throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
            }
            DSAPublicKey dSAPublicKey2 = (DSAPublicKey)publicKey;
            if (dSAPublicKey2.getParams() == null) continue;
            DSAParams dSAParams = dSAPublicKey2.getParams();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicKey.getY(), dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            try {
                KeyFactory keyFactory = helper.createKeyFactory("DSA");
                return keyFactory.generatePublic(dSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
    }

    static Collection findIssuerCerts(X509Certificate cert, List<CertStore> certStores, List<PKIXCertStore> pkixCertStores) throws AnnotatedException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(cert.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Subject criteria for certificate selector to find issuer certificate could not be set.", iOException);
        }
        try {
            object3 = cert.getExtensionValue(AUTHORITY_KEY_IDENTIFIER);
            if (object3 != null && (object2 = AuthorityKeyIdentifier.getInstance(((ASN1OctetString)(object = ASN1OctetString.getInstance(object3))).getOctets()).getKeyIdentifier()) != null) {
                x509CertSelector.setSubjectKeyIdentifier(new DEROctetString((byte[])object2).getEncoded());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = new PKIXCertStoreSelector.Builder(x509CertSelector).build();
        object = new LinkedHashSet();
        try {
            serializable = new ArrayList();
            serializable.addAll(RevocationUtilities.findCertificates((PKIXCertStoreSelector)object3, certStores));
            serializable.addAll(RevocationUtilities.findCertificates((PKIXCertStoreSelector)object3, pkixCertStores));
            object2 = serializable.iterator();
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Issuer certificate cannot be searched.", annotatedException);
        }
        serializable = null;
        while (object2.hasNext()) {
            serializable = (X509Certificate)object2.next();
            object.add(serializable);
        }
        return object;
    }

    protected static void verifyX509Certificate(X509Certificate cert, PublicKey publicKey, String sigProvider) throws GeneralSecurityException {
        if (sigProvider == null) {
            cert.verify(publicKey);
        } else {
            cert.verify(publicKey, sigProvider);
        }
    }

    static void checkCRLsNotEmpty(Set crls, Object cert) throws CRLNotFoundException {
        if (crls.isEmpty()) {
            X509Certificate x509Certificate = (X509Certificate)cert;
            throw new CRLNotFoundException("No CRLs found for issuer \"" + RFC4519Style.INSTANCE.toString(X500Name.getInstance(x509Certificate.getIssuerX500Principal().getEncoded())) + "\"");
        }
    }

    public static boolean isIndirectCRL(X509CRL crl) throws CRLException {
        try {
            byte[] byArray = crl.getExtensionValue(Extension.issuingDistributionPoint.getId());
            return byArray != null && IssuingDistributionPoint.getInstance(ASN1OctetString.getInstance(byArray).getOctets()).isIndirectCRL();
        }
        catch (Exception exception) {
            throw new CRLException("exception reading IssuingDistributionPoint", exception);
        }
    }
}

