/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.tsp;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1Boolean;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1GeneralizedTime;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Object;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.DERNull;
import com.aspose.html.internal.ms.core.bc.asn1.cms.AttributeTable;
import com.aspose.html.internal.ms.core.bc.asn1.ess.ESSCertID;
import com.aspose.html.internal.ms.core.bc.asn1.ess.ESSCertIDv2;
import com.aspose.html.internal.ms.core.bc.asn1.ess.SigningCertificate;
import com.aspose.html.internal.ms.core.bc.asn1.ess.SigningCertificateV2;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.tsp.Accuracy;
import com.aspose.html.internal.ms.core.bc.asn1.tsp.MessageImprint;
import com.aspose.html.internal.ms.core.bc.asn1.tsp.TSTInfo;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extensions;
import com.aspose.html.internal.ms.core.bc.asn1.x509.ExtensionsGenerator;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralName;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralNames;
import com.aspose.html.internal.ms.core.bc.asn1.x509.IssuerSerial;
import com.aspose.html.internal.ms.core.bc.cert.X509CertificateHolder;
import com.aspose.html.internal.ms.core.bc.cms.CMSAttributeTableGenerationException;
import com.aspose.html.internal.ms.core.bc.cms.CMSAttributeTableGenerator;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.cms.CMSProcessableByteArray;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignedData;
import com.aspose.html.internal.ms.core.bc.cms.CMSSignedDataGenerator;
import com.aspose.html.internal.ms.core.bc.cms.SignerInfoGenerator;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import com.aspose.html.internal.ms.core.bc.tsp.TSPException;
import com.aspose.html.internal.ms.core.bc.tsp.TSPUtil;
import com.aspose.html.internal.ms.core.bc.tsp.TimeStampRequest;
import com.aspose.html.internal.ms.core.bc.tsp.TimeStampToken;
import com.aspose.html.internal.ms.core.bc.util.CollectionStore;
import com.aspose.html.internal.ms.core.bc.util.Encodable;
import com.aspose.html.internal.ms.core.bc.util.Store;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;

public class TimeStampTokenGenerator {
    public static final int R_SECONDS = 0;
    public static final int R_TENTHS_OF_SECONDS = 1;
    public static final int R_MICROSECONDS = 2;
    public static final int R_MILLISECONDS = 3;
    private int resolution = 0;
    private Locale locale = null;
    private int accuracySeconds = -1;
    private int accuracyMillis = -1;
    private int accuracyMicros = -1;
    boolean ordering = false;
    GeneralName tsa = null;
    private ASN1ObjectIdentifier tsaPolicyOID;
    private List certs = new ArrayList();
    private List crls = new ArrayList();
    private List attrCerts = new ArrayList();
    private Map otherRevoc = new HashMap();
    private SignerInfoGenerator signerInfoGen;

    public TimeStampTokenGenerator(SignerInfoGenerator signerInfoGen, DigestCalculator digestCalculator, ASN1ObjectIdentifier tsaPolicy) throws IllegalArgumentException, TSPException {
        this(signerInfoGen, digestCalculator, tsaPolicy, false);
    }

    public TimeStampTokenGenerator(final SignerInfoGenerator signerInfoGen, DigestCalculator digestCalculator, ASN1ObjectIdentifier tsaPolicy, boolean isIssuerSerialIncluded) throws IllegalArgumentException, TSPException {
        this.signerInfoGen = signerInfoGen;
        this.tsaPolicyOID = tsaPolicy;
        if (!signerInfoGen.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("SignerInfoGenerator must have an associated certificate");
        }
        X509CertificateHolder x509CertificateHolder = signerInfoGen.getAssociatedCertificate();
        TSPUtil.validateCertificate(x509CertificateHolder);
        try {
            OutputStream outputStream = digestCalculator.getOutputStream();
            outputStream.write(x509CertificateHolder.getEncoded());
            outputStream.close();
            if (digestCalculator.getAlgorithmIdentifier().getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
                final ESSCertID eSSCertID = new ESSCertID(digestCalculator.getDigest(), isIssuerSerialIncluded ? new IssuerSerial(new GeneralNames(new GeneralName(x509CertificateHolder.getIssuer())), x509CertificateHolder.getSerialNumber()) : null);
                this.signerInfoGen = new SignerInfoGenerator(signerInfoGen, new CMSAttributeTableGenerator(){

                    public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
                        AttributeTable attributeTable = signerInfoGen.getSignedAttributeTableGenerator().getAttributes(parameters);
                        if (attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate) == null) {
                            return attributeTable.add(PKCSObjectIdentifiers.id_aa_signingCertificate, new SigningCertificate(eSSCertID));
                        }
                        return attributeTable;
                    }
                }, signerInfoGen.getUnsignedAttributeTableGenerator());
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestCalculator.getAlgorithmIdentifier().getAlgorithm());
                final ESSCertIDv2 eSSCertIDv2 = new ESSCertIDv2(algorithmIdentifier, digestCalculator.getDigest(), isIssuerSerialIncluded ? new IssuerSerial(new GeneralNames(new GeneralName(x509CertificateHolder.getIssuer())), new ASN1Integer(x509CertificateHolder.getSerialNumber())) : null);
                this.signerInfoGen = new SignerInfoGenerator(signerInfoGen, new CMSAttributeTableGenerator(){

                    public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
                        AttributeTable attributeTable = signerInfoGen.getSignedAttributeTableGenerator().getAttributes(parameters);
                        if (attributeTable.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2) == null) {
                            return attributeTable.add(PKCSObjectIdentifiers.id_aa_signingCertificateV2, new SigningCertificateV2(eSSCertIDv2));
                        }
                        return attributeTable;
                    }
                }, signerInfoGen.getUnsignedAttributeTableGenerator());
            }
        }
        catch (IOException iOException) {
            throw new TSPException("Exception processing certificate.", iOException);
        }
    }

    public void addCertificates(Store certStore) {
        this.certs.addAll(certStore.getMatches(null));
    }

    public void addCRLs(Store crlStore) {
        this.crls.addAll(crlStore.getMatches(null));
    }

    public void addAttributeCertificates(Store attrStore) {
        this.attrCerts.addAll(attrStore.getMatches(null));
    }

    public void addOtherRevocationInfo(ASN1ObjectIdentifier otherRevocationInfoFormat, Store otherRevocationInfos) {
        this.otherRevoc.put(otherRevocationInfoFormat, otherRevocationInfos.getMatches(null));
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setAccuracySeconds(int accuracySeconds) {
        this.accuracySeconds = accuracySeconds;
    }

    public void setAccuracyMillis(int accuracyMillis) {
        this.accuracyMillis = accuracyMillis;
    }

    public void setAccuracyMicros(int accuracyMicros) {
        this.accuracyMicros = accuracyMicros;
    }

    public void setOrdering(boolean ordering) {
        this.ordering = ordering;
    }

    public void setTSA(GeneralName tsa) {
        this.tsa = tsa;
    }

    public TimeStampToken generate(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        return this.generate(request, serialNumber, genTime, null);
    }

    public TimeStampToken generate(TimeStampRequest request, BigInteger serialNumber, Date genTime, Extensions additionalExtensions) throws TSPException {
        Object object;
        Object object2;
        ASN1Primitive aSN1Primitive;
        ASN1Integer aSN1Integer;
        ASN1Primitive aSN1Primitive2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = request.getMessageImprintAlgOID();
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
        MessageImprint messageImprint = new MessageImprint(algorithmIdentifier, request.getMessageImprintDigest());
        Accuracy accuracy = null;
        if (this.accuracySeconds > 0 || this.accuracyMillis > 0 || this.accuracyMicros > 0) {
            aSN1Primitive2 = null;
            if (this.accuracySeconds > 0) {
                aSN1Primitive2 = new ASN1Integer(this.accuracySeconds);
            }
            aSN1Integer = null;
            if (this.accuracyMillis > 0) {
                aSN1Integer = new ASN1Integer(this.accuracyMillis);
            }
            aSN1Primitive = null;
            if (this.accuracyMicros > 0) {
                aSN1Primitive = new ASN1Integer(this.accuracyMicros);
            }
            accuracy = new Accuracy((ASN1Integer)aSN1Primitive2, aSN1Integer, (ASN1Integer)aSN1Primitive);
        }
        aSN1Primitive2 = null;
        if (this.ordering) {
            aSN1Primitive2 = ASN1Boolean.getInstance(this.ordering);
        }
        aSN1Integer = null;
        if (request.getNonce() != null) {
            aSN1Integer = new ASN1Integer(request.getNonce());
        }
        aSN1Primitive = this.tsaPolicyOID;
        if (request.getReqPolicy() != null) {
            aSN1Primitive = request.getReqPolicy();
        }
        Extensions extensions = request.getExtensions();
        if (additionalExtensions != null) {
            object2 = new ExtensionsGenerator();
            if (extensions != null) {
                object = extensions.oids();
                while (object.hasMoreElements()) {
                    ((ExtensionsGenerator)object2).addExtension(extensions.getExtension(ASN1ObjectIdentifier.getInstance(object.nextElement())));
                }
            }
            object = additionalExtensions.oids();
            while (object.hasMoreElements()) {
                ((ExtensionsGenerator)object2).addExtension(additionalExtensions.getExtension(ASN1ObjectIdentifier.getInstance(object.nextElement())));
            }
            extensions = ((ExtensionsGenerator)object2).generate();
        }
        object2 = this.resolution == 0 ? (this.locale == null ? new ASN1GeneralizedTime(genTime) : new ASN1GeneralizedTime(genTime, this.locale)) : this.createGeneralizedTime(genTime);
        object = new TSTInfo((ASN1ObjectIdentifier)aSN1Primitive, messageImprint, new ASN1Integer(serialNumber), (ASN1GeneralizedTime)object2, accuracy, (ASN1Boolean)aSN1Primitive2, aSN1Integer, this.tsa, extensions);
        try {
            Encodable encodable2;
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            if (request.getCertReq()) {
                cMSSignedDataGenerator.addCertificates(new CollectionStore(this.certs));
                cMSSignedDataGenerator.addAttributeCertificates(new CollectionStore(this.attrCerts));
            }
            cMSSignedDataGenerator.addCRLs(new CollectionStore(this.crls));
            if (!this.otherRevoc.isEmpty()) {
                for (Encodable encodable2 : this.otherRevoc.keySet()) {
                    cMSSignedDataGenerator.addOtherRevocationInfo((ASN1ObjectIdentifier)encodable2, new CollectionStore((Collection)this.otherRevoc.get(encodable2)));
                }
            }
            cMSSignedDataGenerator.addSignerInfoGenerator(this.signerInfoGen);
            Object object3 = ((ASN1Object)object).getEncoded("DER");
            encodable2 = cMSSignedDataGenerator.generate(new CMSProcessableByteArray(PKCSObjectIdentifiers.id_ct_TSTInfo, (byte[])object3), true);
            return new TimeStampToken((CMSSignedData)encodable2);
        }
        catch (CMSException cMSException) {
            throw new TSPException("Error generating time-stamp token", cMSException);
        }
        catch (IOException iOException) {
            throw new TSPException("Exception encoding info", iOException);
        }
    }

    private ASN1GeneralizedTime createGeneralizedTime(Date time) throws TSPException {
        String string = "yyyyMMddHHmmss.SSS";
        SimpleDateFormat simpleDateFormat = this.locale == null ? new SimpleDateFormat(string) : new SimpleDateFormat(string, this.locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(time));
        int n2 = stringBuilder.indexOf(".");
        if (n2 < 0) {
            stringBuilder.append("Z");
            return new ASN1GeneralizedTime(stringBuilder.toString());
        }
        switch (this.resolution) {
            case 1: {
                if (stringBuilder.length() <= n2 + 2) break;
                stringBuilder.delete(n2 + 2, stringBuilder.length());
                break;
            }
            case 2: {
                if (stringBuilder.length() <= n2 + 3) break;
                stringBuilder.delete(n2 + 3, stringBuilder.length());
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new TSPException("unknown time-stamp resolution: " + this.resolution);
            }
        }
        while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (stringBuilder.length() - 1 == n2) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("Z");
        return new ASN1GeneralizedTime(stringBuilder.toString());
    }
}

