/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.tsp.cms;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1String;
import com.aspose.html.internal.ms.core.bc.asn1.cms.Attributes;
import com.aspose.html.internal.ms.core.bc.asn1.cms.MetaData;
import com.aspose.html.internal.ms.core.bc.cms.CMSException;
import com.aspose.html.internal.ms.core.bc.operator.DigestCalculator;
import java.io.IOException;

class MetaDataUtil {
    private final MetaData metaData;

    MetaDataUtil(MetaData metaData) {
        this.metaData = metaData;
    }

    void initialiseMessageImprintDigestCalculator(DigestCalculator calculator) throws CMSException {
        if (this.metaData != null && this.metaData.isHashProtected()) {
            try {
                calculator.getOutputStream().write(this.metaData.getEncoded("DER"));
            }
            catch (IOException iOException) {
                throw new CMSException("unable to initialise calculator from metaData: " + iOException.getMessage(), iOException);
            }
        }
    }

    String getFileName() {
        if (this.metaData != null) {
            return this.convertString(this.metaData.getFileName());
        }
        return null;
    }

    String getMediaType() {
        if (this.metaData != null) {
            return this.convertString(this.metaData.getMediaType());
        }
        return null;
    }

    Attributes getOtherMetaData() {
        if (this.metaData != null) {
            return this.metaData.getOtherMetaData();
        }
        return null;
    }

    private String convertString(ASN1String s2) {
        if (s2 != null) {
            return s2.toString();
        }
        return null;
    }
}

