/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net;

import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.IO.StreamReader;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.p131.z4;
import com.aspose.html.net.ContentHeaders;

public abstract class Content
implements IDisposable {
    public static final Encoding DEFAULT_STRING_ENCODING = Encoding.getUTF8();
    public static final Encoding DEFAULT_HTTP_ENCODING = Encoding.getEncoding(28591);
    private boolean isDisposed;
    private ContentHeaders headers;
    private MemoryStream buffer;

    protected Content() {
    }

    public ContentHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new ContentHeaders();
        }
        return this.headers;
    }

    protected abstract void serializeToStream(Stream var1);

    private boolean isBuffered() {
        return this.buffer != null;
    }

    private MemoryStream getBuffer() {
        if (!this.isBuffered()) {
            this.buffer = new MemoryStream();
            this.serializeToStream(this.buffer);
        }
        this.buffer.seek(0L, 0);
        return this.buffer;
    }

    public Stream readAsStream() {
        this.checkDisposed();
        return new z1(new MemoryStream(this.readAsByteArray()));
    }

    public byte[] readAsByteArray() {
        this.checkDisposed();
        return this.getBuffer().toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAsString() {
        Encoding encoding;
        this.checkDisposed();
        String string = null;
        if (!StringExtensions.isNullOrEmpty(this.getHeaders().get_Item("Content-Type")) && (encoding = z4.m362(this.getHeaders().get_Item("Content-Type"))) != null) {
            string = encoding.getWebName();
        }
        encoding = !StringExtensions.isNullOrEmpty(string) ? Encoding.getEncoding(string) : DEFAULT_STRING_ENCODING;
        StreamReader streamReader = new StreamReader(this.readAsStream(), encoding, true);
        try {
            String string2 = streamReader.readToEnd();
            return string2;
        }
        finally {
            if (streamReader != null) {
                streamReader.dispose();
            }
        }
    }

    private void checkDisposed() {
        if (this.isDisposed) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
    }

    protected void dispose(boolean disposing) {
        if (!this.isDisposed) {
            this.isDisposed = true;
        }
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    private static class z1
    extends com.aspose.html.internal.p276.z1 {
        public z1(Stream stream) {
            super(stream);
        }

        @Override
        public boolean canWrite() {
            return false;
        }

        @Override
        public int getWriteTimeout() {
            throw new NotSupportedException("The stream does not support writing.");
        }

        @Override
        public void setWriteTimeout(int value) {
            throw new NotSupportedException("The stream does not support writing.");
        }

        @Override
        public void flush() {
            throw new NotSupportedException("The stream does not support writing.");
        }

        @Override
        public void setLength(long value) {
            throw new NotSupportedException("The stream does not support writing.");
        }

        @Override
        public void write(byte[] buffer, int offset, int count) {
            throw new NotSupportedException("The stream does not support writing.");
        }

        @Override
        public void writeByte(byte value) {
            throw new NotSupportedException("The stream does not support writing.");
        }
    }
}

