/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net;

import com.aspose.html.internal.ms.System.IEquatable;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

public class HttpMethod
implements IEquatable<HttpMethod> {
    private static final HttpMethod getMethod = new HttpMethod("GET");
    private static final HttpMethod putMethod = new HttpMethod("PUT");
    private static final HttpMethod postMethod = new HttpMethod("POST");
    private static final HttpMethod deleteMethod = new HttpMethod("DELETE");
    private final String method;

    public HttpMethod(String method) {
        this.method = StringExtensions.toUpper(method);
    }

    public static HttpMethod getGet() {
        return getMethod;
    }

    public static HttpMethod getPut() {
        return putMethod;
    }

    public static HttpMethod getPost() {
        return postMethod;
    }

    public static HttpMethod getDelete() {
        return deleteMethod;
    }

    public static boolean op_Equality(HttpMethod left, HttpMethod right) {
        if (ObjectExtensions.referenceEquals(left, right)) {
            return true;
        }
        if (ObjectExtensions.referenceEquals(null, left) || ObjectExtensions.referenceEquals(null, right)) {
            return false;
        }
        return left.equals(right);
    }

    public static boolean op_Inequality(HttpMethod left, HttpMethod right) {
        return !HttpMethod.op_Equality(left, right);
    }

    public static HttpMethod to_HttpMethod(String name) {
        return new HttpMethod(name);
    }

    public String getName() {
        return this.method;
    }

    public boolean equals(HttpMethod other) {
        if (ObjectExtensions.referenceEquals(other, null)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(other, this)) {
            return true;
        }
        if (ObjectExtensions.referenceEquals(this.method, other.method)) {
            return true;
        }
        return StringExtensions.equals(this.method, other.method, (short)5);
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(Operators.as(obj, HttpMethod.class));
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        return this.method;
    }
}

