/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.net.headers;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericCollection;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.DateTimeOffset;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p147.z1;
import com.aspose.html.net.headers.NameValueHeaderValue;
import com.aspose.html.z21;

public class ContentDispositionHeaderValue {
    private static final String fileName = "filename";
    private static final String name = "name";
    private static final String fileNameStar = "filename*";
    private static final String creationDate = "creation-date";
    private static final String modificationDate = "modification-date";
    private static final String readDate = "read-date";
    private List<NameValueHeaderValue> _parameters;
    private String _dispositionType;

    public ContentDispositionHeaderValue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentDispositionHeaderValue(ContentDispositionHeaderValue source) {
        this._dispositionType = source._dispositionType;
        if (source._parameters != null) {
            IGenericEnumerator iGenericEnumerator = source._parameters.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    NameValueHeaderValue nameValueHeaderValue = (NameValueHeaderValue)iGenericEnumerator.next();
                    this.getParameters().addItem((NameValueHeaderValue)((ICloneable)((Object)nameValueHeaderValue)).deepClone());
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    public ContentDispositionHeaderValue(String dispositionType) {
        ContentDispositionHeaderValue.checkDispositionTypeFormat(dispositionType, "dispositionType");
        this._dispositionType = dispositionType;
    }

    private static int getDispositionTypeExpressionLength(String input, int startIndex, String[] dispositionType) {
        dispositionType[0] = null;
        int n2 = z1.m21(input, startIndex);
        if (n2 == 0) {
            return 0;
        }
        dispositionType[0] = StringExtensions.substring(input, startIndex, n2);
        return n2;
    }

    private static void checkDispositionTypeFormat(String dispositionType, String parameterName) {
        if (StringExtensions.isNullOrEmpty(dispositionType)) {
            throw new ArgumentException(StringExtensions.format("DispositionType is null or empty {0}", parameterName));
        }
        String string = null;
        String[] stringArray = new String[]{string};
        int n2 = ContentDispositionHeaderValue.getDispositionTypeExpressionLength(dispositionType, 0, stringArray);
        string = stringArray[0];
        if (n2 == 0 || string.length() != dispositionType.length()) {
            throw new FormatException(StringExtensions.format("Invalid header {0}", dispositionType));
        }
    }

    public String getDispositionType() {
        return this._dispositionType;
    }

    public void setDispositionType(String value) {
        ContentDispositionHeaderValue.checkDispositionTypeFormat(value, "value");
        this._dispositionType = value;
    }

    public IGenericCollection<NameValueHeaderValue> getParameters() {
        if (this._parameters == null) {
            this._parameters = new List();
        }
        return this._parameters;
    }

    public String getName() {
        return this.getName(name);
    }

    public void setName(String value) {
        this.setName(name, value);
    }

    public String getFileName() {
        return this.getName(fileName);
    }

    public void setFileName(String value) {
        this.setName(fileName, value);
    }

    private String getFileNameStar() {
        return this.getName(fileNameStar);
    }

    private void setFileNameStar(String value) {
        this.setName(fileNameStar, value);
    }

    private DateTimeOffset getCreationDate() {
        return this.getDate(creationDate);
    }

    private void setCreationDate(DateTimeOffset value) {
        this.setDate(creationDate, value.Clone());
    }

    private DateTimeOffset getModificationDate() {
        return this.getDate(modificationDate);
    }

    private void setModificationDate(DateTimeOffset value) {
        this.setDate(modificationDate, value.Clone());
    }

    private DateTimeOffset getReadDate() {
        return this.getDate(readDate);
    }

    private void setReadDate(DateTimeOffset value) {
        this.setDate(readDate, value.Clone());
    }

    public String toString() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.append(this._dispositionType);
        NameValueHeaderValue.toString(this._parameters, ';', true, msStringBuilder2);
        return msStringBuilder2.toString();
    }

    public boolean equals(Object obj) {
        ContentDispositionHeaderValue contentDispositionHeaderValue = Operators.as(obj, ContentDispositionHeaderValue.class);
        if (contentDispositionHeaderValue == null) {
            return false;
        }
        return StringExtensions.equals(this._dispositionType, contentDispositionHeaderValue._dispositionType, (short)5) && this._parameters.equals(contentDispositionHeaderValue._parameters);
    }

    private DateTimeOffset getDate(String parameter) {
        NameValueHeaderValue nameValueHeaderValue = NameValueHeaderValue.find(this._parameters, parameter);
        DateTimeOffset dateTimeOffset = new DateTimeOffset();
        if (nameValueHeaderValue != null) {
            String string = nameValueHeaderValue.getValue();
            if (this.isQuoted(string)) {
                string = StringExtensions.substring(string, 1, string.length() - 2);
            }
            DateTimeOffset[] dateTimeOffsetArray = new DateTimeOffset[]{dateTimeOffset};
            boolean bl2 = z1.m1(string, dateTimeOffsetArray);
            dateTimeOffsetArray[0].CloneTo(dateTimeOffset);
            if (bl2) {
                return dateTimeOffset.Clone();
            }
        }
        return new DateTimeOffset();
    }

    private void setDate(String parameter, DateTimeOffset date) {
        NameValueHeaderValue nameValueHeaderValue = NameValueHeaderValue.find(this._parameters, parameter);
        if (date == null) {
            if (nameValueHeaderValue != null) {
                this._parameters.removeItem(nameValueHeaderValue);
            }
        } else {
            String string = StringExtensions.concat("\"", z1.m1(date.Clone()), "\"");
            if (nameValueHeaderValue != null) {
                nameValueHeaderValue.setValue(string);
            } else {
                this.getParameters().addItem(new NameValueHeaderValue(parameter, string));
            }
        }
    }

    private String getName(String parameter) {
        NameValueHeaderValue nameValueHeaderValue = NameValueHeaderValue.find(this._parameters, parameter);
        if (nameValueHeaderValue != null) {
            String string = null;
            if (StringExtensions.endsWith(parameter, "*", (short)4)) {
                String[] stringArray = new String[]{string};
                boolean bl2 = this.tryDecode5987(nameValueHeaderValue.getValue(), stringArray);
                string = stringArray[0];
                if (bl2) {
                    return string;
                }
                return null;
            }
            String[] stringArray = new String[]{string};
            boolean bl3 = this.tryDecodeMime(nameValueHeaderValue.getValue(), stringArray);
            string = stringArray[0];
            if (bl3) {
                return string;
            }
            return nameValueHeaderValue.getValue();
        }
        return null;
    }

    private void setName(String parameter, String value) {
        NameValueHeaderValue nameValueHeaderValue = NameValueHeaderValue.find(this._parameters, parameter);
        if (StringExtensions.isNullOrEmpty(value)) {
            if (nameValueHeaderValue != null) {
                this._parameters.removeItem(nameValueHeaderValue);
            }
        } else {
            String string = StringExtensions.Empty;
            string = StringExtensions.endsWith(parameter, "*", (short)4) ? z21.m29(value) : this.encodeAndQuoteMime(value);
            if (nameValueHeaderValue != null) {
                nameValueHeaderValue.setValue(string);
            } else {
                this.getParameters().addItem(new NameValueHeaderValue(parameter, string));
            }
        }
    }

    private String encodeAndQuoteMime(String input) {
        String string = input;
        boolean bl2 = false;
        if (this.isQuoted(string)) {
            string = StringExtensions.substring(string, 1, string.length() - 2);
            bl2 = true;
        }
        if (StringExtensions.indexOf(string, "\"", 0, (short)4) >= 0) {
            throw new ArgumentException(StringExtensions.format("Http header invalid value {0}", input));
        }
        if (this.requiresEncoding(string)) {
            bl2 = true;
            string = this.encodeMime(string);
        } else if (!bl2 && z1.m21(string, 0) != string.length()) {
            bl2 = true;
        }
        if (bl2) {
            string = StringExtensions.concat("\"", string, "\"");
        }
        return string;
    }

    private boolean isQuoted(String value) {
        return value.length() > 1 && StringExtensions.startsWith(value, "\"", (short)4) && StringExtensions.endsWith(value, "\"", (short)4);
    }

    private boolean requiresEncoding(String input) {
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            if (c2 <= '\u007f') continue;
            return true;
        }
        return false;
    }

    private String encodeMime(String input) {
        byte[] byArray = Encoding.getUTF8().getBytes(input);
        String string = Convert.toBase64String(byArray);
        return StringExtensions.concat("=?utf-8?B?", string, "?=");
    }

    private boolean tryDecodeMime(String input, String[] output) {
        output[0] = null;
        String string = input;
        if (!this.isQuoted(string) || string.length() < 10) {
            return false;
        }
        String[] stringArray = StringExtensions.split(string, '?');
        if (!(stringArray.length == 5 && "\"=".equals(stringArray[0]) && "=\"".equals(stringArray[4]) && "b".equals(StringExtensions.toLowerInvariant(stringArray[2])))) {
            return false;
        }
        try {
            Encoding encoding = Encoding.getEncoding(stringArray[1]);
            byte[] byArray = Convert.fromBase64String(stringArray[3]);
            output[0] = encoding.getString(byArray, 0, byArray.length);
            return true;
        }
        catch (ArgumentException argumentException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return false;
    }

    private boolean tryDecode5987(String input, String[] output) {
        output[0] = null;
        int n2 = StringExtensions.indexOf(input, '\'');
        if (n2 == -1) {
            return false;
        }
        int n3 = StringExtensions.lastIndexOf(input, '\'');
        if (n2 == n3 || StringExtensions.indexOf(input, '\'', n2 + 1) != n3) {
            return false;
        }
        String string = StringExtensions.substring(input, 0, n2);
        String string2 = StringExtensions.substring(input, n3 + 1, input.length() - (n3 + 1));
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        try {
            Encoding encoding = Encoding.getEncoding(string);
            byte[] byArray = new byte[string2.length()];
            int n4 = 0;
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                if (Uri.isHexEncoding(string2, i2)) {
                    int[] nArray = new int[]{i2};
                    byArray[n4++] = (byte)Uri.hexUnescape(string2, nArray);
                    i2 = nArray[0];
                    --i2;
                    continue;
                }
                if (n4 > 0) {
                    msStringBuilder2.append(encoding.getString(byArray, 0, n4));
                    n4 = 0;
                }
                msStringBuilder2.append(string2.charAt(i2));
            }
            if (n4 > 0) {
                msStringBuilder2.append(encoding.getString(byArray, 0, n4));
            }
        }
        catch (ArgumentException argumentException) {
            return false;
        }
        output[0] = msStringBuilder2.toString();
        return true;
    }
}

