/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.Configuration;
import com.aspose.html.HTMLElement;
import com.aspose.html.Url;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.IDocumentInit;
import com.aspose.html.dom.css.ICSSStyleDeclaration;
import com.aspose.html.dom.css.IDocumentCSS;
import com.aspose.html.dom.css.IViewCSS;
import com.aspose.html.dom.events.Event;
import com.aspose.html.dom.traversal.filters.z7;
import com.aspose.html.dom.traversal.filters.z8;
import com.aspose.html.dom.z1;
import com.aspose.html.dom.z15;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyValuePair;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Directory;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.p182.z2;
import com.aspose.html.internal.p183.z3;
import com.aspose.html.internal.p185.z11;
import com.aspose.html.internal.p185.z23;
import com.aspose.html.internal.p187.z4;
import com.aspose.html.internal.p47.z26;
import com.aspose.html.io.IOutputStorage;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.saving.HTMLSaveOptions;
import com.aspose.html.saving.MHTMLSaveOptions;
import com.aspose.html.saving.MarkdownSaveOptions;
import com.aspose.html.saving.TextSaveOptions;
import com.aspose.html.z1;
import com.aspose.html.z20;
import com.aspose.html.z5;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class HTMLDocument
extends Document
implements IDocumentCSS {
    private String cookie;
    private IViewCSS defaultView;

    public HTMLDocument() {
        this("about:blank");
    }

    public HTMLDocument(z1 z1100) {
        super(HTMLDocument.CreateDocumentInit(z1100));
    }

    public HTMLDocument(Configuration configuration) {
        this("about:blank", configuration);
    }

    public HTMLDocument(RequestMessage requestMessage) {
        this(requestMessage, new Configuration());
    }

    public HTMLDocument(RequestMessage requestMessage, Configuration configuration) {
        this(requestMessage, configuration, 1);
    }

    private HTMLDocument(final RequestMessage requestMessage, Configuration configuration, final byte by2) {
        super(HTMLDocument.CreateDocumentInit(new z1(configuration), new Document.z2(){
            {
                this.m1(com.aspose.html.dom.events.z5.m4194);
                this.m1(requestMessage);
                this.setFlags(by2);
            }
        }));
    }

    public HTMLDocument(Stream stream, Url url) {
        this(stream, url, new Configuration());
    }

    public HTMLDocument(Stream stream, Url url, Configuration configuration) {
        this(com.aspose.html.internal.p137.z1.m1(stream, url), configuration, 3);
    }

    public HTMLDocument(Stream stream, String string) {
        this(stream, string, new Configuration());
    }

    public HTMLDocument(Stream stream, String string, Configuration configuration) {
        this(com.aspose.html.internal.p137.z1.m2(stream, string), configuration, 3);
    }

    public HTMLDocument(Url url) {
        this(url, new Configuration());
    }

    public HTMLDocument(Url url, Configuration configuration) {
        this(com.aspose.html.internal.p137.z1.m8(url), configuration, 3);
    }

    public HTMLDocument(String string) {
        this(new z5(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public HTMLDocument(String string, Configuration configuration) {
        this(new z5(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), configuration);
    }

    public HTMLDocument(String string, Url url) {
        this(string, url, new Configuration());
    }

    public HTMLDocument(String string, Url url, Configuration configuration) {
        this(com.aspose.html.internal.p137.z1.m1(string, url), configuration, 3);
    }

    public HTMLDocument(String string, String string2) {
        this(string, string2, new Configuration());
    }

    public HTMLDocument(String string, String string2, Configuration configuration) {
        this(com.aspose.html.internal.p137.z1.m22(string, string2), configuration, 3);
    }

    private static IDocumentInit CreateDocumentInit(z1 z1100) {
        return HTMLDocument.CreateDocumentInit(z1100, null);
    }

    private static IDocumentInit CreateDocumentInit(z1 z1100, Document.z2 z2100) {
        z15 z1510 = z1100.m5().m11(z1100);
        z1510.m60(1);
        z1510.m1(new com.aspose.html.internal.p283.z2<Document, Event>(){

            public void m1(Document document, Event event) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                if (hTMLDocument.getBody() != null) {
                    hTMLDocument.getBody().dispatchEvent(event);
                } else {
                    hTMLDocument.dispatchEvent(event);
                }
            }

            @Override
            public /* synthetic */ void invoke(Object object, Object object2) {
                this.m1((Document)object, (Event)object2);
            }
        });
        z1510.m1(z2100);
        return z1510;
    }

    public final HTMLCollection getAnchors() {
        return new com.aspose.html.collections.z3(this, new z8("A"));
    }

    public final HTMLCollection getApplets() {
        Dictionary dictionary = new Dictionary(2);
        dictionary.addItem("APPLET", null);
        List<KeyValuePair<String, String>> list = new List<KeyValuePair<String, String>>(2);
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:CAFEEFAC-00"));
        list.addItem(new KeyValuePair<String, String>("classid", "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93"));
        dictionary.addItem("OBJECT", list);
        List<KeyValuePair<String, String>> list2 = new List<KeyValuePair<String, String>>(3);
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-applet"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-bean"));
        list2.addItem(new KeyValuePair<String, String>("type", "application/x-java-vm"));
        dictionary.addItem("EMBED", list2);
        return new com.aspose.html.collections.z3(this, new z8("APPLET", "OBJECT", "EMBED"));
    }

    public final HTMLElement getBody() {
        com.aspose.html.collections.z3 z3100 = new com.aspose.html.collections.z3(this, new z8("BODY", "FRAMESET"));
        return (HTMLElement)com.aspose.html.internal.p111.z1.m2(z3100);
    }

    public final void setBody(HTMLElement hTMLElement) {
        com.aspose.html.internal.p29.z4.m2(hTMLElement, "value");
        HTMLElement hTMLElement2 = this.getBody();
        if (hTMLElement2 != null) {
            this.getDocumentElement().replaceChild(hTMLElement2, hTMLElement);
        } else {
            this.getDocumentElement().appendChild(hTMLElement);
        }
    }

    public final String getCookie() {
        return this.cookie;
    }

    final void setCookie(String string) {
        this.cookie = string;
    }

    public final String getDomain() {
        return this.getLocation().getHost();
    }

    public final HTMLCollection getForms() {
        return new com.aspose.html.collections.z3(this, new z7("FORM"));
    }

    public final HTMLCollection getImages() {
        return this.getElementsByTagName("IMG");
    }

    public final HTMLCollection getLinks() {
        return new com.aspose.html.collections.z3(this, new z8("A", "AREA"));
    }

    public final String getReferrer() {
        return StringExtensions.Empty;
    }

    public final String getTitle() {
        Element element = com.aspose.html.internal.p111.z1.m2(this.getElementsByTagName(z1.z5.m2270.getTagName()));
        if (element != null) {
            return element.getTextContent();
        }
        return StringExtensions.Empty;
    }

    public final void setTitle(String string) {
        if (this.getDocumentElement() != null && StringExtensions.equals(this.getDocumentElement().getNamespaceURI(), z1.z4.m2073)) {
            Element element = com.aspose.html.internal.p111.z1.m2(this.getElementsByTagName(z20.m1(z1.z5.m2270)));
            if (element != null) {
                element.setTextContent(string);
                return;
            }
            Element element2 = com.aspose.html.internal.p111.z1.m2(this.getElementsByTagName(z20.m1(z1.z5.m2177)));
            if (element2 == null) {
                return;
            }
            element = this.createElement(z1.z5.m2270.getTagName());
            element.setTextContent(string);
            element2.appendChild(element);
        }
    }

    @Override
    public final ICSSStyleDeclaration getOverrideStyle(Element element, String string) {
        z1 z1100 = (z1)this.getContext();
        return ((z26)z1100.m3()).getOverrideStyle(element, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTo(IDevice iDevice) {
        com.aspose.html.services.z15 z1510 = this.getContext().getService(com.aspose.html.services.z15.class);
        IDisposable iDisposable = z1510.m1626();
        try {
            z1510.m1(iDisposable, iDevice, this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(IOutputStorage iOutputStorage) {
        this.save(iOutputStorage, 0);
    }

    public final void save(IOutputStorage iOutputStorage, int n2) {
        switch (n2) {
            case 0: {
                this.save(iOutputStorage, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(iOutputStorage, MarkdownSaveOptions.getDefault());
                break;
            }
            case 10: {
                this.save(iOutputStorage, TextSaveOptions.getDefault());
                break;
            }
            case 2: {
                this.save(iOutputStorage, new MHTMLSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, HTMLSaveOptions hTMLSaveOptions) {
        z2 z2100 = new z2((z1)this.getContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), hTMLSaveOptions);
        try {
            com.aspose.html.internal.p182.z1 z1100 = z2100.m1691();
            z1100.m1(iOutputStorage);
            z1100.m3(this.getLocation(), ".htm");
            z2100.m23(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, MHTMLSaveOptions mHTMLSaveOptions) {
        z2 z2100 = new z2((z1)this.getContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), mHTMLSaveOptions);
        try {
            com.aspose.html.internal.p182.z1 z1100 = z2100.m1691();
            z1100.m71(false);
            z1100.m1(new z11());
            z1100.m1(new z3());
            z1100.m1(new com.aspose.html.io.z5(iOutputStorage, z1100.getBoundary()));
            z1100.m3(this.getLocation(), ".mht");
            z2100.m23(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(IOutputStorage iOutputStorage, MarkdownSaveOptions markdownSaveOptions) {
        z2 z2100 = new z2((z1)this.getContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), markdownSaveOptions);
        try {
            com.aspose.html.internal.p182.z1 z1100 = z2100.m1691();
            z1100.m1(new z4(markdownSaveOptions));
            z1100.m1(new z23());
            z1100.m1(iOutputStorage);
            z1100.m3(this.getLocation(), ".md");
            z2100.m8(this.getBody(), this.getLocation().getHref());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(Url url) {
        this.save(url, 0);
    }

    public final void save(Url url, int n2) {
        switch (n2) {
            case 0: {
                this.save(url, new HTMLSaveOptions());
                break;
            }
            case 1: {
                this.save(url, MarkdownSaveOptions.getDefault());
                break;
            }
            case 2: {
                this.save(url, new MHTMLSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, HTMLSaveOptions hTMLSaveOptions) {
        z2 z2100 = new z2((z1)this.getContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), hTMLSaveOptions);
        try {
            com.aspose.html.internal.p182.z1 z1100 = z2100.m1691();
            z1100.m13(url);
            z2100.m23(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, MHTMLSaveOptions mHTMLSaveOptions) {
        z2 z2100 = new z2((z1)this.getContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), mHTMLSaveOptions);
        try {
            com.aspose.html.internal.p182.z1 z1100 = z2100.m1691();
            z1100.m71(false);
            z1100.m1(new z11());
            z1100.m1(new z3());
            z1100.m1(new com.aspose.html.io.z5(z1100.m1684(), z1100.getBoundary()));
            z1100.m11(url);
            z1100.m13(url);
            z2100.m23(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(Url url, MarkdownSaveOptions markdownSaveOptions) {
        z2 z2100 = new z2((z1)this.getContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), markdownSaveOptions);
        try {
            com.aspose.html.internal.p182.z1 z1100 = z2100.m1691();
            z1100.m1(new z4(markdownSaveOptions));
            z1100.m1(new z23());
            z1100.m13(url);
            z2100.m8(this.getBody(), this.getLocation().getHref());
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    public final void save(String string) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public final void save(String string, int n2) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), n2);
    }

    public final void save(String string, HTMLSaveOptions hTMLSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), hTMLSaveOptions);
    }

    public final void save(String string, MHTMLSaveOptions mHTMLSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), mHTMLSaveOptions);
    }

    public final void save(String string, MarkdownSaveOptions markdownSaveOptions) {
        this.save(new Url(string, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), markdownSaveOptions);
    }

    public void save(IOutputStorage iOutputStorage, TextSaveOptions textSaveOptions) {
        this.doSaveText(iOutputStorage, textSaveOptions);
    }

    private void doSave1(Url url, TextSaveOptions textSaveOptions) {
        String string = com.aspose.html.internal.p174.z1.m6(this);
        com.aspose.html.internal.p174.z1.save(url.toString(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveText(IOutputStorage iOutputStorage, TextSaveOptions textSaveOptions) {
        z2 z2100 = new z2((z1)this.getContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), textSaveOptions);
        try {
            z2100.m1691().m283(iOutputStorage.toString());
            String string = com.aspose.html.internal.p174.z1.m6(this);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(URI.create(iOutputStorage.toString())), new OpenOption[0]);){
                string = string.replace("\u00a0", " ");
                bufferedWriter.append(string);
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }
}

