/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLFormElement;
import com.aspose.html.HTMLOptionElement;
import com.aspose.html.IHTMLOptionsCollection;
import com.aspose.html.collections.z2;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.z7;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

public class HTMLSelectElement
extends HTMLElement {
    private HTMLFormElement form;
    private int selectedIndex = -1;

    public final boolean getDisabled() {
        return this.hasAttribute("disabled");
    }

    public final void setDisabled(boolean bl2) {
        this.toggleAttribute("disabled", bl2);
    }

    public final HTMLFormElement getForm() {
        if (this.form == null) {
            this.form = this.getParentOfType(HTMLFormElement.class);
        }
        return this.form;
    }

    public final int getLength() {
        return this.getOptions().getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLength(int n2) {
        if (n2 == this.getOptions().getLength()) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 < this.getOptions().getLength()) {
            IGenericEnumerator iGenericEnumerator = this.getOptions().iterator();
            List<Element> list = new List<Element>();
            while (iGenericEnumerator.hasNext()) {
                if (n2 == 0) {
                    list.addItem((Element)iGenericEnumerator.next());
                    continue;
                }
                --n2;
            }
            IGenericEnumerator iGenericEnumerator2 = list.iterator();
            try {
                while (iGenericEnumerator2.hasNext()) {
                    Node node = (Node)iGenericEnumerator2.next();
                    this.removeChild(node);
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator2, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator2).dispose();
                }
            }
            return;
        }
        for (int i2 = n2 - this.getOptions().getLength(); i2 != 0; --i2) {
            this.appendChild(this.getOwnerDocument().createElement("OPTION"));
        }
    }

    public final boolean getMultiple() {
        return this.hasAttribute("multiple");
    }

    public final void setMultiple(boolean bl2) {
        this.toggleAttribute("multiple", bl2);
    }

    public final String getName() {
        return this.getAttributeOrDefault("name", StringExtensions.Empty);
    }

    public final void setName(String string) {
        this.setAttribute("name", string);
    }

    public final IHTMLOptionsCollection getOptions() {
        return new z2((Node)this, "OPTION");
    }

    public final int getSelectedIndex() {
        return this.selectedIndex;
    }

    public final void setSelectedIndex(int n2) {
        if (n2 < 0 || n2 > this.getLength() - 1) {
            this.selectedIndex = -1;
        }
        this.selectedIndex = n2;
    }

    public final int getSize() {
        return this.getAttributeOrDefault(Integer.class, "size", 0);
    }

    public final void setSize(int n2) {
        this.setAttribute("size", n2);
    }

    public final int getTabIndex() {
        return this.getAttributeOrDefault(Integer.class, "tabindex", 0);
    }

    public final void setTabIndex(int n2) {
        this.setAttribute("tabindex", n2);
    }

    public final String getType() {
        return this.getMultiple() ? "select-multiple" : "select-one";
    }

    public final String getValue() {
        IGenericEnumerator iGenericEnumerator = this.getOptions().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                if (!((HTMLOptionElement)iGenericEnumerator.next()).getSelected()) continue;
                String string = ((HTMLOptionElement)iGenericEnumerator.next()).getTextContent();
                return string;
            }
        }
        finally {
            if (iGenericEnumerator != null) {
                iGenericEnumerator.dispose();
            }
        }
        return StringExtensions.Empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setValue(String string) {
        IGenericEnumerator iGenericEnumerator = this.getOptions().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                ((HTMLOptionElement)iGenericEnumerator.next()).setSelected(false);
            }
            iGenericEnumerator.reset();
            int n2 = 0;
            int n3 = -1;
            while (iGenericEnumerator.hasNext()) {
                if (StringExtensions.equals(((Element)iGenericEnumerator.next()).getTextContent(), string)) {
                    n3 = n2;
                    ((HTMLOptionElement)iGenericEnumerator.next()).setSelected(true);
                    break;
                }
                ++n2;
            }
            this.selectedIndex = n3;
        }
        finally {
            if (iGenericEnumerator != null) {
                iGenericEnumerator.dispose();
            }
        }
    }

    public HTMLSelectElement(z7 z710, Document document) {
        super(z710, document);
    }

    public final void add(HTMLElement hTMLElement, HTMLElement hTMLElement2) {
    }

    public final void blur() {
    }

    public final void focus() {
    }

    public final void remove(int n2) {
    }
}

