/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLTableCaptionElement;
import com.aspose.html.HTMLTableSectionElement;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.collections.z3;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.z7;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.z10;

public class HTMLTableElement
extends HTMLElement {
    private HTMLTableSectionElement body;

    public final String getAlign() {
        return this.getAttributeOrDefault("align", StringExtensions.Empty);
    }

    public final void setAlign(String string) {
        this.setAttribute("align", string);
    }

    public final String getBgColor() {
        return this.getAttributeOrDefault("bgcolor", StringExtensions.Empty);
    }

    public final void setBgColor(String string) {
        this.setAttribute("bgcolor", string);
    }

    final HTMLTableSectionElement getBody() {
        HTMLCollection hTMLCollection;
        if (this.body == null && (hTMLCollection = this.getTBodies()).getLength() != 0) {
            this.body = Operators.as(hTMLCollection.get_Item(hTMLCollection.getLength() - 1), HTMLTableSectionElement.class);
        }
        return this.body;
    }

    public final String getBorder() {
        return this.getAttributeOrDefault("border", StringExtensions.Empty);
    }

    public final void setBorder(String string) {
        this.setAttribute("border", string);
    }

    public final HTMLTableCaptionElement getCaption() {
        return this.getChildOfType(HTMLTableCaptionElement.class);
    }

    public final String getCellPadding() {
        return this.getAttributeOrDefault("cellpadding", StringExtensions.Empty);
    }

    public final void setCellPadding(String string) {
        this.setAttribute("cellpadding", string);
    }

    public final String getCellSpacing() {
        return this.getAttributeOrDefault("cellspacing", StringExtensions.Empty);
    }

    public final void setCellSpacing(String string) {
        this.setAttribute("cellspacing", string);
    }

    public final String getFrame() {
        return this.getAttributeOrDefault("frame", StringExtensions.Empty);
    }

    public final void setFrame(String string) {
        this.setAttribute("frame", string);
    }

    public final HTMLCollection getRows() {
        return new z3(this, new com.aspose.html.dom.traversal.filters.z7("TR"));
    }

    public final String getRules() {
        return this.getAttributeOrDefault("rules", "none");
    }

    public final void setRules(String string) {
        this.setAttribute("rules", string);
    }

    public final String getSummary() {
        return this.getAttributeOrDefault("summary", StringExtensions.Empty);
    }

    public final void setSummary(String string) {
        this.setAttribute("summary", string);
    }

    public final HTMLCollection getTBodies() {
        return new z3(this, new com.aspose.html.dom.traversal.filters.z7("TBODY"));
    }

    public final HTMLTableSectionElement getTFoot() {
        return this.getTableSection("TFOOT");
    }

    public final HTMLTableSectionElement getTHead() {
        return this.getTableSection("THEAD");
    }

    public final String getWidth() {
        return this.getAttributeOrDefault("width", StringExtensions.Empty);
    }

    public final void setWidth(String string) {
        this.setAttribute("width", string);
    }

    public HTMLTableElement(z7 z710, Document document) {
        super(z710, document);
    }

    public final Element createCaption() {
        if (this.getCaption() == null) {
            this.insertBefore(this.getOwnerDocument().createElement("CAPTION"), this.getFirstElementChild());
        }
        return this.getCaption();
    }

    public final Element createTFoot() {
        if (this.getTFoot() == null) {
            this.appendChild(this.getOwnerDocument().createElement("TFOOT"));
        }
        return this.getTFoot();
    }

    public final Element createTHead() {
        HTMLElement hTMLElement = Operators.as(this.getTHead(), HTMLElement.class);
        if (hTMLElement != null) {
            return hTMLElement;
        }
        HTMLElement hTMLElement2 = Operators.as(this.getOwnerDocument().createElement("THEAD"), HTMLElement.class);
        HTMLElement hTMLElement3 = Operators.as(this.getCaption(), HTMLElement.class);
        if (hTMLElement3 != null) {
            return Operators.as(this.insertBefore(hTMLElement2, hTMLElement3.getNextSibling()), HTMLElement.class);
        }
        return Operators.as(this.insertBefore(hTMLElement2, Operators.as(this.getFirstElementChild(), Element.class)), HTMLElement.class);
    }

    public final void deleteCaption() {
        this.removeSectionElement(Operators.as(this.getCaption(), HTMLElement.class));
    }

    public final void deleteRow(int n2) {
        HTMLCollection hTMLCollection = this.getRows();
        if (n2 < -1 || n2 >= hTMLCollection.getLength()) {
            z10.m30();
        }
        HTMLElement hTMLElement = Operators.as(n2 != -1 ? hTMLCollection.get_Item(n2) : hTMLCollection.get_Item(hTMLCollection.getLength() - 1), HTMLElement.class);
        Element element = hTMLElement.getParentElement();
        element.removeChild(hTMLElement);
    }

    public final void deleteTFoot() {
        this.removeSectionElement(Operators.as(this.getTFoot(), HTMLElement.class));
    }

    public final void deleteTHead() {
        this.removeSectionElement(Operators.as(this.getTHead(), HTMLElement.class));
    }

    private HTMLTableSectionElement getTableSection(String string) {
        z3 z3100 = new z3(this, new com.aspose.html.dom.traversal.filters.z7(string));
        if (z3100.getLength() > 0) {
            return Operators.as(z3100.get_Item(0), HTMLTableSectionElement.class);
        }
        return null;
    }

    public final Node insertRow(int n2) {
        HTMLElement hTMLElement;
        Element element;
        HTMLCollection hTMLCollection = this.getRows();
        if (n2 < -1 || n2 > hTMLCollection.getLength()) {
            z10.m30();
        }
        HTMLElement hTMLElement2 = hTMLCollection.getLength() > n2 && n2 != -1 ? Operators.as(hTMLCollection.get_Item(n2), HTMLElement.class) : null;
        HTMLElement hTMLElement3 = hTMLElement2 != null ? (HTMLElement)hTMLElement2.getParentOfType(HTMLTableSectionElement.class) : null;
        HTMLCollection hTMLCollection2 = this.getTBodies();
        if (hTMLCollection2.getLength() == 0) {
            element = Operators.as(this.getTHead(), HTMLElement.class);
            if (element == null) {
                element = Operators.as(this.getCaption(), HTMLElement.class);
            }
            hTMLElement = Operators.as(this.getOwnerDocument().createElement("TBODY"), HTMLElement.class);
            hTMLElement = element != null ? Operators.as(this.insertBefore(hTMLElement, element.getNextSibling()), HTMLElement.class) : Operators.as(this.insertBefore(hTMLElement, Operators.as(this.getFirstElementChild(), Element.class)), HTMLElement.class);
        } else {
            element = hTMLElement3;
            if (element == null) {
                element = Operators.as(hTMLCollection2.get_Item(hTMLCollection2.getLength() - 1), HTMLElement.class);
            }
            hTMLElement = element;
        }
        element = this.getOwnerDocument().createElement("TR");
        if (hTMLElement3 == hTMLElement && n2 != -1) {
            return Operators.as(hTMLElement.insertBefore(Operators.as(element, Element.class), hTMLElement2), HTMLElement.class);
        }
        return Operators.as(hTMLElement.appendChild(Operators.as(element, Element.class)), HTMLElement.class);
    }

    private void removeSectionElement(HTMLElement hTMLElement) {
        if (hTMLElement != null) {
            this.removeChild(hTMLElement);
        }
    }
}

