/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom;

import com.aspose.html.IDocumentFragmentElement;
import com.aspose.html.collections.DOMTokenList;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.collections.NamedNodeMap;
import com.aspose.html.collections.NodeList;
import com.aspose.html.dom.Attr;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.DocumentFragment;
import com.aspose.html.dom.IChildNode;
import com.aspose.html.dom.IElementInit;
import com.aspose.html.dom.IParentNode;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.ShadowRoot;
import com.aspose.html.dom.Text;
import com.aspose.html.dom.TypeInfo;
import com.aspose.html.dom.traversal.ITreeWalker;
import com.aspose.html.dom.traversal.filters.z5;
import com.aspose.html.dom.traversal.filters.z6;
import com.aspose.html.dom.traversal.filters.z7;
import com.aspose.html.dom.traversal.filters.z9;
import com.aspose.html.dom.z1;
import com.aspose.html.dom.z16;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p104.z3;
import com.aspose.html.services.z17;
import com.aspose.html.services.z2;
import com.aspose.html.z10;
import com.aspose.html.z20;
import com.aspose.html.z22;

public class Element
extends Node
implements IChildNode,
IParentNode {
    private static final List<z20> ShadowSupportedElements = new List();
    public final z20 _Tag;
    private NamedNodeMap attributes;
    private final DOMTokenList domTokenList;
    private String localName;
    private String namespaceURI;
    private String prefix;
    private ShadowRoot shadowRoot;
    private Dictionary<String, Object> store = new Dictionary();
    private final com.aspose.html.internal.p31.z5 styleContainer;
    private final String tagName;

    @Override
    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    @Override
    public final int getChildElementCount() {
        return this.getChildren().getLength();
    }

    @Override
    public final HTMLCollection getChildren() {
        return new com.aspose.html.collections.z3(this, new com.aspose.html.dom.traversal.filters.z1(this));
    }

    public final DOMTokenList getClassList() {
        return this.domTokenList;
    }

    public final String getClassName() {
        String string = this.getAttribute("class");
        if (string == null) {
            string = StringExtensions.Empty;
        }
        return string;
    }

    public final void setClassName(String string) {
        this.setAttribute("class", string);
    }

    @Override
    public final Element getFirstElementChild() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 1L, null);
        try {
            Element element = Operators.as(iTreeWalker.firstChild(), Element.class);
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    public final String getId() {
        String string = this.getAttribute("id");
        if (string == null) {
            string = StringExtensions.Empty;
        }
        return string;
    }

    public final void setId(String string) {
        this.setAttribute("id", string);
    }

    public final String getInnerHTML() {
        return this.nodeDocument.getContext().getService(z17.class).m1758().m1((Node)this, new z9(this), true);
    }

    public final void setInnerHTML(String string) {
        Element element = this;
        DocumentFragment documentFragment = ((com.aspose.html.z1)this.nodeDocument.getContext()).m1(element, string);
        Node node = this;
        IDocumentFragmentElement iDocumentFragmentElement = Operators.as(this, IDocumentFragmentElement.class);
        if (iDocumentFragmentElement != null) {
            node = iDocumentFragmentElement.getContent();
        }
        Element.replaceAll(documentFragment, node);
    }

    @Override
    public final Element getLastElementChild() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 1L, null);
        try {
            Element element = Operators.as(iTreeWalker.lastChild(), Element.class);
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public final Element getNextElementSibling() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    public final String getOuterHTML() {
        return this.nodeDocument.getContext().getService(z17.class).m1758().m1(this, true);
    }

    public final void setOuterHTML(String string) {
        Node node = this.getParentNode();
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 9) {
            z10.m39();
        }
        if (node.getNodeType() == 11) {
            node = this.nodeDocument.createElementNS(z1.z4.m2073, "body");
        }
        DocumentFragment documentFragment = ((com.aspose.html.z1)this.nodeDocument.getContext()).m1((Element)node, string);
        this.getParentNode().replaceChild(documentFragment, this);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public final Element getPreviousElementSibling() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public final String getQualifiedName() {
        return this.prefix == null ? this.localName : StringExtensions.concat(this.prefix, ":", this.localName);
    }

    public final TypeInfo getSchemaTypeInfo() {
        return new TypeInfo(this);
    }

    public final ShadowRoot getShadowRoot() {
        if (this.shadowRoot == null || this.shadowRoot.getMode() == 1) {
            return null;
        }
        return this.shadowRoot;
    }

    public final String getTagName() {
        return this.tagName;
    }

    @Override
    public String getTextContent() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 4L, null);
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        while (iTreeWalker.nextNode() != null) {
            msStringBuilder2.append(iTreeWalker.getCurrentNode());
        }
        return msStringBuilder2.toString();
    }

    @Override
    public void setTextContent(String string) {
        Text text = null;
        if (!StringExtensions.isNullOrEmpty(string)) {
            text = new Text(string, this.nodeDocument);
        }
        Element.replaceAll(text, this);
    }

    public Element(IElementInit iElementInit) {
        super(iElementInit.getDocument());
        z16 z1610 = Operators.as(iElementInit, z16.class);
        if (z1610 == null) {
            throw new z22("Illegal constructor");
        }
        com.aspose.html.dom.z7 z710 = z1610.m412();
        this.localName = z710.getLocalName();
        this.namespaceURI = z710.getNamespaceURI();
        this.prefix = z710.getPrefix();
        this.tagName = z710.getTagName();
        this._Tag = z20.m6(z710.getLocalName());
        this.attributes = new NamedNodeMap(this);
        this.styleContainer = this.nodeDocument.getContext().getService(z2.class).m51(this);
        this.domTokenList = new DOMTokenList(this, "class");
    }

    public final ShadowRoot attachShadow(int n2) {
        if (!StringExtensions.equals(this.getNamespaceURI(), z1.z4.m2073)) {
            z10.m41();
        }
        if (!ShadowSupportedElements.containsItem(this._Tag)) {
            z10.m41();
        }
        if (this.shadowRoot != null) {
            z10.m35();
        }
        this.shadowRoot = new ShadowRoot(this.nodeDocument, n2, this);
        return this.shadowRoot;
    }

    public final boolean compareTo(z20 z2010) {
        if (ObjectExtensions.referenceEquals(null, z2010)) {
            return false;
        }
        return ObjectExtensions.referenceEquals(this._Tag, z2010);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(boolean bl2) {
        super.dispose(bl2);
        if (bl2) {
            this.attributes.dispose();
            IGenericEnumerator iGenericEnumerator = ((Dictionary.ValueCollection)this.store.getValues()).iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    Object e2 = iGenericEnumerator.next();
                    IDisposable iDisposable = Operators.as(e2, IDisposable.class);
                    if (iDisposable == null) continue;
                    iDisposable.dispose();
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
            this.store.clear();
        }
    }

    public final String getAttribute(String string) {
        Attr attr = this.attributes.getNamedItem(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public final String getAttributeNS(String string, String string2) {
        Attr attr = NamedNodeMap.getAttribute(string, string2, this);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Attr getAttributeNode(String string) {
        short s2 = 4;
        if (StringExtensions.equals(this.getNamespaceURI(), z1.z4.m2073) && Document.z1.m14(this.nodeDocument) == 1) {
            s2 = 5;
        }
        IEnumerator iEnumerator = this.getAttributes().iterator();
        try {
            while (iEnumerator.hasNext()) {
                Attr attr = (Attr)iEnumerator.next();
                if (!StringExtensions.equals(string, attr.getName(), s2)) continue;
                Attr attr2 = attr;
                return attr2;
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
        return null;
    }

    public final Attr getAttributeNodeNS(String string, String string2) {
        return NamedNodeMap.getAttribute(string, string2, this);
    }

    public final Object getData(String string) {
        if (this.store.containsKey(string)) {
            return this.store.get_Item(string);
        }
        return null;
    }

    public final HTMLCollection getElementsByClassName(String string) {
        return new com.aspose.html.collections.z3(this, new z5(string));
    }

    public final HTMLCollection getElementsByTagName(String string) {
        return new com.aspose.html.collections.z3(this, new z7(string));
    }

    public final HTMLCollection getElementsByTagNameNS(String string, String string2) {
        return new com.aspose.html.collections.z3(this, new z6(string, string2, this.nodeDocument.getNameTable().add("*")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasAttribute(String string) {
        short s2 = 4;
        if (StringExtensions.equals(this.getNamespaceURI(), z1.z4.m2073) && Document.z1.m14(this.nodeDocument) == 1) {
            s2 = 5;
        }
        IEnumerator iEnumerator = this.getAttributes().iterator();
        try {
            while (iEnumerator.hasNext()) {
                Attr attr = (Attr)iEnumerator.next();
                if (!StringExtensions.equals(string, attr.getName(), s2)) continue;
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
        return false;
    }

    public final boolean hasAttributeNS(String string, String string2) {
        return NamedNodeMap.getAttribute(string, string2, this) != null;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes.getLength() > 0;
    }

    @Override
    public final Element querySelector(String string) {
        return ((com.aspose.html.z1)this.nodeDocument.getContext()).m3().m1(string, this);
    }

    @Override
    public final NodeList querySelectorAll(String string) {
        return ((com.aspose.html.z1)this.nodeDocument.getContext()).m3().m2(string, this);
    }

    @Override
    public final void remove() {
        if (this.getParentNode() != null) {
            this.getParentNode().removeChild(this);
        }
    }

    public final void removeAttribute(String string) {
        NamedNodeMap.removeAttribute(string, this);
    }

    public final void removeAttributeNS(String string, String string2) {
        NamedNodeMap.removeAttribute(string, string2, this);
    }

    public final Attr removeAttributeNode(Attr attr) {
        if (!NamedNodeMap.contains(this, attr)) {
            z10.m40();
        }
        NamedNodeMap.remove(attr, this);
        return attr;
    }

    public final void setAttribute(String string, String string2) {
        Attr attr;
        if (!z3.m166(string)) {
            z10.m33();
        }
        if (StringExtensions.equals(z1.z4.m2073, this.getNamespaceURI())) {
            string = StringExtensions.toLowerInvariant(string);
        }
        if ((attr = this.attributes.getNamedItem(string)) == null) {
            attr = new Attr(com.aspose.html.dom.z7.m1(string, this.prefix, null, this.nodeDocument), this.nodeDocument);
            Attr.setValue(this, attr, string2);
            NamedNodeMap.append(attr, this);
            return;
        }
        Attr.change(attr, this, string2);
    }

    public final void setAttributeNS(String string, String string2, String string3) {
        String string4 = null;
        String string5 = null;
        String[] stringArray = new String[]{string};
        String[] stringArray2 = new String[]{string5};
        String[] stringArray3 = new String[]{string4};
        com.aspose.html.dom.z7.m1(string2, stringArray, stringArray2, stringArray3, this.nodeDocument);
        string = stringArray[0];
        string5 = stringArray2[0];
        string4 = stringArray3[0];
        NamedNodeMap.setAttributeValue(this, string4, string3, string5, string);
    }

    public final Attr setAttributeNode(Attr attr) {
        return NamedNodeMap.setAttribute(attr, this);
    }

    public final Attr setAttributeNodeNS(Attr attr) {
        return NamedNodeMap.setAttribute(attr, this);
    }

    public final void setData(String string, Object object) {
        this.store.set_Item(string, object);
    }

    public final void setIdAttribute(String string, boolean bl2) {
        Attr attr = this.getAttributeNode(string);
        if (attr != null) {
            attr.setId(bl2);
        }
    }

    public final void setIdAttributeNS(String string, String string2, boolean bl2) {
        Attr attr = this.getAttributeNodeNS(string, string2);
        if (attr != null) {
            attr.setId(bl2);
        }
    }

    public final void setIdAttributeNode(Attr attr, boolean bl2) {
        Attr attr2 = this.getAttributeNode(attr.getName());
        if (attr2 != null) {
            attr2.setId(bl2);
        }
    }

    static {
        ShadowSupportedElements.addItem(z1.z5.m2094);
        ShadowSupportedElements.addItem(z1.z5.m2095);
        ShadowSupportedElements.addItem(z1.z5.m2104);
        ShadowSupportedElements.addItem(z1.z5.m2105);
        ShadowSupportedElements.addItem(z1.z5.m2129);
        ShadowSupportedElements.addItem(z1.z5.m2165);
        ShadowSupportedElements.addItem(z1.z5.m2171);
        ShadowSupportedElements.addItem(z1.z5.m2172);
        ShadowSupportedElements.addItem(z1.z5.m2173);
        ShadowSupportedElements.addItem(z1.z5.m2174);
        ShadowSupportedElements.addItem(z1.z5.m2175);
        ShadowSupportedElements.addItem(z1.z5.m2176);
        ShadowSupportedElements.addItem(z1.z5.m2178);
        ShadowSupportedElements.addItem(z1.z5.m2198);
        ShadowSupportedElements.addItem(z1.z5.m2211);
        ShadowSupportedElements.addItem(z1.z5.m2221);
        ShadowSupportedElements.addItem(z1.z5.m2243);
        ShadowSupportedElements.addItem(z1.z5.m2248);
    }

    public static class z1 {
        public static com.aspose.html.internal.p31.z5 m15(Element element) {
            return element.styleContainer;
        }

        public static z20 m16(Element element) {
            return element._Tag;
        }
    }
}

