/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Collections.IList;

public abstract class CollectionBase
implements ICollection,
IEnumerable,
IList {
    private ArrayList a;

    @Override
    public int size() {
        return this.getInnerList().size();
    }

    @Override
    public IEnumerator iterator() {
        return this.getInnerList().iterator();
    }

    @Override
    public void clear() {
        this.onClear();
        this.getInnerList().clear();
        this.onClearComplete();
    }

    @Override
    public void removeAt(int n2) {
        Object object = this.getInnerList().get_Item(n2);
        this.onValidate(object);
        this.onRemove(n2, object);
        this.getInnerList().removeAt(n2);
        this.onRemoveComplete(n2, object);
    }

    protected CollectionBase() {
    }

    protected CollectionBase(int n2) {
        this.a = new ArrayList(n2);
    }

    public int getCapacity() {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        return this.a.getCapacity();
    }

    public void setCapacity(int n2) {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        this.a.setCapacity(n2);
    }

    protected ArrayList getInnerList() {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        return this.a;
    }

    protected IList getList() {
        return this;
    }

    protected void onClear() {
    }

    protected void onClearComplete() {
    }

    protected void onInsert(int n2, Object object) {
    }

    protected void onInsertComplete(int n2, Object object) {
    }

    protected void onRemove(int n2, Object object) {
    }

    protected void onRemoveComplete(int n2, Object object) {
    }

    protected void onSet(int n2, Object object, Object object2) {
    }

    protected void onSetComplete(int n2, Object object, Object object2) {
    }

    protected void onValidate(Object object) {
        if (null == object) {
            throw new ArgumentNullException("CollectionBase.OnValidate: Invalid parameter value passed to method: null");
        }
    }

    @Override
    public void copyTo(Array array, int n2) {
        this.getInnerList().copyTo(array, n2);
    }

    @Override
    public Object getSyncRoot() {
        return this.getInnerList().getSyncRoot();
    }

    @Override
    public boolean isSynchronized() {
        return this.getInnerList().isSynchronized();
    }

    @Override
    public int addItem(Object object) {
        this.onValidate(object);
        int n2 = this.getInnerList().size();
        this.onInsert(n2, object);
        this.getInnerList().addItem(object);
        try {
            this.onInsertComplete(n2, object);
        }
        catch (RuntimeException runtimeException) {
            this.getInnerList().removeAt(n2);
            throw runtimeException;
        }
        return n2;
    }

    @Override
    public boolean contains(Object object) {
        return this.getInnerList().contains(object);
    }

    @Override
    public int indexOf(Object object) {
        return this.getInnerList().indexOf(object);
    }

    @Override
    public void insertItem(int n2, Object object) {
        this.onValidate(object);
        this.onInsert(n2, object);
        this.getInnerList().insertItem(n2, object);
        try {
            this.onInsertComplete(n2, object);
        }
        catch (RuntimeException runtimeException) {
            this.getInnerList().removeAt(n2);
            throw runtimeException;
        }
    }

    @Override
    public void removeItem(Object object) {
        this.onValidate(object);
        int n2 = this.getInnerList().indexOf(object);
        if (n2 == -1) {
            throw new ArgumentException("The element cannot be found.", "value");
        }
        this.onRemove(n2, object);
        this.getInnerList().removeItem(object);
        this.onRemoveComplete(n2, object);
    }

    @Override
    public boolean isFixedSize() {
        return this.getInnerList().isFixedSize();
    }

    @Override
    public boolean isReadOnly() {
        return this.getInnerList().isReadOnly();
    }

    @Override
    public Object get_Item(int n2) {
        return this.getInnerList().get_Item(n2);
    }

    @Override
    public void set_Item(int n2, Object object) {
        if (n2 < 0 || n2 >= this.getInnerList().size()) {
            throw new ArgumentOutOfRangeException("index");
        }
        this.onValidate(object);
        Object object2 = this.getInnerList().get_Item(n2);
        this.onSet(n2, object2, object);
        this.getInnerList().set_Item(n2, object);
        try {
            this.onSetComplete(n2, object2, object);
        }
        catch (RuntimeException runtimeException) {
            this.getInnerList().set_Item(n2, object2);
            throw runtimeException;
        }
    }
}

