/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Text;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Drawing.Text.FontCollection;
import com.aspose.html.internal.ms.System.IO.FileNotFoundException;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.System.StringExtensions;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class PrivateFontCollection
extends FontCollection {
    public void addFontFile(String string) throws FileNotFoundException {
        FileStream fileStream = new FileStream(string, 3, 1);
        this.addMemoryFont(fileStream);
    }

    public void addMemoryFont(Stream stream) {
        if (stream == null) {
            throw new ArgumentException("Value of parameter is incorrect");
        }
        byte[] byArray = new byte[(int)stream.getLength()];
        stream.read(byArray, 0, byArray.length);
        this.addMemoryFont(byArray);
    }

    public void addMemoryFont(IntPtr intPtr, int n2) {
        if (intPtr == null) {
            throw new ArgumentException("Value of parameter is incorrect");
        }
        this.addMemoryFont((byte[])intPtr.toPointer().getData(), n2);
    }

    public void addMemoryFont(IntPtr intPtr) {
        if (intPtr == null) {
            throw new ArgumentException("Value of parameter is incorrect");
        }
        this.addMemoryFont((byte[])intPtr.toPointer().getData());
    }

    public void addMemoryFont(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentException("Value of parameter is incorrect");
        }
        this.addMemoryFont(byArray, byArray.length);
    }

    public void addMemoryFont(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentException("Value of parameter is incorrect");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n2);
        byte[] byArray2 = new byte[byteArrayInputStream.available()];
        byteArrayInputStream.read(byArray2, 0, byArray2.length);
        Font font = this.a(byArray2);
        if (!this.contains(font.getFamily())) {
            this.addFont(font);
        }
    }

    private Font a(byte[] byArray) {
        String string = Path.getTempPath();
        String string2 = StringExtensions.concat("aspose_", Thread.currentThread().getId(), "_", System.currentTimeMillis(), ".tmp");
        File file = new File(string + string2);
        Font font = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray, 0, byArray.length);
            font = Font.createFont(0, file);
        }
        catch (Exception exception) {
            throw new FileNotFoundException("Unable to create java.awt.Font.TRUETYPE_FONT", exception);
        }
        finally {
            if (file != null) {
                file.deleteOnExit();
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return font;
    }

    @Override
    public void dispose() {
        this._fonts.clear();
        this._fonts = null;
    }
}

