/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.Text.Encoding;

public class BinaryWriter
implements IDisposable {
    public static BinaryWriter Null = new BinaryWriter();
    protected Stream OutStream;
    private Encoding a;
    private byte[] b;
    private byte[] c;
    private int d;
    private boolean e;
    private static final boolean f = false;

    protected BinaryWriter() {
        this(Stream.Null, Encoding.getUTF8());
    }

    public BinaryWriter(Stream stream) {
        this(stream, Encoding.getUTF8());
    }

    public BinaryWriter(Stream stream, Encoding encoding) {
        if (stream == null) {
            throw new ArgumentNullException("output");
        }
        if (encoding == null) {
            throw new ArgumentNullException("encoding");
        }
        if (!stream.canWrite()) {
            throw new ArgumentException("Stream does not support writing or already closed.");
        }
        this.OutStream = stream;
        this.a = encoding;
        this.b = new byte[16];
    }

    public Stream getBaseStream() {
        this.flush();
        return this.OutStream;
    }

    public void close() {
        this.dispose(true);
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    protected void dispose(boolean bl2) {
        if (bl2 && this.OutStream != null) {
            this.OutStream.close();
        }
        this.b = null;
        this.a = null;
        this.e = true;
    }

    public void flush() {
        this.OutStream.flush();
    }

    public long seek(int n2, int n3) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot seek a closed BinaryWriter");
        }
        return this.OutStream.seek(n2, n3);
    }

    public void write(boolean bl2) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        this.b[0] = (byte)(bl2 ? 1 : 0);
        this.OutStream.write(this.b, 0, 1);
    }

    public void writeByte(byte by2) {
        this.b[0] = by2;
        this.OutStream.write(this.b, 0, 1);
    }

    public void writeBytes(byte[] byArray, int n2, int n3) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        this.OutStream.write(byArray, n2, n3);
    }

    public void writeBytes(byte[] byArray) {
        this.OutStream.write(byArray, 0, byArray.length);
    }

    public void write(char c2) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        char[] cArray = new char[]{c2};
        byte[] byArray = this.a.getBytes(cArray, 0, 1);
        this.OutStream.write(byArray, 0, byArray.length);
    }

    public void writeChars(char[] cArray) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        if (cArray == null) {
            throw new ArgumentNullException("chars");
        }
        byte[] byArray = this.a.getBytes(cArray, 0, cArray.length);
        this.OutStream.write(byArray, 0, byArray.length);
    }

    public void writeChars(char[] cArray, int n2, int n3) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        if (cArray == null) {
            throw new ArgumentNullException("chars");
        }
        byte[] byArray = this.a.getBytes(cArray, n2, n3);
        this.OutStream.write(byArray, 0, byArray.length);
    }

    public void writeInt16(short s2) {
        this.b[0] = (byte)s2;
        this.b[1] = (byte)(s2 >> 8);
        this.OutStream.write(this.b, 0, 2);
    }

    public void writeUInt16(int n2) {
        this.writeInt16((short)n2);
    }

    public void writeInt32(int n2) {
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        this.b[0] = (byte)n2;
        this.b[1] = (byte)(n2 >> 8);
        this.b[2] = (byte)(n2 >> 16);
        this.b[3] = (byte)(n2 >> 24);
        this.OutStream.write(this.b, 0, 4);
    }

    public void writeUInt32(long l2) {
        this.writeInt32((int)l2);
    }

    public void writeInt64(long l2) {
        this.writeUInt32(l2 & 0xFFFFFFFFL);
        this.writeUInt32(l2 >> 32);
    }

    public void writeUInt64(long l2) {
        this.writeUInt32(l2 & 0xFFFFFFFFL);
        this.writeUInt32(l2 >>> 32);
    }

    public void writeFloat(float f2) {
        this.writeInt32(Float.floatToIntBits(f2));
    }

    public void writeDouble(double d2) {
        this.writeInt64(Double.doubleToLongBits(d2));
    }

    public void writeDecimal(Decimal decimal) {
        int[] nArray = Decimal.getBits(decimal);
        byte[] byArray = new byte[]{(byte)nArray[0], (byte)(nArray[0] >> 8), (byte)(nArray[0] >> 16), (byte)(nArray[0] >> 24), (byte)nArray[1], (byte)(nArray[1] >> 8), (byte)(nArray[1] >> 16), (byte)(nArray[1] >> 24), (byte)nArray[2], (byte)(nArray[2] >> 8), (byte)(nArray[2] >> 16), (byte)(nArray[2] >> 24), (byte)nArray[3], (byte)(nArray[3] >> 8), (byte)(nArray[3] >> 16), (byte)(nArray[3] >> 24)};
        this.OutStream.write(byArray, 0, 16);
    }

    public void write(String string) {
        int n2;
        if (this.e) {
            throw new ObjectDisposedException("BinaryWriter", "Cannot write to a closed BinaryWriter");
        }
        int n3 = this.a.getByteCount(string);
        this.write7BitEncodedInt(n3);
        if (this.c == null) {
            this.c = new byte[512];
            this.d = 512 / this.a.getMaxByteCount(1);
        }
        int n4 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            n2 = i2 > this.d ? this.d : i2;
            int n5 = this.a.getBytes(string, n4, n2, this.c, 0);
            this.OutStream.write(this.c, 0, n5);
            n4 += n2;
        }
    }

    protected void write7BitEncodedInt(int n2) {
        int n3;
        do {
            n3 = n2 >> 7 & 0x1FFFFFF;
            byte by2 = (byte)(n2 & 0x7F);
            if (n3 != 0) {
                by2 = (byte)(by2 & 0xFF | 0x80);
            }
            this.writeByte(by2);
        } while ((n2 = n3) != 0);
    }
}

