/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.IO.IOException;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;

public final class BufferedStream
extends Stream {
    private Stream a;
    private byte[] b;
    private int c;
    private int d;
    private boolean e;
    private boolean f = false;

    public BufferedStream(Stream stream) {
        this(stream, 4096);
    }

    public BufferedStream(Stream stream, int n2) {
        if (stream == null) {
            throw new ArgumentNullException("stream");
        }
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "<= 0");
        }
        if (!stream.canRead() && !stream.canWrite()) {
            throw new ObjectDisposedException("Cannot access a closed Stream.");
        }
        this.a = stream;
        this.b = new byte[n2];
    }

    @Override
    public boolean canRead() {
        return this.a.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.a.canWrite();
    }

    @Override
    public boolean canSeek() {
        return this.a.canSeek();
    }

    @Override
    public long getLength() {
        this.flush();
        return this.a.getLength();
    }

    @Override
    public long getPosition() {
        this.a();
        return this.a.getPosition() - (long)this.d + (long)this.c;
    }

    @Override
    public void setPosition(long l2) {
        if (l2 < this.getPosition() && this.getPosition() - l2 <= (long)this.c && this.e) {
            this.c -= (int)(this.getPosition() - l2);
        } else if (l2 > this.getPosition() && l2 - this.getPosition() < (long)(this.d - this.c) && this.e) {
            this.c += (int)(l2 - this.getPosition());
        } else {
            this.flush();
            this.a.setPosition(l2);
        }
    }

    @Override
    protected void dispose(boolean bl2) {
        if (this.f) {
            return;
        }
        if (this.b != null) {
            this.flush();
        }
        this.a.close();
        this.b = null;
        this.f = true;
    }

    @Override
    public void flush() {
        this.a();
        if (this.e) {
            if (this.canSeek()) {
                this.a.setPosition(this.getPosition());
            }
        } else if (this.c > 0) {
            this.a.write(this.b, 0, this.c);
        }
        this.d = 0;
        this.c = 0;
    }

    @Override
    public long seek(long l2, int n2) {
        this.a();
        if (!this.canSeek()) {
            throw new NotSupportedException("Non seekable stream.");
        }
        this.flush();
        return this.a.seek(l2, n2);
    }

    @Override
    public void setLength(long l2) {
        this.a();
        if (l2 < 0L) {
            throw new ArgumentOutOfRangeException("value must be positive");
        }
        if (!this.a.canWrite() && !this.a.canSeek()) {
            throw new NotSupportedException("the stream cannot seek nor write.");
        }
        if (this.a == null || !this.a.canRead() && !this.a.canWrite()) {
            throw new IOException("the stream is not open");
        }
        this.a.setLength(l2);
        if (this.getPosition() > l2) {
            this.setPosition(l2);
        }
    }

    @Override
    public int readByte() {
        this.a();
        if (!this.a.canRead()) {
            throw new NotSupportedException("Cannot read from stream");
        }
        if (!this.e) {
            this.flush();
            this.e = true;
        }
        if (1 <= this.d - this.c) {
            return this.b[this.c++] & 0xFF;
        }
        if (this.c >= this.d) {
            this.c = 0;
            this.d = 0;
        }
        this.d = this.a.read(this.b, 0, this.b.length);
        if (1 <= this.d) {
            return this.b[this.c++] & 0xFF;
        }
        return -1;
    }

    @Override
    public void writeByte(byte by2) {
        this.a();
        if (!this.a.canWrite()) {
            throw new NotSupportedException("Cannot write to stream");
        }
        if (this.e) {
            this.flush();
            this.e = false;
        } else if (this.c >= this.b.length - 1) {
            this.flush();
        }
        this.b[this.c++] = by2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new ArgumentNullException("array");
        }
        this.a();
        if (!this.a.canRead()) {
            throw new NotSupportedException("Cannot read from stream");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("offset", "< 0");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (byArray.length - n2 < n3) {
            throw new ArgumentException("array.Length - offset < count");
        }
        if (!this.e) {
            this.flush();
            this.e = true;
        }
        if (n3 <= this.d - this.c) {
            Buffer.blockCopy(Array.boxing(this.b), this.c, Array.boxing(byArray), n2, n3);
            this.c += n3;
            if (this.c == this.d) {
                this.c = 0;
                this.d = 0;
            }
            return n3;
        }
        int n4 = this.d - this.c;
        Buffer.blockCopy(Array.boxing(this.b), this.c, Array.boxing(byArray), n2, n4);
        this.c = 0;
        this.d = 0;
        n2 += n4;
        if ((n3 -= n4) >= this.b.length) {
            n4 += this.a.read(byArray, n2, n3);
        } else {
            this.d = this.a.read(this.b, 0, this.b.length);
            if (n3 < this.d) {
                Buffer.blockCopy(Array.boxing(this.b), 0, Array.boxing(byArray), n2, n3);
                this.c = n3;
                n4 += n3;
            } else {
                Buffer.blockCopy(Array.boxing(this.b), 0, Array.boxing(byArray), n2, this.d);
                n4 += this.d;
                this.d = 0;
            }
        }
        return n4;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new ArgumentNullException("array");
        }
        this.a();
        if (!this.a.canWrite()) {
            throw new NotSupportedException("Cannot write to stream");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("offset", "< 0");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (byArray.length - n2 < n3) {
            throw new ArgumentException("array.Length - offset < count");
        }
        if (this.e) {
            this.flush();
            this.e = false;
        }
        if (this.c >= this.b.length - n3) {
            this.flush();
            this.a.write(byArray, n2, n3);
        } else {
            Buffer.blockCopy(Array.boxing(byArray), n2, Array.boxing(this.b), this.c, n3);
            this.c += n3;
        }
    }

    private void a() {
        if (this.f) {
            throw new ObjectDisposedException("BufferedStream", "Stream is closed");
        }
    }
}

