/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.IO.SynchronizedWriter;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import java.math.BigDecimal;

public abstract class TextWriter
implements IDisposable {
    protected char[] CoreNewLine = StringExtensions.toCharArray(Environment.NewLine);
    IFormatProvider a;
    public static TextWriter Null = new NullTextWriter();

    protected TextWriter() {
    }

    protected TextWriter(IFormatProvider iFormatProvider) {
        this.a = iFormatProvider;
    }

    public abstract Encoding getEncoding();

    public IFormatProvider getFormatProvider() {
        return this.a;
    }

    public String getNewLine() {
        return StringExtensions.newString(this.CoreNewLine);
    }

    public void setNewLine(String string) {
        if (string == null) {
            string = Environment.NewLine;
        }
        this.CoreNewLine = StringExtensions.toCharArray(string);
    }

    public void close() {
        this.dispose(true);
    }

    protected void dispose(boolean bl2) {
        if (bl2) {
            GC.suppressFinalize(this);
        }
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    public void flush() {
    }

    public static TextWriter _synchronized(TextWriter textWriter) {
        return TextWriter.a(textWriter, false);
    }

    static TextWriter a(TextWriter textWriter, boolean bl2) {
        if (textWriter == null) {
            throw new ArgumentNullException("writer is null");
        }
        if (textWriter instanceof SynchronizedWriter) {
            return textWriter;
        }
        return new SynchronizedWriter(textWriter, bl2);
    }

    public void write(boolean bl2) {
        this.write(Boolean.toString(bl2));
    }

    public void write(char c2) {
    }

    public void write(char[] cArray) {
        if (cArray == null) {
            return;
        }
        this.write(cArray, 0, cArray.length);
    }

    public void write(BigDecimal bigDecimal) {
        this.write(bigDecimal.toString());
    }

    public void write(double d2) {
        this.write(Double.toString(d2));
    }

    public void write(int n2) {
        this.write(Integer.toString(n2));
    }

    public void write(long l2) {
        this.write(Long.toString(l2));
    }

    public void write(Object object) {
        if (object != null) {
            this.write(object.toString());
        }
    }

    public void write(float f2) {
        this.write(Float.toString(f2));
    }

    public void write(String string) {
        if (string != null) {
            this.write(StringExtensions.toCharArray(string));
        }
    }

    public void write(String string, Object object) {
        this.write(StringExtensions.format(string, object));
    }

    public void write(String string, Object ... objectArray) {
        this.write(StringExtensions.format(string, objectArray));
    }

    public void write(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            throw new ArgumentNullException("buffer");
        }
        if (n2 < 0 || n2 > cArray.length) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (n3 < 0 || n2 > cArray.length - n3) {
            throw new ArgumentOutOfRangeException("count");
        }
        while (n3 > 0) {
            this.write(cArray[n2]);
            --n3;
            ++n2;
        }
    }

    public void write(String string, Object object, Object object2) {
        this.write(StringExtensions.format(string, object, object2));
    }

    public void write(String string, Object object, Object object2, Object object3) {
        this.write(StringExtensions.format(string, object, object2, object3));
    }

    public void writeLine() {
        this.write(this.CoreNewLine);
    }

    public void writeLine(boolean bl2) {
        this.write(bl2);
        this.writeLine();
    }

    public void writeLine(char c2) {
        this.write(c2);
        this.writeLine();
    }

    public void writeLine(char[] cArray) {
        this.write(cArray);
        this.writeLine();
    }

    public void writeLine(BigDecimal bigDecimal) {
        this.write(bigDecimal);
        this.writeLine();
    }

    public void writeLine(double d2) {
        this.write(d2);
        this.writeLine();
    }

    public void writeLine(int n2) {
        this.write(n2);
        this.writeLine();
    }

    public void writeLine(long l2) {
        this.write(l2);
        this.writeLine();
    }

    public void writeLine(Object object) {
        this.write(object);
        this.writeLine();
    }

    public void writeLine(float f2) {
        this.write(f2);
        this.writeLine();
    }

    public void writeLine(String string) {
        this.write(string);
        this.writeLine();
    }

    public void writeLine(String string, Object object) {
        this.write(string, object);
        this.writeLine();
    }

    public void writeLine(String string, Object ... objectArray) {
        this.write(string, objectArray);
        this.writeLine();
    }

    public void writeLine(char[] cArray, int n2, int n3) {
        this.write(cArray, n2, n3);
        this.writeLine();
    }

    public void writeLine(String string, Object object, Object object2) {
        this.write(string, object, object2);
        this.writeLine();
    }

    public void writeLine(String string, Object object, Object object2, Object object3) {
        this.write(string, object, object2, object3);
        this.writeLine();
    }

    static final class NullTextWriter
    extends TextWriter {
        NullTextWriter() {
        }

        @Override
        public Encoding getEncoding() {
            return Encoding.getDefault();
        }

        @Override
        public void write(String string) {
        }

        @Override
        public void write(char c2) {
        }

        @Override
        public void write(char[] cArray, int n2, int n3) {
        }
    }
}

