/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.Mail;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.IO.StreamWriter;
import com.aspose.html.internal.ms.System.Net.Mail.AttachmentBase;
import com.aspose.html.internal.ms.System.Net.Mime.ContentDisposition;
import com.aspose.html.internal.ms.System.Net.Mime.ContentType;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.lang.Operators;

public class Attachment
extends AttachmentBase {
    private ContentDisposition a = new ContentDisposition();
    private Encoding b;

    public Attachment(String string) {
        super(string);
        this.a(string);
    }

    public Attachment(String string, String string2) {
        super(string, string2);
        this.a(string);
    }

    public Attachment(String string, ContentType contentType) {
        super(string, contentType);
        this.a(string);
    }

    public Attachment(Stream stream, ContentType contentType) {
        super(stream, contentType);
    }

    public Attachment(Stream stream, String string) {
        super(stream);
        this.setName(string);
    }

    public Attachment(Stream stream, String string, String string2) {
        super(stream, string2);
        this.setName(string);
    }

    public ContentDisposition getContentDisposition() {
        return this.a;
    }

    public String getName() {
        return this.getContentType().getName();
    }

    public void setName(String string) {
        this.getContentType().setName(string);
    }

    public Encoding getNameEncoding() {
        return this.b;
    }

    public void setNameEncoding(Encoding encoding) {
        this.b = encoding;
    }

    public static Attachment createAttachmentFromString(String string, ContentType contentType) {
        if (string == null) {
            throw new ArgumentNullException("content");
        }
        MemoryStream memoryStream = new MemoryStream();
        StreamWriter streamWriter = new StreamWriter(memoryStream);
        streamWriter.write(string);
        streamWriter.flush();
        memoryStream.setPosition(Operators.castToInt64(0, 9));
        Attachment attachment = new Attachment((Stream)memoryStream, contentType);
        attachment.setTransferEncoding(0);
        return attachment;
    }

    public static Attachment createAttachmentFromString(String string, String string2) {
        if (string == null) {
            throw new ArgumentNullException("content");
        }
        MemoryStream memoryStream = new MemoryStream();
        StreamWriter streamWriter = new StreamWriter(memoryStream);
        streamWriter.write(string);
        streamWriter.flush();
        memoryStream.setPosition(Operators.castToInt64(0, 9));
        Attachment attachment = new Attachment((Stream)memoryStream, new ContentType("text/plain"));
        attachment.setTransferEncoding(0);
        attachment.setName(string2);
        return attachment;
    }

    public static Attachment createAttachmentFromString(String string, String string2, Encoding encoding, String string3) {
        if (string == null) {
            throw new ArgumentNullException("content");
        }
        MemoryStream memoryStream = new MemoryStream();
        StreamWriter streamWriter = new StreamWriter(memoryStream, encoding);
        streamWriter.write(string);
        streamWriter.flush();
        memoryStream.setPosition(Operators.castToInt64(0, 9));
        Attachment attachment = new Attachment(memoryStream, string2, string3);
        attachment.setTransferEncoding(ContentType.guessTransferEncoding(encoding));
        attachment.getContentType().setCharSet(streamWriter.getEncoding().getBodyName());
        return attachment;
    }

    private void a(String string) {
        if (string == null) {
            throw new ArgumentNullException("fileName");
        }
        this.setName(Path.getFileName(string));
    }
}

