/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.DeriveBytes;
import com.aspose.html.internal.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public class PasswordDeriveBytes
extends DeriveBytes {
    private String a;
    private byte[] b;
    private int c;
    private HashAlgorithm d;
    private int e;
    private byte[] f;
    private byte[] g;
    private byte[] h;
    private int i;
    private int j;

    public PasswordDeriveBytes(String string, byte[] byArray) {
        this.a(string, byArray, "SHA1", 100);
    }

    public PasswordDeriveBytes(String string, byte[] byArray, CspParameters cspParameters) {
        this.a(string, byArray, "SHA1", 100);
        if (cspParameters != null) {
            throw new NotSupportedException(n.a("CspParameters not supported for PasswordDeriveBytes."));
        }
    }

    public PasswordDeriveBytes(String string, byte[] byArray, String string2, int n2) {
        this.a(string, byArray, string2, n2);
    }

    public PasswordDeriveBytes(String string, byte[] byArray, String string2, int n2, CspParameters cspParameters) {
        this.a(string, byArray, string2, n2);
        if (cspParameters != null) {
            throw new NotSupportedException(n.a("CspParameters not supported for PasswordDeriveBytes."));
        }
    }

    public PasswordDeriveBytes(byte[] byArray, byte[] byArray2) {
        this.a(byArray, byArray2, "SHA1", 100);
    }

    public PasswordDeriveBytes(byte[] byArray, byte[] byArray2, CspParameters cspParameters) {
        this.a(byArray, byArray2, "SHA1", 100);
        if (cspParameters != null) {
            throw new NotSupportedException(n.a("CspParameters not supported for PasswordDeriveBytes."));
        }
    }

    public PasswordDeriveBytes(byte[] byArray, byte[] byArray2, String string, int n2) {
        this.a(byArray, byArray2, string, n2);
    }

    public PasswordDeriveBytes(byte[] byArray, byte[] byArray2, String string, int n2, CspParameters cspParameters) {
        this.a(byArray, byArray2, string, n2);
        if (cspParameters != null) {
            throw new NotSupportedException(n.a("CspParameters not supported for PasswordDeriveBytes."));
        }
    }

    private void a(String string, byte[] byArray, String string2, int n2) {
        if (string == null) {
            throw new ArgumentNullException("strPassword");
        }
        byte[] byArray2 = Encoding.getUTF8().getBytes(string);
        this.a(byArray2, byArray, string2, n2);
        msArray.clear(byArray2, 0, byArray2.length);
    }

    private void a(byte[] byArray, byte[] byArray2, String string, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("password");
        }
        this.f = (byte[])byArray.clone();
        this.setSalt(byArray2);
        this.setHashName(string);
        this.setIterationCount(n2);
        this.e = 0;
    }

    public String getHashName() {
        return this.a;
    }

    public void setHashName(String string) {
        if (string == null) {
            throw new ArgumentNullException("value");
        }
        if (this.e != 0) {
            throw new CryptographicException(n.a("Can't change this property at this stage"));
        }
        this.a = string;
    }

    public int getIterationCount() {
        return this.c;
    }

    public void setIterationCount(int n2) {
        if (n2 < 1) {
            throw new ArgumentOutOfRangeException("> 0", "IterationCount");
        }
        if (this.e != 0) {
            throw new CryptographicException(n.a("Can't change this property at this stage"));
        }
        this.c = n2;
    }

    public byte[] getSalt() {
        if (this.b == null) {
            return null;
        }
        return (byte[])this.b.clone();
    }

    public void setSalt(byte[] byArray) {
        if (this.e != 0) {
            throw new CryptographicException(n.a("Can't change this property at this stage"));
        }
        this.b = (byte[])(byArray != null ? (byte[])byArray.clone() : null);
    }

    public byte[] cryptDeriveKey(String string, String string2, int n2, byte[] byArray) {
        if (n2 > 128) {
            throw new CryptographicException(n.a("Key Size can't be greater than 128 bits"));
        }
        throw new NotSupportedException(n.a("CspParameters not supported for PasswordDeriveBytes."));
    }

    @Override
    public byte[] getBytes(int n2) {
        if (n2 < 1) {
            throw new IndexOutOfBoundsException("cb");
        }
        if (this.e == 0) {
            this.reset();
            this.e = 1;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = Math.max(1, this.c - 1);
        if (this.h == null) {
            this.h = this.g;
            for (int i2 = 0; i2 < n4 - 1; ++i2) {
                this.h = this.d.computeHash(this.h);
            }
        }
        while (n3 < n2) {
            int n5;
            byte[] byArray2 = null;
            if (this.j == 0) {
                byArray2 = this.d.computeHash(this.h);
            } else if (this.j < 1000) {
                String string = Convert.toString(this.j);
                byArray2 = new byte[this.h.length + string.length()];
                for (n5 = 0; n5 < string.length(); ++n5) {
                    byArray2[n5] = (byte)string.charAt(n5);
                }
                Buffer.blockCopy(Array.boxing(this.h), 0, Array.boxing(byArray2), string.length(), this.h.length);
                byArray2 = this.d.computeHash(byArray2);
            } else {
                throw new CryptographicException(n.a("too long"));
            }
            int n6 = byArray2.length - this.i;
            n5 = Math.min(n2 - n3, n6);
            Buffer.blockCopy(Array.boxing(byArray2), this.i, Array.boxing(byArray), n3, n5);
            n3 += n5;
            this.i += n5;
            while (this.i >= byArray2.length) {
                this.i -= byArray2.length;
                ++this.j;
            }
        }
        return byArray;
    }

    @Override
    public void reset() {
        this.e = 0;
        this.i = 0;
        this.j = 0;
        this.d = HashAlgorithm.create(this.a);
        if (this.b != null) {
            this.d.transformBlock(this.f, 0, this.f.length, this.f, 0);
            this.d.transformFinalBlock(this.b, 0, this.b.length);
            this.g = this.d.getHash();
        } else {
            this.g = this.d.computeHash(this.f);
        }
    }
}

