/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs.Pkcs9AttributeObject;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.lang.Operators;

public final class Pkcs9MessageDigest
extends Pkcs9AttributeObject {
    public static final String oid = "1.2.840.113549.1.9.4";
    public static final String friendlyName = "Message Digest";
    private byte[] a;
    private byte[] b;

    public Pkcs9MessageDigest() {
        Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
        this.b = null;
    }

    public Pkcs9MessageDigest(byte[] byArray, boolean bl2) {
        if (byArray == null) {
            throw new ArgumentNullException("messageDigest");
        }
        if (bl2) {
            Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
            this.setRawData(byArray);
            this.decode(byArray);
        } else {
            Operators.as(this, AsnEncodedData.class).setOid(new Oid(oid, friendlyName));
            this.a = (byte[])this.a.clone();
            this.setRawData(this.encode());
        }
    }

    public byte[] getMessageDigest() {
        if (this.b != null) {
            this.decode(this.b);
        }
        return this.a;
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        super.copyFrom(asnEncodedData);
        this.b = asnEncodedData.getRawData();
    }

    public void decode(byte[] byArray) {
        if (byArray == null || Operators.castToInt32(byArray[0], 6) != 4) {
            throw new CryptographicException("Expected an OCTETSTRING.");
        }
        ASN1 aSN1 = new ASN1(byArray);
        this.a = aSN1.getValue();
        this.b = null;
    }

    public byte[] encode() {
        ASN1 aSN1 = new ASN1(4, this.a);
        return aSN1.getBytes();
    }
}

