/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAParameters;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public abstract class RSA
extends AsymmetricAlgorithm {
    public static RSA create() {
        return RSA.create("System.Security.Cryptography.RSA");
    }

    public static RSA create(String string) {
        return (RSA)CryptoConfig.createFromName(string);
    }

    protected RSA() {
    }

    public abstract byte[] encryptValue(byte[] var1);

    public abstract byte[] decryptValue(byte[] var1);

    public abstract RSAParameters exportParameters(boolean var1);

    public abstract void importParameters(RSAParameters var1);

    void a(RSAParameters rSAParameters) {
        if (rSAParameters.P != null) {
            msArray.clear(rSAParameters.P, 0, rSAParameters.P.length);
        }
        if (rSAParameters.Q != null) {
            msArray.clear(rSAParameters.Q, 0, rSAParameters.Q.length);
        }
        if (rSAParameters.DP != null) {
            msArray.clear(rSAParameters.DP, 0, rSAParameters.DP.length);
        }
        if (rSAParameters.DQ != null) {
            msArray.clear(rSAParameters.DQ, 0, rSAParameters.DQ.length);
        }
        if (rSAParameters.InverseQ != null) {
            msArray.clear(rSAParameters.InverseQ, 0, rSAParameters.InverseQ.length);
        }
        if (rSAParameters.D != null) {
            msArray.clear(rSAParameters.D, 0, rSAParameters.D.length);
        }
    }

    @Override
    public void fromXmlString(String string) {
        if (string == null) {
            throw new ArgumentNullException("xmlString");
        }
        RSAParameters rSAParameters = new RSAParameters();
        try {
            rSAParameters.P = RSA.a(string, "P");
            rSAParameters.Q = RSA.a(string, "Q");
            rSAParameters.D = RSA.a(string, "D");
            rSAParameters.DP = RSA.a(string, "DP");
            rSAParameters.DQ = RSA.a(string, "DQ");
            rSAParameters.InverseQ = RSA.a(string, "InverseQ");
            rSAParameters.Exponent = RSA.a(string, "Exponent");
            rSAParameters.Modulus = RSA.a(string, "Modulus");
            this.importParameters(rSAParameters.Clone());
        }
        catch (RuntimeException runtimeException) {
            throw new CryptographicException(n.a("Couldn't decode XML"), runtimeException);
        }
        finally {
            this.a(rSAParameters.Clone());
        }
    }

    @Override
    public String toXmlString(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        RSAParameters rSAParameters = this.exportParameters(bl2).Clone();
        try {
            stringBuilder.append("<RSAKeyValue>");
            stringBuilder.append("<Modulus>");
            stringBuilder.append(Convert.toBase64String(rSAParameters.Modulus));
            stringBuilder.append("</Modulus>");
            stringBuilder.append("<Exponent>");
            stringBuilder.append(Convert.toBase64String(rSAParameters.Exponent));
            stringBuilder.append("</Exponent>");
            if (bl2) {
                if (rSAParameters.D == null) {
                    String string = n.a("Missing D parameter for the private key.");
                    throw new ArgumentNullException("rsaParams.D", string);
                }
                if (rSAParameters.P == null || rSAParameters.Q == null || rSAParameters.DP == null || rSAParameters.DQ == null || rSAParameters.InverseQ == null) {
                    String string = n.a("Missing some CRT parameters for the private key.");
                    throw new CryptographicException(string);
                }
                stringBuilder.append("<P>");
                stringBuilder.append(Convert.toBase64String(rSAParameters.P));
                stringBuilder.append("</P>");
                stringBuilder.append("<Q>");
                stringBuilder.append(Convert.toBase64String(rSAParameters.Q));
                stringBuilder.append("</Q>");
                stringBuilder.append("<DP>");
                stringBuilder.append(Convert.toBase64String(rSAParameters.DP));
                stringBuilder.append("</DP>");
                stringBuilder.append("<DQ>");
                stringBuilder.append(Convert.toBase64String(rSAParameters.DQ));
                stringBuilder.append("</DQ>");
                stringBuilder.append("<InverseQ>");
                stringBuilder.append(Convert.toBase64String(rSAParameters.InverseQ));
                stringBuilder.append("</InverseQ>");
                stringBuilder.append("<D>");
                stringBuilder.append(Convert.toBase64String(rSAParameters.D));
                stringBuilder.append("</D>");
            }
            stringBuilder.append("</RSAKeyValue>");
        }
        catch (RuntimeException runtimeException) {
            this.a(rSAParameters.Clone());
            throw runtimeException;
        }
        return stringBuilder.toString();
    }
}

