/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricSignatureFormatter;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicUnexpectedOperationException;
import com.aspose.html.internal.ms.System.Security.Cryptography.HashAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSACryptoServiceProvider;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.s;
import com.aspose.html.internal.ms.core.bc.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.x509.DigestInfo;
import com.aspose.html.internal.ms.lang.Operators;
import java.io.IOException;

public class RSAPKCS1SignatureFormatter
extends AsymmetricSignatureFormatter {
    private RSA a;
    private HashAlgorithm b;

    public RSAPKCS1SignatureFormatter() {
    }

    public RSAPKCS1SignatureFormatter(AsymmetricAlgorithm asymmetricAlgorithm) {
        this.setKey(asymmetricAlgorithm);
    }

    public byte[] createSignatureWithSha1(byte[] byArray) {
        if (this.a instanceof RSACryptoServiceProvider && ((RSACryptoServiceProvider)this.a).hasJavaPrivateKey()) {
            return ((RSACryptoServiceProvider)this.a).signDataSHA1withRSA(byArray);
        }
        this.setHashAlgorithm("SHA1");
        HashAlgorithm hashAlgorithm = HashAlgorithm.create("SHA1");
        byte[] byArray2 = hashAlgorithm.computeHash(byArray);
        return this.createSignature(byArray2);
    }

    @Override
    public byte[] createSignature(byte[] byArray) {
        if (this.a == null) {
            throw new CryptographicUnexpectedOperationException(n.a("No key pair available."));
        }
        if (this.b == null) {
            throw new CryptographicUnexpectedOperationException(n.a("Missing hash algorithm."));
        }
        if (byArray == null) {
            throw new ArgumentNullException("rgbHash");
        }
        try {
            return s.b(this.a, this.b, byArray);
        }
        catch (Exception exception) {
            RSACryptoServiceProvider rSACryptoServiceProvider = Operators.as(this.a, RSACryptoServiceProvider.class);
            byte[] byArray2 = null;
            if (rSACryptoServiceProvider != null && rSACryptoServiceProvider.hasJavaPrivateKey()) {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, null);
                DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, byArray);
                try {
                    byte[] byArray3 = digestInfo.toASN1Primitive().getEncoded();
                    byArray2 = rSACryptoServiceProvider.signDataNoneWithRSA(byArray3);
                    if (byArray2 == null) {
                        throw exception;
                    }
                    return byArray2;
                }
                catch (IOException iOException) {
                    throw exception;
                }
            }
            throw exception;
        }
    }

    @Override
    public void setHashAlgorithm(String string) {
        this.b = HashAlgorithm.create(string);
    }

    @Override
    public void setKey(AsymmetricAlgorithm asymmetricAlgorithm) {
        if (asymmetricAlgorithm == null) {
            throw new ArgumentNullException("key");
        }
        this.a = (RSA)asymmetricAlgorithm;
    }
}

