/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.IO.File;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSACryptoServiceProvider;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSACryptoServiceProvider;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.PublicKey;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X500DistinguishedName;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Chain;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509ExtensionCollection;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.RSAManaged;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.b;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.c;
import com.aspose.html.internal.ms.lang.Operators;

public class X509Certificate2
extends X509Certificate {
    private boolean c;
    private X509ExtensionCollection d;
    private String e = StringExtensions.Empty;
    private String f;
    private PublicKey g;
    private X500DistinguishedName h;
    private X500DistinguishedName i;
    private Oid j;
    private com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate k;
    private static String l = StringExtensions.format("Certificate instance is empty.", new Object[0]);
    static byte[] a = new byte[]{85, 4, 3};
    static byte[] b = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 1};
    private static byte[] m = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 2};

    public X509Certificate2() {
        this.k = null;
    }

    public X509Certificate2(byte[] byArray) {
        this.import_(byArray, (String)null, 0);
    }

    public X509Certificate2(byte[] byArray, String string) {
        this.import_(byArray, string, 0);
    }

    public X509Certificate2(byte[] byArray, String string, int n2) {
        this.import_(byArray, string, n2);
    }

    public X509Certificate2(String string) {
        this.import_(string, StringExtensions.Empty, 0);
    }

    public X509Certificate2(String string, String string2) {
        this.import_(string, string2, 0);
    }

    public X509Certificate2(String string, String string2, int n2) {
        this.import_(string, string2, n2);
    }

    public X509Certificate2(X509Certificate x509Certificate) {
        super(x509Certificate);
        this.k = new com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate(super.getRawCertData());
    }

    public boolean getArchived() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        return this.c;
    }

    public void setArchived(boolean bl2) {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        this.c = bl2;
    }

    public X509ExtensionCollection getExtensions() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        if (this.d == null) {
            this.d = new X509ExtensionCollection(this.k);
        }
        return this.d;
    }

    public String getFriendlyName() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        return this.e;
    }

    public void setFriendlyName(String string) {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        this.e = string;
    }

    public boolean hasPrivateKey() {
        return this.getPrivateKey() != null;
    }

    public X500DistinguishedName get_IssuerName() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        if (this.h == null) {
            this.h = new X500DistinguishedName(this.k.getIssuerName().getBytes());
        }
        return this.h;
    }

    public DateTime getNotAfter() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        return this.k.getValidUntil().toLocalTime();
    }

    public DateTime getNotBefore() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        return this.k.getValidFrom().toLocalTime();
    }

    public AsymmetricAlgorithm getPrivateKey() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        try {
            if (this.k.getRSA() != null) {
                RSACryptoServiceProvider rSACryptoServiceProvider = Operators.as(this.k.getRSA(), RSACryptoServiceProvider.class);
                if (rSACryptoServiceProvider != null) {
                    return rSACryptoServiceProvider.getPublicOnly() ? null : rSACryptoServiceProvider;
                }
                RSAManaged rSAManaged = Operators.as(this.k.getRSA(), RSAManaged.class);
                if (rSAManaged != null) {
                    return rSAManaged.getPublicOnly() ? null : rSAManaged;
                }
                this.k.getRSA().exportParameters(true);
                return this.k.getRSA();
            }
            if (this.k.getDSA() != null) {
                DSACryptoServiceProvider dSACryptoServiceProvider = Operators.as(this.k.getDSA(), DSACryptoServiceProvider.class);
                if (dSACryptoServiceProvider != null) {
                    return dSACryptoServiceProvider.getPublicOnly() ? null : dSACryptoServiceProvider;
                }
                this.k.getDSA().exportParameters(true);
                return this.k.getDSA();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public void setPrivateKey(AsymmetricAlgorithm asymmetricAlgorithm) {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        if (asymmetricAlgorithm == null) {
            this.k.setRSA(null);
            this.k.setDSA(null);
        } else if (Operators.is(asymmetricAlgorithm, RSA.class)) {
            this.k.setRSA((RSA)asymmetricAlgorithm);
        } else if (Operators.is(asymmetricAlgorithm, DSA.class)) {
            this.k.setDSA((DSA)asymmetricAlgorithm);
        } else {
            throw new NotSupportedException();
        }
    }

    public PublicKey get_PublicKey() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        if (this.g == null) {
            try {
                this.g = new PublicKey(this.k);
            }
            catch (RuntimeException runtimeException) {
                String string = StringExtensions.format("Unable to decode public key.", new Object[0]);
                throw new CryptographicException(string, runtimeException);
            }
        }
        return this.g;
    }

    public byte[] getRawData() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        return super.getRawCertData();
    }

    public String get_SerialNumber() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        if (this.f == null) {
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            byte[] byArray = this.k.getSerialNumber();
            for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
                msStringBuilder2.append(ByteExtensions.toString(byArray[i2], "X2"));
            }
            this.f = msStringBuilder2.toString();
        }
        return this.f;
    }

    public Oid getSignatureAlgorithm() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        if (this.j == null) {
            this.j = new Oid(this.k.getSignatureAlgorithm());
        }
        return this.j;
    }

    public X500DistinguishedName getSubjectName() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        if (this.i == null) {
            this.i = new X500DistinguishedName(this.k.getSubjectName().getBytes());
        }
        return this.i;
    }

    public String getThumbprint() {
        return super.getCertHashString();
    }

    public int getVersion() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        return this.k.getVersion();
    }

    public String getNameInfo(int n2, boolean bl2) {
        switch (n2) {
            case 0: {
                if (this.k == null) {
                    throw new CryptographicException(l);
                }
                ASN1 aSN1 = bl2 ? this.k.getIssuerName() : this.k.getSubjectName();
                ASN1 aSN12 = this.a(a, aSN1);
                if (aSN12 != null) {
                    return this.a(aSN12);
                }
                if (aSN1.getCount() == 0) {
                    return StringExtensions.Empty;
                }
                ASN1 aSN13 = aSN1.get_Item(aSN1.getCount() - 1);
                if (aSN13.getCount() == 0) {
                    return StringExtensions.Empty;
                }
                return this.a(aSN13.get_Item(0));
            }
            case 1: {
                ASN1 aSN1 = this.a(b, bl2 ? this.k.getIssuerName() : this.k.getSubjectName());
                if (aSN1 != null) {
                    return this.a(aSN1);
                }
                return StringExtensions.Empty;
            }
            case 2: {
                return StringExtensions.Empty;
            }
            case 3: {
                if (this.k == null) {
                    throw new NullReferenceException();
                }
                ASN1 aSN1 = this.a(a, bl2 ? this.k.getIssuerName() : this.k.getSubjectName());
                if (aSN1 != null) {
                    return this.a(aSN1);
                }
                return StringExtensions.Empty;
            }
            case 4: {
                return StringExtensions.Empty;
            }
            case 5: {
                return StringExtensions.Empty;
            }
        }
        throw new ArgumentException("nameType");
    }

    private ASN1 a(byte[] byArray, ASN1 aSN1) {
        if (aSN1.getCount() == 0) {
            return null;
        }
        for (int i2 = 0; i2 < aSN1.getCount(); ++i2) {
            ASN1 aSN12 = aSN1.get_Item(i2);
            for (int i3 = 0; i3 < aSN12.getCount(); ++i3) {
                ASN1 aSN13;
                ASN1 aSN14 = aSN12.get_Item(i3);
                if (aSN14.getCount() != 2 || (aSN13 = aSN14.get_Item(0)) == null || !aSN13.compareValue(byArray)) continue;
                return aSN14;
            }
        }
        return null;
    }

    private String a(ASN1 aSN1) {
        if (aSN1.getCount() != 2) {
            return StringExtensions.Empty;
        }
        ASN1 aSN12 = aSN1.get_Item(1);
        if (aSN12.getValue() == null || aSN12.getLength() == 0) {
            return StringExtensions.Empty;
        }
        if (Operators.castToInt32(aSN12.getTag(), 6) == 30) {
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            for (int i2 = 1; i2 < aSN12.getValue().length; i2 += 2) {
                msStringBuilder2.append(Operators.castToChar(aSN12.getValue()[i2], 6));
            }
            return msStringBuilder2.toString();
        }
        return Encoding.getUTF8().getString(aSN12.getValue());
    }

    private void a(byte[] byArray, String string) throws Exception {
        try {
            c c2 = string == null ? new c(byArray) : new c(byArray, string);
            this.k = c2.d().size() > 0 ? c2.d().get_Item(0) : null;
            if (c2.b().size() > 0) {
                this.k.setRSA(Operators.as(c2.b().get_Item(0), RSA.class));
                this.k.setDSA(Operators.as(c2.b().get_Item(0), DSA.class));
            }
        }
        catch (b b2) {
            throw new CryptographicException(b2.getMessage(), b2);
        }
    }

    @Override
    public void import_(byte[] byArray) {
        this.import_(byArray, (String)null, 0);
    }

    @Override
    public void import_(byte[] byArray, String string, int n2) {
        super.import_(byArray, string, n2);
        if (string == null) {
            try {
                this.k = new com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate(byArray);
            }
            catch (RuntimeException runtimeException) {
                try {
                    this.a(byArray, (String)null);
                }
                catch (Exception exception) {
                    String string2 = StringExtensions.format("Unable to decode certificate.", new Object[0]);
                    throw new CryptographicException(string2, exception);
                }
            }
        } else {
            try {
                this.a(byArray, string);
            }
            catch (Exception exception) {
                this.k = this.getX509Certificate(byArray, string);
            }
        }
    }

    @Override
    public void import_(String string) {
        byte[] byArray = X509Certificate2.a(string);
        this.import_(byArray, (String)null, 0);
    }

    @Override
    public void import_(String string, String string2, int n2) {
        byte[] byArray = X509Certificate2.a(string);
        this.import_(byArray, string2, n2);
    }

    private static byte[] a(String string) {
        byte[] byArray = null;
        FileStream fileStream = File.openRead(string);
        try {
            byArray = new byte[(int)fileStream.getLength()];
            fileStream.read(byArray, 0, byArray.length);
            fileStream.close();
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
        return byArray;
    }

    @Override
    public void reset() {
        this.k = null;
        this.c = false;
        this.d = null;
        this.e = StringExtensions.Empty;
        this.f = null;
        this.g = null;
        this.h = null;
        this.i = null;
        this.j = null;
        super.reset();
    }

    @Override
    public String toString() {
        if (this.k == null) {
            return "System.Security.Cryptography.X509Certificates.X509Certificate2";
        }
        return super.toString(true);
    }

    @Override
    public String toString(boolean bl2) {
        if (this.k == null) {
            return "System.Security.Cryptography.X509Certificates.X509Certificate2";
        }
        if (!bl2) {
            return super.toString(true);
        }
        String string = Environment.get_NewLine();
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        msStringBuilder2.appendFormat("[Version]{0}  V{1}{0}{0}", string, Operators.boxing(this.getVersion()));
        msStringBuilder2.appendFormat("[Subject]{0}  {1}{0}{0}", string, this.getSubject());
        msStringBuilder2.appendFormat("[Issuer]{0}  {1}{0}{0}", string, this.getIssuer());
        msStringBuilder2.appendFormat("[Serial Number]{0}  {1}{0}{0}", string, this.getSerialNumber());
        msStringBuilder2.appendFormat("[Not Before]{0}  {1}{0}{0}", string, Operators.boxing(this.getNotBefore()));
        msStringBuilder2.appendFormat("[Not After]{0}  {1}{0}{0}", string, Operators.boxing(this.getNotAfter()));
        msStringBuilder2.appendFormat("[Thumbprint]{0}  {1}{0}{0}", string, this.getThumbprint());
        msStringBuilder2.appendFormat("[Signature Algorithm]{0}  {1}({2}){0}{0}", string, this.getSignatureAlgorithm().getFriendlyName(), this.getSignatureAlgorithm().getValue());
        AsymmetricAlgorithm asymmetricAlgorithm = this.get_PublicKey().getKey();
        msStringBuilder2.appendFormat("[Public Key]{0}  Algorithm: ", string);
        if (Operators.is(asymmetricAlgorithm, RSA.class)) {
            msStringBuilder2.append("RSA");
        } else if (Operators.is(asymmetricAlgorithm, DSA.class)) {
            msStringBuilder2.append("DSA");
        } else {
            msStringBuilder2.append(asymmetricAlgorithm.toString());
        }
        msStringBuilder2.appendFormat("{0}  Length: {1}{0}  Key Blob: ", string, Operators.boxing(asymmetricAlgorithm.getKeySize()));
        X509Certificate2.a(msStringBuilder2, this.get_PublicKey().getEncodedKeyValue().getRawData());
        msStringBuilder2.appendFormat("{0}  Parameters: ", string);
        X509Certificate2.a(msStringBuilder2, this.get_PublicKey().getEncodedParameters().getRawData());
        msStringBuilder2.append(string);
        return msStringBuilder2.toString();
    }

    private static void a(msStringBuilder msStringBuilder2, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            msStringBuilder2.append(ByteExtensions.toString(byArray[i2], "x2"));
            if (i2 >= byArray.length - 1) continue;
            msStringBuilder2.append(" ");
        }
    }

    public boolean verify() {
        if (this.k == null) {
            throw new CryptographicException(l);
        }
        X509Chain x509Chain = (X509Chain)CryptoConfig.createFromName("X509Chain");
        return x509Chain.build(this);
    }

    public static int getCertContentType(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new ArgumentException("rawData");
        }
        int n2 = 0;
        try {
            ASN1 aSN1 = new ASN1(byArray);
            if (Operators.castToInt32(aSN1.getTag(), 6) != 48) {
                String string = StringExtensions.format("Unable to decode certificate.", new Object[0]);
                throw new CryptographicException(string);
            }
            if (aSN1.getCount() == 0) {
                return n2;
            }
            if (aSN1.getCount() == 3) {
                switch (aSN1.get_Item(0).getTag()) {
                    case 48: {
                        if (Operators.castToInt32(aSN1.get_Item(1).getTag(), 6) != 48 || Operators.castToInt32(aSN1.get_Item(2).getTag(), 6) != 3) break;
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        if (Operators.castToInt32(aSN1.get_Item(1).getTag(), 6) != 48 || Operators.castToInt32(aSN1.get_Item(2).getTag(), 6) != 48) break;
                        n2 = 3;
                    }
                }
            }
            if (Operators.castToInt32(aSN1.get_Item(0).getTag(), 6) == 6 && aSN1.get_Item(0).compareValue(m)) {
                n2 = 5;
            }
        }
        catch (RuntimeException runtimeException) {
            String string = StringExtensions.format("Unable to decode certificate.", new Object[0]);
            throw new CryptographicException(string, runtimeException);
        }
        return n2;
    }

    public static int getCertContentType(String string) {
        if (string == null) {
            throw new ArgumentNullException("fileName");
        }
        if (string.length() == 0) {
            throw new ArgumentException("fileName");
        }
        byte[] byArray = X509Certificate2.a(string);
        return X509Certificate2.getCertContentType(byArray);
    }

    public com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate getInternalCertificate() {
        return this.k;
    }
}

