/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Principal;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Security.Principal.IdentityNotMappedException;
import com.aspose.html.internal.ms.System.Security.Principal.IdentityReference;
import com.aspose.html.internal.ms.System.Security.Principal.SecurityIdentifier;
import com.aspose.html.internal.ms.System.Security.Principal.WellKnownAccount;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.lang.Operators;

public final class NTAccount
extends IdentityReference {
    private String a;

    public NTAccount(String string) {
        if (string == null) {
            throw new ArgumentNullException("name");
        }
        if (string.length() == 0) {
            throw new ArgumentException("Empty", "name");
        }
        this.a = string;
    }

    public NTAccount(String string, String string2) {
        if (string2 == null) {
            throw new ArgumentNullException("accountName");
        }
        if (string2.length() == 0) {
            throw new ArgumentException("Empty", "accountName");
        }
        this.a = string == null ? string2 : StringExtensions.concat(string, "\\", string2);
    }

    @Override
    public String getValue() {
        return this.a;
    }

    @Override
    public boolean equals(Object object) {
        NTAccount nTAccount = Operators.as(object, NTAccount.class);
        if (nTAccount == null) {
            return false;
        }
        return StringExtensions.equals(nTAccount.getValue(), this.getValue());
    }

    @Override
    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public boolean isValidTargetType(Type type) {
        if (type == Operators.typeOf(NTAccount.class)) {
            return true;
        }
        return type == Operators.typeOf(SecurityIdentifier.class);
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    public IdentityReference translate(Type type) {
        if (type == Operators.typeOf(NTAccount.class)) {
            return this;
        }
        if (type == Operators.typeOf(SecurityIdentifier.class)) {
            WellKnownAccount wellKnownAccount = WellKnownAccount.f(this.getValue());
            if (wellKnownAccount == null || wellKnownAccount.c() == null) {
                throw new IdentityNotMappedException("Cannot map account name: " + this.getValue());
            }
            return new SecurityIdentifier(wellKnownAccount.c());
        }
        throw new ArgumentException("Unknown type", "targetType");
    }

    public static boolean op_Equality(NTAccount nTAccount, NTAccount nTAccount2) {
        if (nTAccount == null) {
            return nTAccount2 == null;
        }
        if (nTAccount2 == null) {
            return false;
        }
        return StringExtensions.equals(nTAccount.getValue(), nTAccount2.getValue());
    }

    public static boolean op_Inequality(NTAccount nTAccount, NTAccount nTAccount2) {
        if (nTAccount == null) {
            return nTAccount2 != null;
        }
        if (nTAccount2 == null) {
            return true;
        }
        return !StringExtensions.equals(nTAccount.getValue(), nTAccount2.getValue());
    }
}

