/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Principal;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.Marshal;
import com.aspose.html.internal.ms.System.Security.Principal.IdentityNotMappedException;
import com.aspose.html.internal.ms.System.Security.Principal.IdentityReference;
import com.aspose.html.internal.ms.System.Security.Principal.NTAccount;
import com.aspose.html.internal.ms.System.Security.Principal.WellKnownAccount;
import com.aspose.html.internal.ms.System.Security.Principal.WellKnownSidType;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.UInt32Extensions;
import com.aspose.html.internal.ms.System.UInt64Extensions;
import com.aspose.html.internal.ms.lang.Operators;

public final class SecurityIdentifier
extends IdentityReference
implements Comparable<SecurityIdentifier> {
    private byte[] a;
    public static final int MaxBinaryLength = 68;
    public static final int MinBinaryLength = 8;

    public SecurityIdentifier(String string) {
        if (string == null) {
            throw new ArgumentNullException("sddlForm");
        }
        this.a = SecurityIdentifier.a(string);
    }

    public SecurityIdentifier(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("binaryForm");
        }
        if (n2 < 0 || n2 > byArray.length - 2) {
            throw new ArgumentException("offset");
        }
        this.a(byArray, byArray.length - n2);
    }

    private void a(byte[] byArray, int n2) {
        byte by2 = Marshal.readByte(byArray, 0);
        byte by3 = Marshal.readByte(byArray, 1);
        if (by2 != 1 || by3 > 15) {
            throw new ArgumentException("Value was invalid.");
        }
        if (n2 < 8 + by3 * 4) {
            throw new ArgumentException("offset");
        }
        this.a = new byte[8 + by3 * 4];
        System.arraycopy(byArray, 0, this.a, 0, this.a.length);
    }

    public SecurityIdentifier(WellKnownSidType wellKnownSidType, SecurityIdentifier securityIdentifier) {
        WellKnownAccount wellKnownAccount = WellKnownAccount.b(wellKnownSidType);
        if (wellKnownAccount == null) {
            throw new ArgumentException("Unable to convert SID type: " + wellKnownSidType);
        }
        if (wellKnownAccount.b()) {
            this.a = SecurityIdentifier.a(wellKnownAccount.c());
        } else {
            if (securityIdentifier == null) {
                throw new ArgumentNullException("domainSid");
            }
            this.a = SecurityIdentifier.a(securityIdentifier.getValue() + "-" + wellKnownAccount.d());
        }
    }

    public SecurityIdentifier getAccountDomainSid() {
        String string = this.getValue();
        if (!StringExtensions.startsWith(string, "S-1-5-21") || Operators.castToInt32(this.a[1], 6) < 4) {
            return null;
        }
        byte[] byArray = new byte[24];
        Array.copy(Array.boxing(this.a), 0, Array.boxing(byArray), 0, byArray.length);
        byArray[1] = 4;
        return new SecurityIdentifier(byArray, 0);
    }

    public int getBinaryLength() {
        return this.a.length;
    }

    @Override
    public String getValue() {
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        long l2 = this.b();
        msStringBuilder2.appendFormat(CultureInfo.getInvariantCulture(), "S-1-{0}", Operators.boxing(l2));
        byte by2 = 0;
        while (Operators.castToInt32(by2, 6) < Operators.castToInt32(this.c(), 6)) {
            msStringBuilder2.appendFormat(CultureInfo.getInvariantCulture(), "-{0}", Operators.boxing(this.a(by2)));
            by2 = (byte)(by2 + 1);
        }
        return msStringBuilder2.toString();
    }

    private long b() {
        return Operators.castToUInt64(this.a[2], 6) << 40 | Operators.castToUInt64(this.a[3], 6) << 32 | Operators.castToUInt64(this.a[4], 6) << 24 | Operators.castToUInt64(this.a[5], 6) << 16 | Operators.castToUInt64(this.a[6], 6) << 8 | Operators.castToUInt64(this.a[7], 6) << 0;
    }

    private byte c() {
        return this.a[1];
    }

    private long a(byte by2) {
        int n2 = 8 + Operators.castToInt32(by2, 6) * 4;
        return Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(this.a[n2 + 0], 6), 10) << 0, 10) | Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(this.a[n2 + 1], 6), 10) << 8, 10), 10) | Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(this.a[n2 + 2], 6), 10) << 16, 10), 10) | Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(this.a[n2 + 3], 6), 10) << 24, 10), 10);
    }

    @Override
    public int compareTo(SecurityIdentifier securityIdentifier) {
        if (securityIdentifier == null) {
            throw new ArgumentNullException("sid");
        }
        int n2 = UInt64Extensions.compareTo(this.b(), securityIdentifier.b());
        if (0 != n2) {
            return n2;
        }
        n2 = ByteExtensions.compareTo(this.c(), securityIdentifier.c());
        if (0 != n2) {
            return n2;
        }
        byte by2 = 0;
        while (Operators.castToInt32(by2, 6) < Operators.castToInt32(this.c(), 6)) {
            n2 = UInt32Extensions.compareTo(this.a(by2), securityIdentifier.a(by2));
            if (0 != n2) {
                return n2;
            }
            by2 = (byte)(by2 + 1);
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        return this.equals(Operators.as(object, SecurityIdentifier.class));
    }

    public boolean equals(SecurityIdentifier securityIdentifier) {
        if (securityIdentifier == null) {
            return false;
        }
        return StringExtensions.equals(securityIdentifier.getValue(), this.getValue());
    }

    public void getBinaryForm(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new ArgumentNullException("binaryForm");
        }
        if (n2 < 0 || n2 > byArray.length - this.a.length) {
            throw new ArgumentException("offset");
        }
        Array.copy(Array.boxing(this.a), 0, Array.boxing(byArray), n2, this.a.length);
    }

    @Override
    public int hashCode() {
        return this.getValue().hashCode();
    }

    public boolean isAccountSid() {
        return this.getAccountDomainSid() != null;
    }

    public boolean isEqualDomainSid(SecurityIdentifier securityIdentifier) {
        SecurityIdentifier securityIdentifier2 = this.getAccountDomainSid();
        if (securityIdentifier2 == null) {
            return false;
        }
        return securityIdentifier2.equals(securityIdentifier.getAccountDomainSid());
    }

    @Override
    public boolean isValidTargetType(Type type) {
        if (type == Operators.typeOf(SecurityIdentifier.class)) {
            return true;
        }
        return type == Operators.typeOf(NTAccount.class);
    }

    public boolean isWellKnown(WellKnownSidType wellKnownSidType) {
        WellKnownAccount wellKnownAccount = WellKnownAccount.b(wellKnownSidType);
        if (wellKnownAccount == null) {
            return false;
        }
        String string = this.getValue();
        if (wellKnownAccount.b()) {
            return StringExtensions.equals(string, wellKnownAccount.c());
        }
        return StringExtensions.startsWith(string, "S-1-5-21", (short)5) && StringExtensions.endsWith(string, "-" + wellKnownAccount.d(), (short)5);
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    public IdentityReference translate(Type type) {
        if (type == Operators.typeOf(SecurityIdentifier.class)) {
            return this;
        }
        if (type == Operators.typeOf(NTAccount.class)) {
            WellKnownAccount wellKnownAccount = WellKnownAccount.e(this.getValue());
            if (wellKnownAccount == null || wellKnownAccount.e() == null) {
                throw new IdentityNotMappedException("Unable to map SID: " + this.getValue());
            }
            return new NTAccount(wellKnownAccount.e());
        }
        throw new ArgumentException("Unknown type.", "targetType");
    }

    public static boolean op_Equality(SecurityIdentifier securityIdentifier, SecurityIdentifier securityIdentifier2) {
        if (securityIdentifier == null) {
            return securityIdentifier2 == null;
        }
        if (securityIdentifier2 == null) {
            return false;
        }
        return StringExtensions.equals(securityIdentifier.getValue(), securityIdentifier2.getValue());
    }

    public static boolean op_Inequality(SecurityIdentifier securityIdentifier, SecurityIdentifier securityIdentifier2) {
        if (securityIdentifier == null) {
            return securityIdentifier2 != null;
        }
        if (securityIdentifier2 == null) {
            return true;
        }
        return !StringExtensions.equals(securityIdentifier.getValue(), securityIdentifier2.getValue());
    }

    String a() {
        String string = this.getValue();
        WellKnownAccount wellKnownAccount = WellKnownAccount.e(string);
        if (wellKnownAccount == null || wellKnownAccount.f() == null) {
            return string;
        }
        return wellKnownAccount.f();
    }

    static SecurityIdentifier a(String string, int[] nArray) {
        int n2;
        String string2;
        if (string.length() - nArray[0] < 2) {
            throw new ArgumentException("Invalid SDDL string.", "sddlForm");
        }
        String string3 = StringExtensions.toUpperInvariant(StringExtensions.substring(string, nArray[0], 2));
        if ("S-".equals(string3)) {
            int n3 = nArray[0];
            char c2 = Char.toUpperInvariant(string.charAt(n3));
            while (c2 == 'S' || c2 == '-' || c2 == 'X' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F') {
                c2 = Char.toUpperInvariant(string.charAt(++n3));
            }
            string2 = StringExtensions.substring(string, nArray[0], n3 - nArray[0]);
            n2 = n3 - nArray[0];
        } else {
            string2 = string3;
            n2 = 2;
        }
        SecurityIdentifier securityIdentifier = new SecurityIdentifier(string2);
        nArray[0] = nArray[0] + n2;
        return securityIdentifier;
    }

    private static byte[] a(String string) {
        String[] stringArray;
        String string2 = string;
        if (string.length() == 2) {
            stringArray = WellKnownAccount.g(string);
            if (stringArray == null) {
                throw new ArgumentException(StringExtensions.concat("Invalid SDDL string - unrecognized account: ", string), "sddlForm");
            }
            if (!stringArray.b()) {
                throw new NotImplementedException("Mono unable to convert account to SID: " + (stringArray.e() != null ? stringArray.e() : string));
            }
            string2 = stringArray.c();
        }
        stringArray = StringExtensions.split(StringExtensions.toUpperInvariant(string2), '-');
        int n2 = stringArray.length - 3;
        if (stringArray.length < 3 || !"S".equals(stringArray[0]) || n2 > 15) {
            throw new ArgumentException("Value was invalid.");
        }
        if (!"1".equals(stringArray[1])) {
            throw new ArgumentException("Only SIDs with revision 1 are supported");
        }
        byte[] byArray = new byte[8 + n2 * 4];
        byArray[0] = 1;
        byArray[1] = Operators.castToByte(n2, 9);
        long l2 = 0L;
        long[] lArray = new long[]{0L};
        boolean bl2 = !SecurityIdentifier.a(stringArray[2], lArray);
        l2 = lArray[0];
        if (bl2) {
            throw new ArgumentException("Value was invalid.");
        }
        byArray[2] = Operators.castToByte(l2 >> 40 & 0xFFL, 12);
        byArray[3] = Operators.castToByte(l2 >> 32 & 0xFFL, 12);
        byArray[4] = Operators.castToByte(l2 >> 24 & 0xFFL, 12);
        byArray[5] = Operators.castToByte(l2 >> 16 & 0xFFL, 12);
        byArray[6] = Operators.castToByte(l2 >> 8 & 0xFFL, 12);
        byArray[7] = Operators.castToByte(l2 >> 0 & 0xFFL, 12);
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = 0L;
            long[] lArray2 = new long[]{0L};
            boolean bl3 = !SecurityIdentifier.b(stringArray[i2 + 3], lArray2);
            l3 = lArray2[0];
            if (bl3) {
                throw new ArgumentException("Value was invalid.");
            }
            int n3 = 8 + i2 * 4;
            byArray[n3 + 0] = Operators.castToByte(Operators.castToUInt32(Operators.castToUInt32(l3, 10) >> 0, 10), 10);
            byArray[n3 + 1] = Operators.castToByte(Operators.castToUInt32(Operators.castToUInt32(l3, 10) >> 8, 10), 10);
            byArray[n3 + 2] = Operators.castToByte(Operators.castToUInt32(Operators.castToUInt32(l3, 10) >> 16, 10), 10);
            byArray[n3 + 3] = Operators.castToByte(Operators.castToUInt32(Operators.castToUInt32(l3, 10) >> 24, 10), 10);
        }
        return byArray;
    }

    private static boolean a(String string, long[] lArray) {
        if (StringExtensions.startsWith(string, "0X")) {
            return UInt64Extensions.tryParse(StringExtensions.substring(string, 2), 515, CultureInfo.getInvariantCulture(), lArray);
        }
        return UInt64Extensions.tryParse(string, 7, CultureInfo.getInvariantCulture(), lArray);
    }

    private static boolean b(String string, long[] lArray) {
        if (StringExtensions.startsWith(string, "0X")) {
            return UInt32Extensions.tryParse(StringExtensions.substring(string, 2), 515, CultureInfo.getInvariantCulture(), lArray);
        }
        return UInt32Extensions.tryParse(string, 7, CultureInfo.getInvariantCulture(), lArray);
    }
}

