/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.BaseIterator;
import com.aspose.html.internal.ms.System.Xml.Expression;
import com.aspose.html.internal.ms.System.Xml.NodeSet;
import com.aspose.html.internal.ms.System.Xml.SimpleSlashIterator;
import com.aspose.html.internal.ms.System.Xml.SlashIterator;
import com.aspose.html.internal.ms.System.Xml.SortedIterator;

class ExprSLASH
extends NodeSet {
    public Expression left;
    public NodeSet right;

    public ExprSLASH(Expression expression, NodeSet nodeSet) {
        this.left = expression;
        this.right = nodeSet;
    }

    @Override
    public Expression optimize() {
        this.left = this.left.optimize();
        this.right = (NodeSet)this.right.optimize();
        return this;
    }

    public String toString() {
        return StringExtensions.concat(this.left.toString(), "/", this.right.toString());
    }

    @Override
    public Object evaluate(BaseIterator baseIterator) {
        BaseIterator baseIterator2 = this.left.evaluateNodeSet(baseIterator);
        if (this.left.getPeer() && this.right.getSubtree()) {
            return new SimpleSlashIterator(baseIterator2, this.right);
        }
        SlashIterator slashIterator = new SlashIterator(baseIterator2, this.right);
        return new SortedIterator(slashIterator);
    }

    @Override
    public boolean getRequireSorting() {
        return this.left.getRequireSorting() || this.right.getRequireSorting();
    }

    @Override
    int getEvaluatedNodeType() {
        return this.right.getEvaluatedNodeType();
    }

    @Override
    boolean isPositional() {
        return this.left.isPositional() || this.right.isPositional();
    }

    @Override
    boolean getPeer() {
        return this.left.getPeer() && this.right.getPeer();
    }

    @Override
    boolean getSubtree() {
        NodeSet nodeSet = this.left instanceof NodeSet ? (NodeSet)this.left : null;
        return nodeSet != null && nodeSet.getSubtree() && this.right.getSubtree();
    }
}

