/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.BaseIterator;
import com.aspose.html.internal.ms.System.Xml.CompiledExpression;
import com.aspose.html.internal.ms.System.Xml.Expression;
import com.aspose.html.internal.ms.System.Xml.XPathException;
import com.aspose.html.internal.ms.System.Xml.XPathParser;
import java.util.Comparator;

class XPathSorter {
    Expression _expr;
    Comparator _cmp;
    int _type;

    public XPathSorter(Object object, Comparator comparator) {
        this._expr = XPathSorter.expressionFromObject(object);
        this._cmp = comparator;
        this._type = 1;
    }

    public XPathSorter(Object object, int n2, int n3, String string, int n4) {
        this._expr = XPathSorter.expressionFromObject(object);
        this._type = n4;
        this._cmp = n4 == 2 ? new XPathNumberComparer(n2) : new XPathTextComparer(n2, n3, string);
    }

    static Expression expressionFromObject(Object object) {
        if (object instanceof CompiledExpression) {
            return ((CompiledExpression)object).getExpressionNode();
        }
        if (object instanceof String) {
            return new XPathParser().compile((String)object);
        }
        throw new XPathException("Invalid query object");
    }

    public Object evaluate(BaseIterator baseIterator) {
        if (this._type == 2) {
            return this._expr.evaluateNumber(baseIterator);
        }
        return this._expr.evaluateString(baseIterator);
    }

    public int compare(Object object, Object object2) {
        return this._cmp.compare(object, object2);
    }

    private static class XPathTextComparer
    implements Comparator {
        private int a;
        private int b;
        private int c;
        private CultureInfo d;

        public XPathTextComparer(int n2, int n3, String string) {
            this.c = n3;
            this.b = n3 == 1 ? -1 : 1;
            this.a = n2 == 1 ? 1 : -1;
            this.d = string == null || "".equals(string) ? CultureInfo.getCurrentCulture() : new CultureInfo(string);
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            int n2 = StringExtensions.compare(string, string2, true, this.d);
            if (n2 != 0 || this.c == 0) {
                return n2 * this.a;
            }
            return this.a * this.b * StringExtensions.compare(string, string2, false, this.d);
        }
    }

    private static class XPathNumberComparer
    implements Comparator {
        private int a;

        public XPathNumberComparer(int n2) {
            this.a = n2 == 1 ? 1 : -1;
        }

        public int compare(Object object, Object object2) {
            double d2;
            double d3 = (Double)object;
            if (d3 < (d2 = ((Double)object2).doubleValue())) {
                return -this.a;
            }
            if (d3 > d2) {
                return this.a;
            }
            if (d3 == d2) {
                return 0;
            }
            if (Double.isNaN(d3)) {
                return Double.isNaN(d2) ? 0 : -this.a;
            }
            return this.a;
        }
    }
}

