/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.IHasXmlNode;
import com.aspose.html.internal.ms.System.Xml.IXmlSchemaInfo;
import com.aspose.html.internal.ms.System.Xml.XPathNavigator;
import com.aspose.html.internal.ms.System.Xml.XmlAttribute;
import com.aspose.html.internal.ms.System.Xml.XmlDocument;
import com.aspose.html.internal.ms.System.Xml.XmlElement;
import com.aspose.html.internal.ms.System.Xml.XmlNameTable;
import com.aspose.html.internal.ms.System.Xml.XmlNode;

class XmlDocumentNavigator
extends XPathNavigator
implements IHasXmlNode {
    private static final String a = "http://www.w3.org/2000/xmlns/";
    private static final String b = "http://www.w3.org/XML/1998/namespace";
    private XmlNode c;
    private XmlAttribute d;
    private ArrayList e;

    XmlDocumentNavigator(XmlNode xmlNode) {
        this.c = xmlNode;
        if (xmlNode.getNodeType() == 2 && a.equals(xmlNode.getNamespaceURI())) {
            this.d = (XmlAttribute)xmlNode;
            xmlNode = this.d.getOwnerElement();
        }
    }

    XmlDocument getDocument() {
        return this.c.getNodeType() == 9 ? (this.c instanceof XmlDocument ? (XmlDocument)this.c : null) : this.c.getOwnerDocument();
    }

    @Override
    public String getBaseURI() {
        return this.c.getBaseURI();
    }

    @Override
    public boolean hasAttributes() {
        XmlElement xmlElement;
        if (this.getNsNode() != null) {
            return false;
        }
        XmlElement xmlElement2 = xmlElement = this.c instanceof XmlElement ? (XmlElement)this.c : null;
        if (xmlElement == null || !xmlElement.hasAttributes()) {
            return false;
        }
        for (int i2 = 0; i2 < this.c.getAttributes().size(); ++i2) {
            if (a.equals(this.c.getAttributes().get_ItemOf(i2).getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChildren() {
        if (this.getNsNode() != null) {
            return false;
        }
        int n2 = this.getNodeType();
        boolean bl2 = n2 == 0 || n2 == 1;
        return bl2 && this.a(this.c) != null;
    }

    @Override
    public boolean isEmptyElement() {
        if (this.getNsNode() != null) {
            return false;
        }
        return this.c.getNodeType() == 1 && ((XmlElement)this.c).isEmpty();
    }

    public XmlAttribute getNsNode() {
        return this.d;
    }

    public void setNsNode(XmlAttribute xmlAttribute) {
        if (xmlAttribute == null) {
            this.e = null;
        } else {
            if (this.e == null) {
                this.e = new ArrayList();
            } else if (this.e.isReadOnly()) {
                this.e = new ArrayList(this.e);
            }
            this.e.addItem(xmlAttribute.getName());
        }
        this.d = xmlAttribute;
    }

    @Override
    public String getLocalName() {
        XmlAttribute xmlAttribute = this.getNsNode();
        if (xmlAttribute != null) {
            if (xmlAttribute == this.getDocument().getNsNodeXml()) {
                return "xml";
            }
            return "xmlns".equals(xmlAttribute.getName()) ? StringExtensions.Empty : xmlAttribute.getLocalName();
        }
        int n2 = this.getNodeType();
        boolean bl2 = n2 == 1 || n2 == 2 || n2 == 7 || n2 == 3;
        return bl2 ? this.c.getLocalName() : StringExtensions.Empty;
    }

    @Override
    public String getName() {
        if (this.getNsNode() != null) {
            return this.getLocalName();
        }
        int n2 = this.getNodeType();
        boolean bl2 = n2 == 1 || n2 == 2 || n2 == 7 || n2 == 3;
        return bl2 ? this.c.getName() : StringExtensions.Empty;
    }

    @Override
    public String getNamespaceURI() {
        return this.getNsNode() != null ? StringExtensions.Empty : this.c.getNamespaceURI();
    }

    @Override
    public XmlNameTable getNameTable() {
        return this.getDocument().getNameTable();
    }

    @Override
    public int getNodeType() {
        if (this.getNsNode() != null) {
            return 3;
        }
        XmlNode xmlNode = this.c;
        boolean bl2 = false;
        do {
            switch (xmlNode.getNodeType()) {
                case 14: {
                    bl2 = true;
                    xmlNode = this.d(xmlNode);
                    break;
                }
                case 13: {
                    xmlNode = this.d(xmlNode);
                    break;
                }
                case 3: 
                case 4: {
                    return 4;
                }
                default: {
                    xmlNode = null;
                }
            }
        } while (xmlNode != null);
        return bl2 ? 5 : this.c.getXPathNodeType();
    }

    @Override
    public String getPrefix() {
        return this.getNsNode() != null ? StringExtensions.Empty : this.c.getPrefix();
    }

    @Override
    public IXmlSchemaInfo getSchemaInfo() {
        return this.getNsNode() != null ? null : this.c.getSchemaInfo();
    }

    @Override
    public Object getUnderlyingObject() {
        return this.c;
    }

    @Override
    public String getValue() {
        switch (this.getNodeType()) {
            case 2: 
            case 7: 
            case 8: {
                return this.c.getValue();
            }
            case 4: 
            case 5: 
            case 6: {
                String string = this.c.getValue();
                XmlNode xmlNode = this.d(this.c);
                block9: while (xmlNode != null) {
                    switch (xmlNode.getXPathNodeType()) {
                        case 4: 
                        case 5: 
                        case 6: {
                            string = StringExtensions.plusEqOperator(string, xmlNode.getValue());
                            break;
                        }
                        default: {
                            break block9;
                        }
                    }
                    xmlNode = this.d(xmlNode);
                }
                return string;
            }
            case 0: 
            case 1: {
                return this.c.getInnerText();
            }
            case 3: {
                return this.getNsNode() == this.getDocument().getNsNodeXml() ? b : this.getNsNode().getValue();
            }
        }
        return StringExtensions.Empty;
    }

    @Override
    public String getXmlLang() {
        return this.c.getXmlLang();
    }

    private boolean a(String string, String string2) {
        if (this.e != null && this.e.contains(string)) {
            return true;
        }
        if (StringExtensions.equals(string2, StringExtensions.Empty)) {
            if (this.e == null) {
                this.e = new ArrayList();
            } else if (this.e.isReadOnly()) {
                this.e = new ArrayList(this.e);
            }
            this.e.addItem("xmlns");
            return true;
        }
        return false;
    }

    @Override
    public XPathNavigator deepClone() {
        XmlDocumentNavigator xmlDocumentNavigator = new XmlDocumentNavigator(this.c);
        xmlDocumentNavigator.d = this.d;
        xmlDocumentNavigator.e = this.e == null || this.e.isReadOnly() ? this.e : ArrayList.readOnly(this.e);
        return xmlDocumentNavigator;
    }

    @Override
    public String getAttribute(String string, String string2) {
        if (this.hasAttributes()) {
            XmlNode xmlNode = this.a();
            XmlElement xmlElement = xmlNode instanceof XmlElement ? (XmlElement)xmlNode : null;
            return xmlElement != null ? xmlElement.getAttribute(string, string2) : StringExtensions.Empty;
        }
        return StringExtensions.Empty;
    }

    @Override
    public String getNamespace(String string) {
        return this.a().getNamespaceOfPrefix(string);
    }

    @Override
    public boolean isDescendant(XPathNavigator xPathNavigator) {
        XmlNode xmlNode;
        XmlDocumentNavigator xmlDocumentNavigator;
        if (this.getNsNode() != null) {
            return false;
        }
        XmlDocumentNavigator xmlDocumentNavigator2 = xmlDocumentNavigator = xPathNavigator instanceof XmlDocumentNavigator ? (XmlDocumentNavigator)xPathNavigator : null;
        if (xmlDocumentNavigator == null) {
            return false;
        }
        XmlNode xmlNode2 = xmlNode = xmlDocumentNavigator.c.getNodeType() == 2 ? ((XmlAttribute)xmlDocumentNavigator.c).getOwnerElement() : xmlDocumentNavigator.c.getParentNode();
        while (xmlNode != null) {
            if (xmlNode == this.c) {
                return true;
            }
            xmlNode = xmlNode.getParentNode();
        }
        return false;
    }

    @Override
    public boolean isSamePosition(XPathNavigator xPathNavigator) {
        XmlDocumentNavigator xmlDocumentNavigator;
        XmlDocumentNavigator xmlDocumentNavigator2 = xmlDocumentNavigator = xPathNavigator instanceof XmlDocumentNavigator ? (XmlDocumentNavigator)xPathNavigator : null;
        if (xmlDocumentNavigator != null) {
            return this.c == xmlDocumentNavigator.c && this.getNsNode() == xmlDocumentNavigator.getNsNode();
        }
        return false;
    }

    @Override
    public boolean moveTo(XPathNavigator xPathNavigator) {
        XmlDocumentNavigator xmlDocumentNavigator;
        XmlDocumentNavigator xmlDocumentNavigator2 = xmlDocumentNavigator = xPathNavigator instanceof XmlDocumentNavigator ? (XmlDocumentNavigator)xPathNavigator : null;
        if (xmlDocumentNavigator != null && this.getDocument() == xmlDocumentNavigator.getDocument()) {
            this.c = xmlDocumentNavigator.c;
            this.setNsNode(xmlDocumentNavigator.getNsNode());
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToAttribute(String string, String string2) {
        XmlAttribute xmlAttribute;
        if (this.hasAttributes() && (xmlAttribute = this.c.getAttributes().get_ItemOf(string, string2)) != null) {
            this.c = xmlAttribute;
            this.setNsNode(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToFirstAttribute() {
        if (this.getNodeType() == 1) {
            XmlElement xmlElement;
            XmlElement xmlElement2 = xmlElement = this.c instanceof XmlElement ? (XmlElement)this.c : null;
            if (!xmlElement.hasAttributes()) {
                return false;
            }
            for (int i2 = 0; i2 < this.c.getAttributes().size(); ++i2) {
                XmlAttribute xmlAttribute = this.c.getAttributes().get_ItemOf(i2);
                if (a.equals(xmlAttribute.getNamespaceURI())) continue;
                this.c = xmlAttribute;
                this.setNsNode(null);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean moveToFirstChild() {
        if (this.hasChildren()) {
            XmlNode xmlNode = this.a(this.c);
            if (xmlNode == null) {
                return false;
            }
            this.c = xmlNode;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToFirstNamespace(int n2) {
        XmlNode xmlNode;
        XmlElement xmlElement;
        if (this.getNodeType() != 1) {
            return false;
        }
        XmlElement xmlElement2 = xmlElement = this.c instanceof XmlElement ? (XmlElement)this.c : null;
        do {
            if (xmlElement.hasAttributes()) {
                for (int i2 = 0; i2 < xmlElement.getAttributes().size(); ++i2) {
                    XmlAttribute xmlAttribute = xmlElement.getAttributes().get_ItemOf(i2);
                    if (!a.equals(xmlAttribute.getNamespaceURI()) || this.a(xmlAttribute.getName(), xmlAttribute.getValue())) continue;
                    this.setNsNode(xmlAttribute);
                    return true;
                }
            }
            if (n2 != 2) continue;
            return false;
        } while ((xmlElement = (xmlNode = this.e(xmlElement)) instanceof XmlElement ? (XmlElement)xmlNode : null) != null);
        if (n2 == 0) {
            if (this.a(this.getDocument().getNsNodeXml().getName(), this.getDocument().getNsNodeXml().getValue())) {
                return false;
            }
            this.setNsNode(this.getDocument().getNsNodeXml());
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToId(String string) {
        XmlElement xmlElement = this.getDocument().getElementById(string);
        if (xmlElement == null) {
            return false;
        }
        this.c = xmlElement;
        return true;
    }

    @Override
    public boolean moveToNamespace(String string) {
        XmlNode xmlNode;
        XmlElement xmlElement;
        if ("xml".equals(string)) {
            this.setNsNode(this.getDocument().getNsNodeXml());
            return true;
        }
        if (this.getNodeType() != 1) {
            return false;
        }
        XmlElement xmlElement2 = xmlElement = this.c instanceof XmlElement ? (XmlElement)this.c : null;
        do {
            if (!xmlElement.hasAttributes()) continue;
            for (int i2 = 0; i2 < xmlElement.getAttributes().size(); ++i2) {
                XmlAttribute xmlAttribute = xmlElement.getAttributes().get_ItemOf(i2);
                if (!a.equals(xmlAttribute.getNamespaceURI()) || !StringExtensions.equals(xmlAttribute.getName(), string)) continue;
                this.setNsNode(xmlAttribute);
                return true;
            }
        } while ((xmlElement = (xmlNode = this.e(this.c)) instanceof XmlElement ? (XmlElement)xmlNode : null) != null);
        return false;
    }

    @Override
    public boolean moveToNext() {
        if (this.getNsNode() != null) {
            return false;
        }
        XmlNode xmlNode = this.c;
        if (this.getNodeType() == 4) {
            block3: while (true) {
                if ((xmlNode = this.d(xmlNode)) == null) {
                    return false;
                }
                switch (xmlNode.getNodeType()) {
                    case 3: 
                    case 4: 
                    case 13: 
                    case 14: {
                        continue block3;
                    }
                }
                break;
            }
        } else {
            xmlNode = this.d(xmlNode);
        }
        if (xmlNode == null) {
            return false;
        }
        this.c = xmlNode;
        return true;
    }

    @Override
    public boolean moveToNextAttribute() {
        int n2;
        if (this.c == null) {
            return false;
        }
        if (this.getNodeType() != 2) {
            return false;
        }
        XmlElement xmlElement = ((XmlAttribute)this.c).getOwnerElement();
        if (xmlElement == null) {
            return false;
        }
        int n3 = xmlElement.getAttributes().size();
        for (n2 = 0; n2 < n3 && xmlElement.getAttributes().get_ItemOf(n2) != this.c; ++n2) {
        }
        if (n2 == n3) {
            return false;
        }
        ++n2;
        while (n2 < n3) {
            if (!a.equals(xmlElement.getAttributes().get_ItemOf(n2).getNamespaceURI())) {
                this.c = xmlElement.getAttributes().get_ItemOf(n2);
                this.setNsNode(null);
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean moveToNextNamespace(int n2) {
        XmlNode xmlNode;
        int n3;
        if (this.getNsNode() == this.getDocument().getNsNodeXml()) {
            return false;
        }
        if (this.getNsNode() == null) {
            return false;
        }
        XmlElement xmlElement = this.getNsNode().getOwnerElement();
        if (xmlElement == null) {
            return false;
        }
        int n4 = xmlElement.getAttributes().size();
        for (n3 = 0; n3 < n4 && xmlElement.getAttributes().get_ItemOf(n3) != this.getNsNode(); ++n3) {
        }
        if (n3 == n4) {
            return false;
        }
        ++n3;
        while (n3 < n4) {
            if (a.equals(xmlElement.getAttributes().get_ItemOf(n3).getNamespaceURI()) && !this.a(((XmlAttribute)(xmlNode = xmlElement.getAttributes().get_ItemOf(n3))).getName(), ((XmlAttribute)xmlNode).getValue())) {
                this.setNsNode((XmlAttribute)xmlNode);
                return true;
            }
            ++n3;
        }
        if (n2 == 2) {
            return false;
        }
        xmlNode = this.e(xmlElement);
        XmlElement xmlElement2 = xmlElement = xmlNode instanceof XmlElement ? (XmlElement)xmlNode : null;
        while (xmlElement != null) {
            XmlNode xmlNode2;
            if (xmlElement.hasAttributes()) {
                for (int i2 = 0; i2 < xmlElement.getAttributes().size(); ++i2) {
                    XmlAttribute xmlAttribute = xmlElement.getAttributes().get_ItemOf(i2);
                    if (!a.equals(xmlAttribute.getNamespaceURI()) || this.a(xmlAttribute.getName(), xmlAttribute.getValue())) continue;
                    this.setNsNode(xmlAttribute);
                    return true;
                }
            }
            xmlElement = (xmlNode2 = this.e(xmlElement)) instanceof XmlElement ? (XmlElement)xmlNode2 : null;
        }
        if (n2 == 0) {
            if (this.a(this.getDocument().getNsNodeXml().getName(), this.getDocument().getNsNodeXml().getValue())) {
                return false;
            }
            this.setNsNode(this.getDocument().getNsNodeXml());
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToParent() {
        if (this.getNsNode() != null) {
            this.setNsNode(null);
            return true;
        }
        if (this.c.getNodeType() == 2) {
            XmlElement xmlElement = ((XmlAttribute)this.c).getOwnerElement();
            if (xmlElement != null) {
                this.c = xmlElement;
                this.setNsNode(null);
                return true;
            }
            return false;
        }
        XmlNode xmlNode = this.e(this.c);
        if (xmlNode == null) {
            return false;
        }
        this.c = xmlNode;
        this.setNsNode(null);
        return true;
    }

    @Override
    public boolean moveToPrevious() {
        if (this.getNsNode() != null) {
            return false;
        }
        XmlNode xmlNode = this.c(this.c);
        if (xmlNode == null) {
            return false;
        }
        this.c = xmlNode;
        return true;
    }

    @Override
    public void moveToRoot() {
        XmlNode xmlNode;
        XmlAttribute xmlAttribute = this.c instanceof XmlAttribute ? (XmlAttribute)this.c : null;
        XmlNode xmlNode2 = xmlNode = xmlAttribute != null ? xmlAttribute.getOwnerElement() : this.c;
        if (xmlNode == null) {
            return;
        }
        XmlNode xmlNode3 = this.e(xmlNode);
        while (xmlNode3 != null) {
            xmlNode = xmlNode3;
            xmlNode3 = this.e(xmlNode3);
        }
        this.c = xmlNode;
        this.setNsNode(null);
    }

    private XmlNode a() {
        return this.getNsNode() != null ? this.getNsNode() : this.c;
    }

    @Override
    public XmlNode getNode() {
        return this.a();
    }

    private XmlNode a(XmlNode xmlNode) {
        if (xmlNode.getFirstChild() == null) {
            return null;
        }
        switch (xmlNode.getFirstChild().getNodeType()) {
            case 10: 
            case 17: {
                return this.d(xmlNode.getFirstChild());
            }
            case 5: {
                for (XmlNode xmlNode2 : xmlNode.getChildNodes()) {
                    if (xmlNode2.getNodeType() == 5) {
                        XmlNode xmlNode3 = this.a(xmlNode2);
                        if (xmlNode3 == null) continue;
                        return xmlNode3;
                    }
                    return xmlNode2;
                }
                return null;
            }
        }
        return xmlNode.getFirstChild();
    }

    private XmlNode b(XmlNode xmlNode) {
        if (xmlNode.getLastChild() == null) {
            return null;
        }
        switch (xmlNode.getLastChild().getNodeType()) {
            case 10: 
            case 17: {
                return this.c(xmlNode.getLastChild());
            }
            case 5: {
                for (XmlNode xmlNode2 = xmlNode.getLastChild(); xmlNode2 != null; xmlNode2 = xmlNode2.getPreviousSibling()) {
                    if (xmlNode2.getNodeType() == 5) {
                        XmlNode xmlNode3 = this.b(xmlNode2);
                        if (xmlNode3 == null) continue;
                        return xmlNode3;
                    }
                    return xmlNode2;
                }
                return null;
            }
        }
        return xmlNode.getLastChild();
    }

    private XmlNode c(XmlNode xmlNode) {
        XmlNode xmlNode2 = xmlNode.getPreviousSibling();
        if (xmlNode2 != null) {
            switch (xmlNode2.getNodeType()) {
                case 5: {
                    XmlNode xmlNode3 = this.b(xmlNode2);
                    if (xmlNode3 != null) {
                        return xmlNode3;
                    }
                    return this.c(xmlNode2);
                }
                case 10: 
                case 17: {
                    return this.c(xmlNode2);
                }
            }
            return xmlNode2;
        }
        if (xmlNode.getParentNode() == null || xmlNode.getParentNode().getNodeType() != 5) {
            return null;
        }
        return this.c(xmlNode.getParentNode());
    }

    private XmlNode d(XmlNode xmlNode) {
        XmlNode xmlNode2 = xmlNode.getNextSibling();
        if (xmlNode2 != null) {
            switch (xmlNode2.getNodeType()) {
                case 5: {
                    XmlNode xmlNode3 = this.a(xmlNode2);
                    if (xmlNode3 != null) {
                        return xmlNode3;
                    }
                    return this.d(xmlNode2);
                }
                case 10: 
                case 17: {
                    return this.d(xmlNode2);
                }
            }
            return xmlNode.getNextSibling();
        }
        if (xmlNode.getParentNode() == null || xmlNode.getParentNode().getNodeType() != 5) {
            return null;
        }
        return this.d(xmlNode.getParentNode());
    }

    private XmlNode e(XmlNode xmlNode) {
        if (xmlNode.getParentNode() == null) {
            return null;
        }
        for (XmlNode xmlNode2 = xmlNode.getParentNode(); xmlNode2 != null; xmlNode2 = xmlNode2.getParentNode()) {
            if (xmlNode2.getNodeType() == 5) continue;
            return xmlNode2;
        }
        return null;
    }

    @Override
    public String lookupNamespace(String string) {
        return super.lookupNamespace(string);
    }

    @Override
    public String lookupPrefix(String string) {
        return super.lookupPrefix(string);
    }

    @Override
    public boolean moveToChild(int n2) {
        return super.moveToChild(n2);
    }

    @Override
    public boolean moveToChild(String string, String string2) {
        return super.moveToChild(string, string2);
    }

    @Override
    public boolean moveToNext(String string, String string2) {
        return super.moveToNext(string, string2);
    }

    @Override
    public boolean moveToNext(int n2) {
        return super.moveToNext(n2);
    }

    @Override
    public boolean moveToFollowing(String string, String string2, XPathNavigator xPathNavigator) {
        return super.moveToFollowing(string, string2, xPathNavigator);
    }

    @Override
    public boolean moveToFollowing(int n2, XPathNavigator xPathNavigator) {
        return super.moveToFollowing(n2, xPathNavigator);
    }
}

