/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlSchema;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAll;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAnnotation;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaException;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaGroup;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaGroupBase;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObject;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObjectTable;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaParticle;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaReader;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaUtil;

public class XmlSchemaGroupRef
extends XmlSchemaParticle {
    private XmlSchema a;
    private XmlQualifiedName b = XmlQualifiedName.Empty;
    private static final String c = "group";
    private XmlSchemaGroup d;
    private boolean e;

    public XmlQualifiedName getRefName() {
        return this.b;
    }

    public void setRefName(XmlQualifiedName xmlQualifiedName) {
        this.b = xmlQualifiedName;
    }

    public XmlSchemaGroupBase getParticle() {
        if (this.getTargetGroup() != null) {
            return this.getTargetGroup().getParticle();
        }
        return null;
    }

    XmlSchemaGroup getTargetGroup() {
        if (this.d != null && this.d.isCircularDefinition()) {
            return null;
        }
        return this.d;
    }

    @Override
    int compile(ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        if (Guid.op_Equality(this.getCompilationId(), xmlSchema.getCompilationId())) {
            return 0;
        }
        this.a = xmlSchema;
        XmlSchemaUtil.compileID(this.getId(), this, xmlSchema.getIDCollection(), validationEventHandler);
        this.compileOccurence(validationEventHandler, xmlSchema);
        if (this.b == null || this.b.isEmpty()) {
            this.error(validationEventHandler, "ref must be present");
        } else if (!XmlSchemaUtil.checkQName(this.getRefName())) {
            this.error(validationEventHandler, "RefName must be a valid XmlQualifiedName");
        }
        this.setCompilationId(xmlSchema.getCompilationId().Clone());
        return this.errorCount;
    }

    @Override
    int validate(ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        if (this.isValidated(xmlSchema.ValidationId.Clone())) {
            return this.errorCount;
        }
        XmlSchemaObject xmlSchemaObject = xmlSchema.getGroups().get_Item(this.getRefName());
        XmlSchemaGroup xmlSchemaGroup = this.d = xmlSchemaObject instanceof XmlSchemaGroup ? (XmlSchemaGroup)xmlSchemaObject : null;
        if (this.d == null) {
            if (!xmlSchema.isNamespaceAbsent(this.getRefName().getNamespace())) {
                this.error(validationEventHandler, StringExtensions.concat("Referenced group ", this.getRefName(), " was not found in the corresponding schema."));
            }
        } else if (this.d.getParticle() instanceof XmlSchemaAll && Decimal.op_Inequality(this.getValidatedMaxOccurs(), Decimal.newDecimalFromInt(1))) {
            this.error(validationEventHandler, "Group reference to -all- particle must have schema component {maxOccurs}=1.");
        }
        if (this.getTargetGroup() != null) {
            this.getTargetGroup().validate(validationEventHandler, xmlSchema);
        }
        xmlSchema.ValidationId.CloneTo(this.ValidationId);
        return this.errorCount;
    }

    @Override
    XmlSchemaParticle getOptimizedParticle(boolean bl2) {
        if (this.e) {
            return XmlSchemaParticle.getEmpty();
        }
        if (this.OptimizedParticle != null) {
            return this.OptimizedParticle;
        }
        this.e = true;
        XmlSchemaGroup xmlSchemaGroup = this.d;
        if (xmlSchemaGroup == null) {
            XmlSchemaObject xmlSchemaObject = this.a.getGroups().get_Item(this.getRefName());
            XmlSchemaGroup xmlSchemaGroup2 = xmlSchemaGroup = xmlSchemaObject instanceof XmlSchemaGroup ? (XmlSchemaGroup)xmlSchemaObject : null;
        }
        if (xmlSchemaGroup != null && xmlSchemaGroup.getParticle() != null) {
            this.OptimizedParticle = xmlSchemaGroup.getParticle();
            this.OptimizedParticle = this.OptimizedParticle.getOptimizedParticle(bl2);
            if (this.OptimizedParticle != XmlSchemaParticle.getEmpty() && (Decimal.op_Inequality(this.getValidatedMinOccurs(), Decimal.newDecimalFromInt(1)) || Decimal.op_Inequality(this.getValidatedMaxOccurs(), Decimal.newDecimalFromInt(1)))) {
                this.OptimizedParticle = this.OptimizedParticle.getShallowClone();
                this.OptimizedParticle.OptimizedParticle = null;
                this.OptimizedParticle.setMinOccurs(this.getMinOccurs());
                this.OptimizedParticle.setMaxOccurs(this.getMaxOccurs());
                this.OptimizedParticle.compileOccurence(null, null);
            }
        } else {
            this.OptimizedParticle = XmlSchemaParticle.getEmpty();
        }
        this.e = false;
        return this.OptimizedParticle;
    }

    @Override
    boolean particleEquals(XmlSchemaParticle xmlSchemaParticle) {
        return this.getOptimizedParticle(true).particleEquals(xmlSchemaParticle);
    }

    @Override
    boolean validateDerivationByRestriction(XmlSchemaParticle xmlSchemaParticle, ValidationEventHandler validationEventHandler, XmlSchema xmlSchema, boolean bl2) {
        if (this.getTargetGroup() != null) {
            return this.getTargetGroup().getParticle().validateDerivationByRestriction(xmlSchemaParticle, validationEventHandler, xmlSchema, bl2);
        }
        return false;
    }

    @Override
    void checkRecursion(int n2, ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        if (this.getTargetGroup() == null) {
            return;
        }
        if (this.recursionDepth == -1) {
            this.recursionDepth = n2;
            this.getTargetGroup().getParticle().checkRecursion(n2, validationEventHandler, xmlSchema);
            this.recursionDepth = -2;
        } else if (n2 == this.recursionDepth) {
            throw new XmlSchemaException("Circular group reference was found.", this, null);
        }
    }

    @Override
    void validateUniqueParticleAttribution(XmlSchemaObjectTable xmlSchemaObjectTable, ArrayList arrayList, ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        if (this.getTargetGroup() != null) {
            this.getTargetGroup().getParticle().validateUniqueParticleAttribution(xmlSchemaObjectTable, arrayList, validationEventHandler, xmlSchema);
        }
    }

    @Override
    void validateUniqueTypeAttribution(XmlSchemaObjectTable xmlSchemaObjectTable, ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        if (this.getTargetGroup() != null) {
            this.getTargetGroup().getParticle().validateUniqueTypeAttribution(xmlSchemaObjectTable, validationEventHandler, xmlSchema);
        }
    }

    static XmlSchemaGroupRef read(XmlSchemaReader xmlSchemaReader, ValidationEventHandler validationEventHandler) {
        Object object;
        XmlSchemaGroupRef xmlSchemaGroupRef = new XmlSchemaGroupRef();
        xmlSchemaReader.moveToElement();
        if (!"http://www.w3.org/2001/XMLSchema".equals(xmlSchemaReader.getNamespaceURI()) || !c.equals(xmlSchemaReader.getLocalName())) {
            XmlSchemaGroupRef.error(validationEventHandler, StringExtensions.concat("Should not happen :1: XmlSchemaGroup.Read, name=", xmlSchemaReader.getName()), null);
            xmlSchemaReader.skip();
            return null;
        }
        xmlSchemaGroupRef.setLineNumber(xmlSchemaReader.getLineNumber());
        xmlSchemaGroupRef.setLinePosition(xmlSchemaReader.getLinePosition());
        xmlSchemaGroupRef.setSourceUri(xmlSchemaReader.getBaseURI());
        while (xmlSchemaReader.moveToNextAttribute()) {
            if ("id".equals(xmlSchemaReader.getName())) {
                xmlSchemaGroupRef.setId(xmlSchemaReader.getValue());
                continue;
            }
            if ("ref".equals(xmlSchemaReader.getName())) {
                Exception exception = null;
                object = new Exception[]{exception};
                xmlSchemaGroupRef.b = XmlSchemaUtil.readQNameAttribute(xmlSchemaReader, object);
                exception = object[0];
                if (exception == null) continue;
                XmlSchemaGroupRef.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getValue(), " is not a valid value for ref attribute"), exception);
                continue;
            }
            if ("maxOccurs".equals(xmlSchemaReader.getName())) {
                try {
                    xmlSchemaGroupRef.setMaxOccursString(xmlSchemaReader.getValue());
                }
                catch (Exception exception) {
                    XmlSchemaGroupRef.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getValue(), " is an invalid value for maxOccurs"), exception);
                }
                continue;
            }
            if ("minOccurs".equals(xmlSchemaReader.getName())) {
                try {
                    xmlSchemaGroupRef.setMinOccursString(xmlSchemaReader.getValue());
                }
                catch (Exception exception) {
                    XmlSchemaGroupRef.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getValue(), " is an invalid value for minOccurs"), exception);
                }
                continue;
            }
            if ("".equals(xmlSchemaReader.getNamespaceURI()) && !"xmlns".equals(xmlSchemaReader.getName()) || "http://www.w3.org/2001/XMLSchema".equals(xmlSchemaReader.getNamespaceURI())) {
                XmlSchemaGroupRef.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getName(), " is not a valid attribute for group"), null);
                continue;
            }
            XmlSchemaUtil.readUnhandledAttribute(xmlSchemaReader, xmlSchemaGroupRef);
        }
        xmlSchemaReader.moveToElement();
        if (xmlSchemaReader.isEmptyElement()) {
            return xmlSchemaGroupRef;
        }
        int n2 = 1;
        while (xmlSchemaReader.readNextElement()) {
            if (xmlSchemaReader.getNodeType() == 15) {
                if (c.equals(xmlSchemaReader.getLocalName())) break;
                XmlSchemaGroupRef.error(validationEventHandler, StringExtensions.concat("Should not happen :2: XmlSchemaGroupRef.Read, name=", xmlSchemaReader.getName()), null);
                break;
            }
            if (n2 <= 1 && "annotation".equals(xmlSchemaReader.getLocalName())) {
                n2 = 2;
                object = XmlSchemaAnnotation.read(xmlSchemaReader, validationEventHandler);
                if (object == null) continue;
                xmlSchemaGroupRef.setAnnotation((XmlSchemaAnnotation)object);
                continue;
            }
            xmlSchemaReader.raiseInvalidElementError();
        }
        return xmlSchemaGroupRef;
    }
}

