/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Guid;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.internal.ms.System.Xml.XmlQualifiedName;
import com.aspose.html.internal.ms.System.Xml.XmlSchema;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaAnnotation;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaComplexType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaDatatype;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObject;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaObjectCollection;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaReader;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaSimpleType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaSimpleTypeContent;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaType;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaUtil;

public class XmlSchemaSimpleTypeUnion
extends XmlSchemaSimpleTypeContent {
    private XmlSchemaObjectCollection a = new XmlSchemaObjectCollection();
    private XmlQualifiedName[] b;
    private static final String c = "union";
    private Object[] d;
    private XmlSchemaSimpleType[] e;

    public XmlSchemaObjectCollection getBaseTypes() {
        return this.a;
    }

    public XmlQualifiedName[] getMemberTypes() {
        return this.b;
    }

    public void setMemberTypes(XmlQualifiedName[] xmlQualifiedNameArray) {
        this.b = xmlQualifiedNameArray;
    }

    public XmlSchemaSimpleType[] getBaseMemberTypes() {
        return this.e;
    }

    Object[] getValidatedTypes() {
        return this.d;
    }

    @Override
    void setParent(XmlSchemaObject xmlSchemaObject) {
        super.setParent(xmlSchemaObject);
        for (XmlSchemaObject xmlSchemaObject2 : this.getBaseTypes()) {
            xmlSchemaObject2.setParent(this);
        }
    }

    @Override
    int compile(ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        if (Guid.op_Equality(this.getCompilationId(), xmlSchema.getCompilationId())) {
            return 0;
        }
        this.errorCount = 0;
        int n2 = this.getBaseTypes().size();
        for (XmlSchemaObject xmlSchemaObject : this.a) {
            if (xmlSchemaObject != null && xmlSchemaObject instanceof XmlSchemaSimpleType) {
                XmlSchemaSimpleType xmlSchemaSimpleType = (XmlSchemaSimpleType)xmlSchemaObject;
                this.errorCount += xmlSchemaSimpleType.compile(validationEventHandler, xmlSchema);
                continue;
            }
            this.error(validationEventHandler, "baseTypes can't have objects other than a simpletype");
        }
        if (this.b != null) {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                if (this.b[i2] == null || !XmlSchemaUtil.checkQName(this.getMemberTypes()[i2])) {
                    this.error(validationEventHandler, "Invalid membertype");
                    this.b[i2] = XmlQualifiedName.Empty;
                    continue;
                }
                n2 += this.getMemberTypes().length;
            }
        }
        if (n2 == 0) {
            this.error(validationEventHandler, "Atleast one simpletype or membertype must be present");
        }
        XmlSchemaUtil.compileID(this.getId(), this, xmlSchema.getIDCollection(), validationEventHandler);
        this.setCompilationId(xmlSchema.getCompilationId().Clone());
        return this.errorCount;
    }

    @Override
    int validate(ValidationEventHandler validationEventHandler, XmlSchema xmlSchema) {
        if (this.isValidated(xmlSchema.ValidationId.Clone())) {
            return this.errorCount;
        }
        ArrayList arrayList = new ArrayList();
        if (this.getMemberTypes() != null) {
            for (XmlQualifiedName xmlQualifiedName : this.getMemberTypes()) {
                XmlSchemaSimpleType xmlSchemaSimpleType;
                Object object = null;
                XmlSchemaType xmlSchemaType = xmlSchema.findSchemaType(xmlQualifiedName);
                XmlSchemaSimpleType xmlSchemaSimpleType2 = xmlSchemaSimpleType = xmlSchemaType instanceof XmlSchemaSimpleType ? (XmlSchemaSimpleType)xmlSchemaType : null;
                if (xmlSchemaSimpleType != null) {
                    this.errorCount += ((XmlSchemaObject)xmlSchemaSimpleType).validate(validationEventHandler, xmlSchema);
                    object = xmlSchemaSimpleType;
                } else if (XmlQualifiedName.op_Equality(xmlQualifiedName, XmlSchemaComplexType.AnyTypeName)) {
                    object = XmlSchemaSimpleType.getAnySimpleType();
                } else if ("http://www.w3.org/2001/XMLSchema".equals(xmlQualifiedName.getNamespace()) || "http://www.w3.org/2003/11/xpath-datatypes".equals(xmlQualifiedName.getNamespace())) {
                    object = XmlSchemaDatatype.fromName(xmlQualifiedName);
                    if (object == null) {
                        this.error(validationEventHandler, "Invalid schema type name was specified: " + xmlQualifiedName);
                    }
                } else if (!xmlSchema.isNamespaceAbsent(xmlQualifiedName.getNamespace())) {
                    this.error(validationEventHandler, StringExtensions.concat("Referenced base schema type ", xmlQualifiedName, " was not found in the corresponding schema."));
                }
                arrayList.addItem(object);
            }
        }
        if (this.getBaseTypes() != null) {
            for (XmlSchemaSimpleType xmlSchemaSimpleType : this.getBaseTypes()) {
                xmlSchemaSimpleType.validate(validationEventHandler, xmlSchema);
                arrayList.addItem(xmlSchemaSimpleType);
            }
        }
        this.d = arrayList.toArray();
        if (this.d != null) {
            this.e = new XmlSchemaSimpleType[this.d.length];
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                XmlSchemaSimpleType xmlSchemaSimpleType;
                Object object = this.d[i2];
                XmlSchemaSimpleType xmlSchemaSimpleType3 = xmlSchemaSimpleType = object instanceof XmlSchemaSimpleType ? (XmlSchemaSimpleType)object : null;
                if (xmlSchemaSimpleType == null && object != null) {
                    xmlSchemaSimpleType = XmlSchemaType.getBuiltInSimpleType(((XmlSchemaDatatype)object).getTypeCode());
                }
                this.e[i2] = xmlSchemaSimpleType;
            }
        }
        xmlSchema.ValidationId.CloneTo(this.ValidationId);
        return this.errorCount;
    }

    static XmlSchemaSimpleTypeUnion read(XmlSchemaReader xmlSchemaReader, ValidationEventHandler validationEventHandler) {
        Object object;
        XmlSchemaSimpleTypeUnion xmlSchemaSimpleTypeUnion = new XmlSchemaSimpleTypeUnion();
        xmlSchemaReader.moveToElement();
        if (!"http://www.w3.org/2001/XMLSchema".equals(xmlSchemaReader.getNamespaceURI()) || !c.equals(xmlSchemaReader.getLocalName())) {
            XmlSchemaSimpleTypeUnion.error(validationEventHandler, StringExtensions.concat("Should not happen :1: XmlSchemaSimpleTypeUnion.Read, name=", xmlSchemaReader.getName()), null);
            xmlSchemaReader.skip();
            return null;
        }
        xmlSchemaSimpleTypeUnion.setLineNumber(xmlSchemaReader.getLineNumber());
        xmlSchemaSimpleTypeUnion.setLinePosition(xmlSchemaReader.getLinePosition());
        xmlSchemaSimpleTypeUnion.setSourceUri(xmlSchemaReader.getBaseURI());
        while (xmlSchemaReader.moveToNextAttribute()) {
            if ("id".equals(xmlSchemaReader.getName())) {
                xmlSchemaSimpleTypeUnion.setId(xmlSchemaReader.getValue());
                continue;
            }
            if ("memberTypes".equals(xmlSchemaReader.getName())) {
                Exception exception = null;
                object = XmlSchemaUtil.splitList(xmlSchemaReader.getValue());
                xmlSchemaSimpleTypeUnion.b = new XmlQualifiedName[((String[])object).length];
                for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                    Exception[] exceptionArray = new Exception[]{exception};
                    xmlSchemaSimpleTypeUnion.b[i2] = XmlSchemaUtil.toQName(xmlSchemaReader, object[i2], exceptionArray);
                    exception = exceptionArray[0];
                    if (exception == null) continue;
                    XmlSchemaSimpleTypeUnion.error(validationEventHandler, StringExtensions.concat("'", object[i2], "' is not a valid memberType"), exception);
                }
                continue;
            }
            if ("".equals(xmlSchemaReader.getNamespaceURI()) && !"xmlns".equals(xmlSchemaReader.getName()) || "http://www.w3.org/2001/XMLSchema".equals(xmlSchemaReader.getNamespaceURI())) {
                XmlSchemaSimpleTypeUnion.error(validationEventHandler, StringExtensions.concat(xmlSchemaReader.getName(), " is not a valid attribute for union"), null);
                continue;
            }
            XmlSchemaUtil.readUnhandledAttribute(xmlSchemaReader, xmlSchemaSimpleTypeUnion);
        }
        xmlSchemaReader.moveToElement();
        if (xmlSchemaReader.isEmptyElement()) {
            return xmlSchemaSimpleTypeUnion;
        }
        int n2 = 1;
        while (xmlSchemaReader.readNextElement()) {
            if (xmlSchemaReader.getNodeType() == 15) {
                if (c.equals(xmlSchemaReader.getLocalName())) break;
                XmlSchemaSimpleTypeUnion.error(validationEventHandler, StringExtensions.concat("Should not happen :2: XmlSchemaSimpleTypeUnion.Read, name=", xmlSchemaReader.getName()), null);
                break;
            }
            if (n2 <= 1 && "annotation".equals(xmlSchemaReader.getLocalName())) {
                n2 = 2;
                object = XmlSchemaAnnotation.read(xmlSchemaReader, validationEventHandler);
                if (object == null) continue;
                xmlSchemaSimpleTypeUnion.setAnnotation((XmlSchemaAnnotation)object);
                continue;
            }
            if (n2 <= 2 && "simpleType".equals(xmlSchemaReader.getLocalName())) {
                n2 = 2;
                object = XmlSchemaSimpleType.read(xmlSchemaReader, validationEventHandler);
                if (object == null) continue;
                xmlSchemaSimpleTypeUnion.a.add((XmlSchemaObject)object);
                continue;
            }
            xmlSchemaReader.raiseInvalidElementError();
        }
        return xmlSchemaSimpleTypeUnion;
    }
}

