/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing;

import com.aspose.html.drawing.Color;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Drawing.Bitmap;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.Image;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.SizeF;
import com.aspose.html.internal.ms.System.Exception;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;

public class GraphicsUtils {
    private static final double[] a = new double[]{1.0, 1.0, 1.0, (double)GraphicsUtils.getDefaultScreenResolution() / 72.0, GraphicsUtils.getDefaultScreenResolution(), (double)GraphicsUtils.getDefaultScreenResolution() / 300.0, (double)GraphicsUtils.getDefaultScreenResolution() / (double)25.4f};
    private static int b;
    private static float c;
    private static float d;

    public static boolean unitPixelOrDisplay(int n2) {
        return n2 == 1 || n2 == 2 || n2 == 0;
    }

    public static int compareDpi(float f2, float f3) {
        return GraphicsUtils.compareFloat(f2, f3, 0.03f);
    }

    public static int compareFloat(double d2, double d3) {
        return GraphicsUtils.compareFloat(d2, d3, 0.005f);
    }

    public static int compareFloat(double d2, double d3, float f2) {
        double d4 = d2 - d3;
        return Math.abs(d4) < (double)f2 ? 0 : (int)Math.signum(d4);
    }

    public static float roundFloat(double d2) {
        return GraphicsUtils.roundFloat(d2, 8);
    }

    public static float roundFloat(double d2, int n2) {
        double d3 = d2;
        if (n2 > 0 && n2 <= 8 && Math.abs(d2) < 1.0E7) {
            double d4 = (long)Math.pow(10.0, n2);
            d3 = (double)Math.round(d3 * d4) / d4;
        }
        return (float)d3;
    }

    public static int getDefaultScreenResolution() {
        return 96;
    }

    public static Dimension getScreenSize() {
        return GraphicsUtils.isHeadless() ? new Dimension(800, 600) : Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static boolean isHeadless() {
        if (b == 0) {
            boolean bl2 = GraphicsEnvironment.isHeadless();
            if (!bl2) {
                try {
                    Toolkit.getDefaultToolkit();
                }
                catch (Exception exception) {
                    bl2 = true;
                }
            }
            b = bl2 ? 2 : 1;
        }
        return b > 1;
    }

    public static double[] getUnitConversion() {
        return a;
    }

    public static float unitConversion(int n2, int n3, float f2) {
        double d2 = 0.0;
        double d3 = 0.0;
        switch (n2) {
            case 1: {
                d2 = f2 / GraphicsUtils.getSystemDpiY();
                break;
            }
            case 5: {
                d2 = f2 / 300.0f;
                break;
            }
            case 4: {
                d2 = f2;
                break;
            }
            case 6: {
                d2 = f2 / 25.4f;
                break;
            }
            case 0: 
            case 2: {
                d2 = f2 / GraphicsUtils.getSystemDpiY();
                break;
            }
            case 3: {
                d2 = f2 / 72.0f;
                break;
            }
            default: {
                throw new ArgumentException("Invalid GraphicsUnit");
            }
        }
        switch (n3) {
            case 1: {
                d3 = d2 * (double)GraphicsUtils.getSystemDpiY();
                break;
            }
            case 5: {
                d3 = d2 * 300.0;
                break;
            }
            case 4: {
                d3 = d2;
                break;
            }
            case 6: {
                d3 = d2 * (double)25.4f;
                break;
            }
            case 0: 
            case 2: {
                d3 = d2 * (double)GraphicsUtils.getSystemDpiY();
                break;
            }
            case 3: {
                d3 = d2 * 72.0;
                break;
            }
            default: {
                throw new ArgumentException("Invalid GraphicsUnit");
            }
        }
        return (float)d3;
    }

    public static float getSystemDpiX() {
        if (c == 0.0f) {
            Bitmap bitmap = new Bitmap(1, 1);
            Graphics graphics = Graphics.fromImage(bitmap);
            c = graphics.getDpiX();
            d = graphics.getDpiY();
        }
        return c;
    }

    public static float getSystemDpiY() {
        if (d == 0.0f) {
            Bitmap bitmap = new Bitmap(1, 1);
            Graphics graphics = Graphics.fromImage(bitmap);
            c = graphics.getDpiX();
            d = graphics.getDpiY();
        }
        return d;
    }

    public static SizeF convertDpi(SizeF sizeF, float f2, float f3, float f4, float f5) {
        return new SizeF(GraphicsUtils.convertDpi(sizeF.getWidth(), f2, f4), GraphicsUtils.convertDpi(sizeF.getHeight(), f3, f5));
    }

    public static float convertDpi(float f2, float f3, float f4) {
        return f2 * f4 / f3;
    }

    public static float changeUnitOfValueOld(int n2, int n3, float f2, float f3) {
        float f4 = f3;
        double d2 = 0.0;
        double d3 = f4;
        float f5 = GraphicsUtils.getSystemDpiY();
        if (!(n2 != n3 || f2 == f5 || n2 == 1 && n3 == 2 || n3 == 1 && n2 == 2 || n3 == 2 && n2 == 2)) {
            return f4 * f2 / f5;
        }
        if (!(n2 == n3 || n2 == 1 && n3 == 2 || n3 == 1 && n2 == 2)) {
            switch (n2) {
                case 1: {
                    d2 = f4 / f5;
                    break;
                }
                case 5: {
                    d2 = f4 / 300.0f;
                    break;
                }
                case 4: {
                    d2 = f4;
                    break;
                }
                case 6: {
                    d2 = f4 / 25.4f;
                    break;
                }
                case 0: 
                case 2: {
                    d2 = f4 / f5;
                    break;
                }
                case 3: {
                    d2 = f4 / 72.0f;
                    break;
                }
                default: {
                    throw new ArgumentException("Invalid GraphicsUnit");
                }
            }
            switch (n3) {
                case 1: {
                    d3 = d2 * (double)f2;
                    break;
                }
                case 5: {
                    d3 = d2 * 300.0 * (double)(f2 / f5);
                    break;
                }
                case 4: {
                    d3 = d2 * (double)(f2 / f5);
                    break;
                }
                case 6: {
                    d3 = d2 * (double)25.4f * (double)(f2 / f5);
                    break;
                }
                case 0: 
                case 2: {
                    d3 = d2 * (double)f2;
                    break;
                }
                case 3: {
                    d3 = d2 * (double)f2;
                    break;
                }
                default: {
                    throw new ArgumentException("Invalid GraphicsUnit");
                }
            }
        }
        float f6 = (float)d3;
        return f6;
    }

    public static float changeUnitOfValue(int n2, int n3, float f2, float f3) {
        float f4 = f3;
        double d2 = 0.0;
        double d3 = f4;
        float f5 = GraphicsUtils.getSystemDpiY();
        if (!(n2 != n3 || f2 == f5 || n2 == 1 && n3 == 2 || n3 == 1 && n2 == 2 || n3 == 2 && n2 == 2)) {
            return f4 * f2 / f5;
        }
        if (!(n2 == n3 || n2 == 1 && n3 == 2 || n3 == 1 && n2 == 2)) {
            switch (n2) {
                case 1: {
                    d2 = f4 / f5;
                    break;
                }
                case 5: {
                    d2 = f4 / 300.0f;
                    break;
                }
                case 4: {
                    d2 = f4;
                    break;
                }
                case 6: {
                    d2 = f4 / 25.4f;
                    break;
                }
                case 0: 
                case 2: {
                    d2 = f4 / f5;
                    break;
                }
                case 3: {
                    d2 = f4 / 72.0f;
                    break;
                }
                default: {
                    throw new ArgumentException("Invalid GraphicsUnit");
                }
            }
            switch (n3) {
                case 1: {
                    d3 = d2 * (double)f2;
                    break;
                }
                case 5: {
                    d3 = d2 * (double)f2;
                    break;
                }
                case 4: {
                    d3 = d2 * (double)f2;
                    break;
                }
                case 6: {
                    d3 = d2 * (double)f2;
                    break;
                }
                case 0: 
                case 2: {
                    d3 = d2 * (double)f2;
                    break;
                }
                case 3: {
                    d3 = d2 * (double)f2;
                    break;
                }
                default: {
                    throw new ArgumentException("Invalid GraphicsUnit");
                }
            }
        }
        float f6 = (float)d3;
        return f6;
    }

    public static AffineTransform getFinalTransform(AffineTransform affineTransform, int n2, float f2) {
        double d2;
        AffineTransform affineTransform2 = null;
        if (n2 != 1 && Math.abs((d2 = (double)f2 * a[n2]) - 1.0) > (double)1.4E-45f) {
            affineTransform2 = AffineTransform.getScaleInstance(d2, d2);
        }
        if (affineTransform2 != null) {
            affineTransform2.concatenate(affineTransform);
        } else {
            affineTransform2 = affineTransform;
        }
        return affineTransform2;
    }

    public static Bitmap smoothSimple(Bitmap bitmap) {
        int n2;
        int n3;
        Bitmap bitmap2 = null;
        if (Image.isIndexedPixelFormat(bitmap.getPixelFormat())) {
            bitmap2 = new Bitmap(bitmap.getWidth(), bitmap.getHeight(), 2498570);
            Graphics graphics = Graphics.fromImage(bitmap2);
            graphics.drawImage((Image)bitmap, new Point(0, 0));
        } else {
            bitmap2 = (Bitmap)bitmap.deepClone();
        }
        int n4 = bitmap.getWidth();
        int n5 = bitmap.getHeight();
        int[][][] nArray = new int[n4][n5][4];
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                Color color = bitmap.getPixel(n3, n2);
                nArray[n3][n2][0] = color.getA() & 0xFF;
                nArray[n3][n2][1] = color.getR() & 0xFF;
                nArray[n3][n2][2] = color.getG() & 0xFF;
                nArray[n3][n2][3] = color.getB() & 0xFF;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                n6 += nArray[n3][n2][0];
                n7 += nArray[n3][n2][1];
                n8 += nArray[n3][n2][2];
                n9 += nArray[n3][n2][3];
                int n10 = Math.max(0, n3 - 1);
                int n11 = Math.min(n4 - 1, n3 + 1);
                int n12 = Math.max(0, n2 - 1);
                int n13 = Math.min(n5 - 1, n2 + 1);
                n6 += nArray[n10][n2][0];
                n7 += nArray[n10][n2][1];
                n8 += nArray[n10][n2][2];
                n9 += nArray[n10][n2][3];
                n6 += nArray[n3][n13][0];
                n7 += nArray[n3][n13][1];
                n8 += nArray[n3][n13][2];
                n9 += nArray[n3][n13][3];
                n6 += nArray[n3][n12][0];
                n7 += nArray[n3][n12][1];
                n8 += nArray[n3][n12][2];
                n9 += nArray[n3][n12][3];
                bitmap2.setPixel(n3, n2, Color.fromArgb(((n6 += nArray[n11][n2][0]) / 5 + nArray[n3][n2][0]) / 2, ((n7 += nArray[n11][n2][1]) / 5 + nArray[n3][n2][1]) / 2, ((n8 += nArray[n11][n2][2]) / 5 + nArray[n3][n2][2]) / 2, ((n9 += nArray[n11][n2][3]) / 5 + nArray[n3][n2][3]) / 2));
            }
        }
        return bitmap2;
    }

    static {
        c = 0.0f;
        d = 0.0f;
    }
}

