/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.System.OverflowException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.CMYKColor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.CMYKHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Image;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering.DitheringBase;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.dithering.DitheringMode;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IIndexedColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialPixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public abstract class RasterImage
extends Image
implements IRasterImageArgb32PixelLoader {
    private DitheringMode a;
    private IRasterImageArgb32PixelLoader b = new RasterImageEmptyLoader(this);
    private int c;
    private IIndexedColorConverter d;
    private IColorConverter e;
    private int f;

    protected RasterImage() {
    }

    protected RasterImage(IColorPalette iColorPalette) {
        super(iColorPalette);
    }

    public int getRawDitheringMethod() {
        return this.c;
    }

    public void setRawDitheringMethod(int n2) {
        this.c = n2;
    }

    public IIndexedColorConverter getRawIndexedColorConverter() {
        return this.d;
    }

    public void setRawIndexedColorConverter(IIndexedColorConverter iIndexedColorConverter) {
        this.d = iIndexedColorConverter;
    }

    public IColorConverter getRawCustomColorConverter() {
        return this.e;
    }

    public void setRawCustomColorConverter(IColorConverter iColorConverter) {
        this.e = iColorConverter;
    }

    public int getRawFallbackIndex() {
        return this.f;
    }

    public void setRawFallbackIndex(int n2) {
        this.f = n2;
    }

    @Override
    public RawDataSettings getRawDataSettings() {
        RawDataSettings rawDataSettings = this.b.getRawDataSettings();
        rawDataSettings.setIndexedColorConverter(this.d);
        rawDataSettings.setFallbackIndex(this.f);
        rawDataSettings.setDitheringMethod(this.c);
        rawDataSettings.setCustomColorConverter(this.e);
        return rawDataSettings;
    }

    public PixelDataFormat getRawDataFormat() {
        return PixelDataFormat.getRgbIndexed1Bpp();
    }

    public int getRawLineSize() {
        return 0;
    }

    @Override
    public boolean isRawDataAvailable() {
        this.verifyNotDisposed();
        return this.b.isRawDataAvailable();
    }

    public double getHorizontalResolution() {
        return 96.0;
    }

    public void setHorizontalResolution(double d2) {
    }

    public double getVerticalResolution() {
        return 96.0;
    }

    public void setVerticalResolution(double d2) {
    }

    public DitheringMode getDitheringSettings() {
        return this.a;
    }

    public void setDitheringSettings(DitheringMode ditheringMode) {
        this.a = ditheringMode;
    }

    public boolean hasTransparentColor() {
        return false;
    }

    public void setTransparentColor(boolean bl2) {
    }

    public int getTransparentColor() {
        return 0;
    }

    public void setTransparentColor(int n2) {
    }

    public IRasterImageArgb32PixelLoader getDataLoader() {
        return this.b;
    }

    public void setDataLoader(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        if (iRasterImageArgb32PixelLoader == null) {
            throw new ArgumentNullException("value");
        }
        if (iRasterImageArgb32PixelLoader != this.b) {
            IDisposable iDisposable = Operators.as(this.b, IDisposable.class);
            if (iDisposable != null) {
                iDisposable.dispose();
            }
            this.b = iRasterImageArgb32PixelLoader;
        }
    }

    public void getDefaultPixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        PartialDefaultPixelLoader partialDefaultPixelLoader = new PartialDefaultPixelLoader(this, iPartialArgb32PixelLoader);
        PartialProcessor.process(rectangle.Clone(), partialDefaultPixelLoader);
    }

    public void getDefaultRawData(Rectangle rectangle, IPartialRawDataLoader iPartialRawDataLoader, RawDataSettings rawDataSettings) {
        PartialDefaultRawDataLoader partialDefaultRawDataLoader = new PartialDefaultRawDataLoader(this, iPartialRawDataLoader, rawDataSettings);
        PartialProcessor.process(rectangle.Clone(), partialDefaultRawDataLoader);
    }

    public int[] getDefaultArgb32Pixels(Rectangle rectangle) {
        int[] nArray;
        int n2 = 0;
        if (this.getPalette() != null) {
            n2 = this.getPalette().getArgb32Color(0);
        }
        try {
            nArray = new int[(int)(Operators.castToInt64(rectangle.getWidth(), 9) * (long)rectangle.getHeight())];
        }
        catch (OverflowException overflowException) {
            throw new OutOfMemoryException();
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = n2;
        }
        return nArray;
    }

    public byte[] getDefaultRawData(Rectangle rectangle, RawDataSettings rawDataSettings) {
        byte[] byArray;
        long l2;
        if (rawDataSettings == null) {
            throw new ArgumentNullException("rawDataSettings");
        }
        int n2 = rectangle.getLeft();
        int n3 = rectangle.getRight();
        if (n2 == 0 && n3 == this.getWidth()) {
            l2 = rawDataSettings.getLineSize();
        } else {
            int n4 = rawDataSettings.getPixelDataFormat().getBitsPerPixel();
            int n5 = n4 * n2 / 8;
            int n6 = (n4 * n3 + 7) / 8;
            l2 = n6 - n5;
        }
        long l3 = rectangle.getHeight();
        long l4 = l2 * l3;
        try {
            byArray = new byte[(int)l4];
        }
        catch (OverflowException overflowException) {
            throw new OutOfMemoryException();
        }
        return byArray;
    }

    public int getArgb32Pixel(int n2, int n3) {
        this.verifyNotDisposed();
        Rectangle rectangle = new Rectangle(n2, n3, 1, 1);
        StandardLoadPixelsPartialProcessor standardLoadPixelsPartialProcessor = new StandardLoadPixelsPartialProcessor(rectangle.Clone());
        this.a(rectangle.Clone(), true, standardLoadPixelsPartialProcessor);
        if (standardLoadPixelsPartialProcessor.getPixels() == null || standardLoadPixelsPartialProcessor.getPixels().length == 0) {
            throw new FrameworkException("Cannot get pixel in evaluation mode. Please set license first.");
        }
        return standardLoadPixelsPartialProcessor.getPixels()[0];
    }

    public int getPixel(int n2, int n3) {
        return this.getArgb32Pixel(n2, n3);
    }

    public void setArgb32Pixel(int n2, int n3, int n4) {
        this.verifyNotDisposed();
        this.a(new Rectangle(n2, n3, 1, 1), new int[]{n4}, true);
    }

    public void setPixel(int n2, int n3, int n4) {
        this.setArgb32Pixel(n2, n3, n4);
    }

    public int[] readScanLine(int n2) {
        this.verifyNotDisposed();
        Rectangle rectangle = new Rectangle(0, n2, this.getWidth(), 1);
        StandardLoadPixelsPartialProcessor standardLoadPixelsPartialProcessor = new StandardLoadPixelsPartialProcessor(rectangle.Clone());
        this.a(rectangle.Clone(), true, standardLoadPixelsPartialProcessor);
        return standardLoadPixelsPartialProcessor.getPixels();
    }

    public void writeScanLine(int n2, int[] nArray) {
        this.verifyNotDisposed();
        this.a(new Rectangle(0, n2, this.getWidth(), 1), nArray, true);
    }

    @Override
    public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        this.verifyNotDisposed();
        this.a(rectangle.Clone(), true, iPartialArgb32PixelLoader);
    }

    public void loadPartialPixels(Rectangle rectangle, IPartialPixelLoader iPartialPixelLoader) {
        this.verifyNotDisposed();
        this.a(rectangle.Clone(), true, new PartialLoaderWrapper(iPartialPixelLoader));
    }

    public int[] loadArgb32Pixels(Rectangle rectangle) {
        this.verifyNotDisposed();
        StandardLoadPixelsPartialProcessor standardLoadPixelsPartialProcessor = new StandardLoadPixelsPartialProcessor(rectangle.Clone());
        this.a(rectangle.Clone(), true, standardLoadPixelsPartialProcessor);
        return standardLoadPixelsPartialProcessor.getPixels();
    }

    public int[] loadPixels(Rectangle rectangle) {
        return this.loadArgb32Pixels(rectangle.Clone());
    }

    public CMYKColor[] loadCMYKPixels(Rectangle rectangle) {
        this.verifyNotDisposed();
        StandardLoadPixelsPartialProcessor standardLoadPixelsPartialProcessor = new StandardLoadPixelsPartialProcessor(rectangle.Clone());
        this.a(rectangle.Clone(), true, standardLoadPixelsPartialProcessor);
        int[] nArray = standardLoadPixelsPartialProcessor.getPixels();
        CMYKColor[] cMYKColorArray = null;
        if (nArray != null) {
            cMYKColorArray = CMYKHelper.toCMYK(nArray);
        }
        return cMYKColorArray;
    }

    @Override
    public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
        this.verifyNotDisposed();
        this.a(rectangle.Clone(), true, rawDataSettings, iPartialRawDataLoader);
    }

    public void saveRawData(byte[] byArray, int n2, Rectangle rectangle, RawDataSettings rawDataSettings) {
        throw new NotImplementedException();
    }

    public void saveArgb32Pixels(Rectangle rectangle, int[] nArray) {
        this.verifyNotDisposed();
        this.a(rectangle.Clone(), nArray, true);
    }

    public void savePixels(Rectangle rectangle, int[] nArray) {
        this.saveArgb32Pixels(rectangle.Clone(), nArray);
    }

    public void saveCMYKPixels(Rectangle rectangle, CMYKColor[] cMYKColorArray) {
        this.saveArgb32Pixels(rectangle.Clone(), CMYKHelper.toColor(cMYKColorArray));
    }

    public void setResolution(double d2, double d3) {
    }

    @Override
    public void setPalette(IColorPalette iColorPalette, boolean bl2) {
        if (bl2) {
            Rectangle rectangle = this.getBounds().Clone();
            int[] nArray = this.loadArgb32Pixels(rectangle.Clone());
            this.setPalette(iColorPalette);
            this.saveArgb32Pixels(rectangle.Clone(), nArray);
        } else {
            this.setPalette(iColorPalette);
        }
    }

    @Override
    public void resize(int n2, int n3, int n4) {
        throw new NotImplementedException();
    }

    public void crop(Rectangle rectangle) {
        throw new NotImplementedException();
    }

    public void binarizeFixed(byte by2) {
        throw new NotImplementedException();
    }

    public void binarizeOtsu() {
        throw new NotImplementedException();
    }

    public void grayscale() {
        throw new NotImplementedException();
    }

    public void adjustBrightness(int n2) {
        throw new NotImplementedException();
    }

    public void adjustContrast(float f2) {
        throw new NotImplementedException();
    }

    public void adjustGamma(float f2, float f3, float f4) {
        throw new NotImplementedException();
    }

    public void adjustGamma(float f2) {
        throw new NotImplementedException();
    }

    public void crop(int n2, int n3, int n4, int n5) {
        this.crop(new Rectangle(n2, n4, this.getWidth() - n2 - n3, this.getHeight() - n4 - n5));
    }

    public void rotate(float f2, boolean bl2, int n2) {
        throw new NotImplementedException();
    }

    public void rotate(float f2) {
        this.rotate(f2, true, 0);
    }

    protected void loadPixelsInternal(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        PartialPixelLoader partialPixelLoader = new PartialPixelLoader(this.b, iPartialArgb32PixelLoader);
        PartialProcessor.process(rectangle.Clone(), partialPixelLoader);
    }

    protected abstract void savePixelsInternal(Rectangle var1, int[] var2);

    @Override
    protected void releaseManagedResources() {
        IDisposable iDisposable = Operators.as(this.b, IDisposable.class);
        if (iDisposable != null) {
            iDisposable.dispose();
        }
        this.b = null;
        super.releaseManagedResources();
    }

    private int[] a(Rectangle rectangle, boolean bl2, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        this.verifyNotDisposed();
        this.getFitRectangle(rectangle.Clone()).CloneTo(rectangle);
        if (this.a != null) {
            DitheringBase ditheringBase = DitheringBase.getDithering(this.a.getMethod(), this.a.getBits(), this.a.getCustomPalette(), this.getWidth(), this.getHeight(), rectangle.Clone(), iPartialArgb32PixelLoader);
            iPartialArgb32PixelLoader = ditheringBase;
            this.getBounds().CloneTo(rectangle);
        }
        return this.a(rectangle.Clone(), null, bl2, iPartialArgb32PixelLoader);
    }

    private void a(Rectangle rectangle, int[] nArray, boolean bl2) {
        this.verifyNotDisposed();
        this.getFitRectangle(rectangle.Clone(), nArray).CloneTo(rectangle);
        this.savePixelsInternal(rectangle.Clone(), nArray);
    }

    private int[] a(Rectangle rectangle, int[] nArray, boolean bl2, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        int[] nArray2 = null;
        this.loadPixelsInternal(rectangle.Clone(), iPartialArgb32PixelLoader);
        return nArray2;
    }

    private byte[] a(Rectangle rectangle, boolean bl2, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
        this.verifyNotDisposed();
        this.getFitRectangle(rectangle.Clone()).CloneTo(rectangle);
        byte[] byArray = new byte[8];
        this.a(rectangle.Clone(), byArray, bl2, rawDataSettings, iPartialRawDataLoader);
        return byArray;
    }

    private byte[] a(Rectangle rectangle, byte[] byArray, boolean bl2, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
        byte[] byArray2 = null;
        this.b.loadRawData(rectangle.Clone(), rawDataSettings, iPartialRawDataLoader);
        return byArray2;
    }

    private static class PartialLoaderWrapper
    implements IPartialArgb32PixelLoader {
        private final IPartialPixelLoader a;

        public PartialLoaderWrapper(IPartialPixelLoader iPartialPixelLoader) {
            this.a = iPartialPixelLoader;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            this.a.process(rectangle.Clone(), nArray, point.Clone(), point2.Clone());
        }
    }

    private static class ValidRawDataLoader
    implements IPartialRawDataLoader {
        private IPartialRawDataLoader a;
        private RasterImage b;
        private RawDataSettings c;

        public ValidRawDataLoader(RasterImage rasterImage, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            this.a = iPartialRawDataLoader;
            this.b = rasterImage;
            this.c = rawDataSettings;
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
            this.a.process(rectangle.Clone(), byArray, point.Clone(), point2.Clone());
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
            throw new NotImplementedException();
        }
    }

    private static class StandardLoadPixelsPartialProcessor
    implements IPartialArgb32PixelLoader {
        private int[] a;
        private Rectangle b = new Rectangle();

        public StandardLoadPixelsPartialProcessor(Rectangle rectangle) {
            rectangle.CloneTo(this.b);
        }

        public int[] getPixels() {
            return this.a;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            if (rectangle.equals(Operators.boxing(this.b))) {
                this.a = nArray;
            } else {
                Rectangle rectangle2 = Rectangle.intersect(this.b.Clone(), rectangle.Clone()).Clone();
                if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                    if (this.a == null) {
                        try {
                            this.a = new int[(int)(Operators.castToInt64(this.b.getWidth(), 9) * (long)this.b.getHeight())];
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw new FrameworkException("Cannot allocate so many bytes. Use LoadPartialPixels instead.");
                        }
                        catch (OverflowException overflowException) {
                            throw new FrameworkException("Cannot allocate so many bytes. Use LoadPartialPixels instead.");
                        }
                    }
                    if (rectangle.getLeft() == this.b.getLeft() && rectangle.getRight() == this.b.getRight()) {
                        int n2 = 0;
                        int n3 = (rectangle.getTop() - this.b.getTop()) * this.b.getWidth();
                        if (n3 < 0) {
                            n2 = n3 * -1;
                            n3 = 0;
                        }
                        System.arraycopy(nArray, n2, this.a, n3, rectangle2.getWidth() * rectangle2.getHeight());
                    } else {
                        int n4;
                        int n5 = 0;
                        int n6 = rectangle.getTop() - this.b.getTop();
                        if (n6 < 0) {
                            n5 = (this.b.getTop() - rectangle.getTop()) * rectangle.getWidth();
                            n6 = 0;
                        }
                        if ((n4 = rectangle.getLeft() - this.b.getLeft()) < 0) {
                            n5 += n4 * -1;
                            n4 = 0;
                        }
                        for (int i2 = 0; i2 < rectangle2.getHeight(); ++i2) {
                            int n7 = n5 + i2 * rectangle.getWidth();
                            int n8 = n6++ * this.b.getWidth() + n4;
                            System.arraycopy(nArray, n7, this.a, n8, rectangle2.getWidth());
                        }
                    }
                }
            }
        }
    }

    private static class ValidPixelsLoader
    implements IPartialArgb32PixelLoader {
        private IPartialArgb32PixelLoader a;
        private RasterImage b;

        public ValidPixelsLoader(RasterImage rasterImage, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            this.a = iPartialArgb32PixelLoader;
            this.b = rasterImage;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            this.a.process(rectangle.Clone(), nArray, point.Clone(), point2.Clone());
        }
    }

    private static class RasterImageFullWatermarkDrawer
    implements IPartialArgb32PixelLoader {
        private final RasterImage a;

        public RasterImageFullWatermarkDrawer(RasterImage rasterImage) {
            this.a = rasterImage;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            this.a.savePixelsInternal(rectangle.Clone(), nArray);
        }
    }

    private static class PartialDefaultRawDataLoader
    implements IPartialProcessor {
        private final IPartialRawDataLoader a;
        private final RasterImage b;
        private final RawDataSettings c;

        public PartialDefaultRawDataLoader(RasterImage rasterImage, IPartialRawDataLoader iPartialRawDataLoader, RawDataSettings rawDataSettings) {
            this.b = rasterImage;
            this.a = iPartialRawDataLoader;
            this.c = rawDataSettings;
        }

        @Override
        public void process(Rectangle rectangle) {
            byte[] byArray = this.b.getDefaultRawData(rectangle.Clone(), this.c);
            this.a.process(rectangle.Clone(), byArray, rectangle.getLocation().Clone(), new Point(rectangle.getRight(), rectangle.getBottom()));
        }
    }

    private static class PartialDefaultPixelLoader
    implements IPartialProcessor {
        private final IPartialArgb32PixelLoader a;
        private final RasterImage b;

        public PartialDefaultPixelLoader(RasterImage rasterImage, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            this.b = rasterImage;
            this.a = iPartialArgb32PixelLoader;
        }

        @Override
        public void process(Rectangle rectangle) {
            int[] nArray = this.b.getDefaultArgb32Pixels(rectangle.Clone());
            this.a.process(rectangle.Clone(), nArray, rectangle.getLocation().Clone(), new Point(rectangle.getRight(), rectangle.getBottom()));
        }
    }

    private static class RasterImageEmptyLoader
    implements IRasterImageArgb32PixelLoader {
        private final RasterImage a;

        public RasterImageEmptyLoader(RasterImage rasterImage) {
            this.a = rasterImage;
        }

        @Override
        public boolean isRawDataAvailable() {
            return true;
        }

        @Override
        public RawDataSettings getRawDataSettings() {
            RawDataSettings rawDataSettings = new RawDataSettings();
            rawDataSettings.setPixelDataFormat(PixelDataFormat.getRgb32Bpp());
            rawDataSettings.setLineSize(this.a.getWidth() * 4);
            return rawDataSettings;
        }

        @Override
        public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            this.a.getDefaultPixels(rectangle.Clone(), iPartialArgb32PixelLoader);
        }

        @Override
        public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
            this.a.getDefaultRawData(rectangle.Clone(), iPartialRawDataLoader, rawDataSettings);
        }
    }

    private static class PartialPixelLoader
    implements IPartialProcessor {
        private final IRasterImageArgb32PixelLoader a;
        private final IPartialArgb32PixelLoader b;

        public PartialPixelLoader(IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            this.a = iRasterImageArgb32PixelLoader;
            this.b = iPartialArgb32PixelLoader;
        }

        @Override
        public void process(Rectangle rectangle) {
            this.a.loadPartialArgb32Pixels(rectangle.Clone(), this.b);
        }
    }
}

