/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IIndexedColorConverter;

public class MapColorConverterDiffBits
extends ColorConverter {
    private static final int a = 256;
    protected final byte[] ConversionMap;
    private int b;
    private final int c;

    public MapColorConverterDiffBits(int n2, int n3, int n4, IColorPalette iColorPalette, PixelDataFormat pixelDataFormat, Rectangle rectangle, int n5, IColorPalette iColorPalette2, PixelDataFormat pixelDataFormat2, int n6, IIndexedColorConverter iIndexedColorConverter, int n7) {
        super(n2, n3, n4, pixelDataFormat, rectangle.Clone(), pixelDataFormat2, n5);
        if (iColorPalette == null) {
            throw new ArgumentNullException("sourcePalette");
        }
        if (iColorPalette2 == null) {
            throw new ArgumentNullException("destinationPalette");
        }
        int n8 = (int)msMath.pow(2.0, this.SourcePixelSize);
        int n9 = 8 / this.SourcePixelSize;
        int n10 = n8 - 1;
        int n11 = (int)msMath.pow(2.0, this.DestinationPixelSize);
        int n12 = n11 - 1;
        int n13 = 8 / this.DestinationPixelSize;
        this.b = n9 / n13;
        int n14 = n13;
        if (this.b == 0) {
            this.b = 1;
            n14 = n9;
        }
        this.c = 8 / this.b;
        int n15 = 256 * this.b;
        this.ConversionMap = new byte[n15];
        if (n6 == 1) {
            int[] nArray = MapColorConverterDiffBits.correctPaletteEntries(iColorPalette, this.SourcePixelSize).getArgb32Entries();
            for (int i2 = 0; i2 < 256; ++i2) {
                int n16 = 8 - this.SourcePixelSize;
                int n17 = 0;
                int n18 = 0;
                while (n17 < n9) {
                    byte by2 = 0;
                    int n19 = 8 - this.DestinationPixelSize;
                    for (int i3 = 0; i3 < n14; ++i3) {
                        int n20 = i2 >> n16 & n10;
                        int n21 = nArray[n20];
                        int n22 = iColorPalette2.getNearestColorIndex(n21);
                        if (n22 > n12) {
                            n22 = n7;
                        }
                        by2 = (byte)(by2 & 0xFF | n22 << n19 & 0xFF);
                        n16 -= this.SourcePixelSize;
                        n19 -= this.DestinationPixelSize;
                    }
                    this.ConversionMap[i2 + n18] = by2;
                    n17 += n14;
                    n18 += 256;
                }
            }
        } else if (n6 == 0) {
            for (int i4 = 0; i4 < 256; ++i4) {
                int n23 = 8 - this.SourcePixelSize;
                int n24 = 0;
                int n25 = 0;
                while (n24 < n9) {
                    byte by3 = 0;
                    int n26 = 8 - this.DestinationPixelSize;
                    for (int i5 = 0; i5 < n14; ++i5) {
                        int n27;
                        int n28 = n27 = i4 >> n23 & n10;
                        if (n27 > n12) {
                            n28 = n7;
                        }
                        by3 = (byte)(by3 & 0xFF | n28 << n26 & 0xFF);
                        n23 -= this.SourcePixelSize;
                        n26 -= this.DestinationPixelSize;
                    }
                    this.ConversionMap[i4 + n25] = by3;
                    n24 += n14;
                    n25 += 256;
                }
            }
        } else {
            byte[] byArray = MapColorConverterDiffBits.getConversionMap(iIndexedColorConverter, pixelDataFormat, pixelDataFormat2, n8, n11);
            for (int i6 = 0; i6 < 256; ++i6) {
                int n29 = 8 - this.SourcePixelSize;
                int n30 = 0;
                int n31 = 0;
                while (n30 < n9) {
                    byte by4 = 0;
                    int n32 = 8 - this.DestinationPixelSize;
                    for (int i7 = 0; i7 < n14; ++i7) {
                        int n33 = i6 >> n29 & n10;
                        int n34 = byArray[n33] & 0xFF;
                        by4 = (byte)(by4 & 0xFF | n34 << n32 & 0xFF);
                        n29 -= this.SourcePixelSize;
                        n32 -= this.DestinationPixelSize;
                    }
                    this.ConversionMap[i6 + n31] = by4;
                    n30 += n14;
                    n31 += 256;
                }
            }
        }
    }

    @Override
    protected void convert(byte[] byArray, int n2, int n3, int n4, int n5, byte[] byArray2, int n6, int n7) {
        int n8 = n4 * this.SourcePixelSize;
        int n9 = (n3 + n8 - 1) / 8;
        int n10 = n3 / 8;
        int n11 = n9 - n10 + 1;
        int n12 = n3 * this.b / 8;
        int n13 = ((n8 + n3) * this.b - 1) / 8;
        int n14 = n13 - n12 + 1;
        int n15 = n3 / this.c % this.b;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n16 = n2 + this.LineSize * i2;
            int n17 = i2 * n7 + n6;
            int n18 = n15 * 256;
            int n19 = 0;
            int n20 = n15;
            for (int i3 = 0; i3 < n11; ++i3) {
                byte by2 = byArray[n16++];
                int n21 = msMath.min(this.b, this.b - n20);
                n21 = msMath.min(n21, n14 - n19);
                for (int i4 = 0; i4 < n21; ++i4) {
                    byte by3 = this.ConversionMap[n18 + (by2 & 0xFF)];
                    byArray2[n17 + n19++] = by3;
                    n18 += 256;
                }
                n18 = 0;
                n20 = 0;
            }
        }
    }
}

